/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.processing;

import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.FluidStackHooks;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import net.minecraft.class_1657;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_1799;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2680;
import net.minecraft.class_3917;
import net.minecraft.class_3956;
import net.minecraft.class_7225;
import net.minecraft.class_8786;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.containers.SimpleInOutFluidStorage;
import rearth.oritech.api.networking.SyncField;
import rearth.oritech.api.networking.SyncType;
import rearth.oritech.block.base.entity.MultiblockMachineEntity;
import rearth.oritech.block.entity.MachineCoreEntity;
import rearth.oritech.client.init.ModScreens;
import rearth.oritech.client.ui.CentrifugeScreenHandler;
import rearth.oritech.init.BlockContent;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.recipes.OritechRecipe;
import rearth.oritech.init.recipes.OritechRecipeType;
import rearth.oritech.init.recipes.RecipeContent;
import rearth.oritech.util.FluidIngredient;
import rearth.oritech.util.InventorySlotAssignment;
import rearth.oritech.util.MachineAddonController;
import rearth.oritech.util.ScreenProvider;

public class CentrifugeBlockEntity
extends MultiblockMachineEntity
implements FluidApi.BlockProvider {
    @SyncField(value={SyncType.GUI_TICK})
    public final SimpleInOutFluidStorage fluidContainer;
    @SyncField(value={SyncType.GUI_OPEN})
    public boolean hasFluidAddon;

    public CentrifugeBlockEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.CENTRIFUGE_ENTITY, pos, state, Oritech.CONFIG.processingMachines.centrifugeData.energyPerTick());
        this.fluidContainer = new SimpleInOutFluidStorage(Oritech.CONFIG.processingMachines.centrifugeData.tankSizeInBuckets() * FluidStackHooks.bucketAmount(), this::method_5431);
        this.hasFluidAddon = false;
    }

    @Override
    public long getDefaultCapacity() {
        return Oritech.CONFIG.processingMachines.centrifugeData.energyCapacity();
    }

    @Override
    public long getDefaultInsertRate() {
        return Oritech.CONFIG.processingMachines.centrifugeData.maxEnergyInsertion();
    }

    @Override
    protected boolean canProceed(OritechRecipe recipe) {
        FluidStack output;
        if (!this.hasFluidAddon) {
            return super.canProceed(recipe);
        }
        if (!CentrifugeBlockEntity.recipeInputMatchesTank(this.fluidContainer.getInStack(), recipe)) {
            return false;
        }
        FluidStack fluidStack = output = recipe.getFluidOutputs().isEmpty() ? null : recipe.getFluidOutputs().getFirst();
        if (output != null && !output.isEmpty()) {
            if (this.fluidContainer.getOutStack().getAmount() + output.getAmount() > this.fluidContainer.getCapacity()) {
                return false;
            }
            if (!this.fluidContainer.getOutStack().isEmpty() && !output.isFluidEqual(this.fluidContainer.getOutStack())) {
                return false;
            }
        }
        return true;
    }

    @Override
    protected Optional<class_8786<OritechRecipe>> getRecipe() {
        if (!this.hasFluidAddon) {
            return super.getRecipe();
        }
        List candidates = Objects.requireNonNull(this.field_11863).method_8433().method_17877((class_3956)this.getOwnRecipeType(), this.getInputInventory(), this.field_11863);
        Optional<class_8786<OritechRecipe>> fluidRecipe = candidates.stream().filter(candidate -> CentrifugeBlockEntity.recipeInputMatchesTank(this.fluidContainer.getInStack(), (OritechRecipe)candidate.comp_1933())).findAny();
        if (fluidRecipe.isPresent()) {
            return fluidRecipe;
        }
        return this.getNormalRecipe();
    }

    private Optional<class_8786<OritechRecipe>> getNormalRecipe() {
        return this.field_11863.method_8433().method_8132((class_3956)RecipeContent.CENTRIFUGE, this.getInputInventory(), this.field_11863);
    }

    public static boolean recipeInputMatchesTank(FluidStack available, OritechRecipe recipe) {
        boolean recipeNeedsFluid;
        boolean bl = recipeNeedsFluid = recipe.getFluidInput() != null && recipe.getFluidInput().amount() > 0L;
        if (!recipeNeedsFluid) {
            return true;
        }
        boolean isTankEmpty = available.isEmpty();
        if (isTankEmpty) {
            return false;
        }
        FluidIngredient recipeFluid = recipe.getFluidInput();
        return recipeFluid.matchesFluid(available) && available.getAmount() >= recipe.getFluidInput().amount();
    }

    @Override
    protected void craftItem(OritechRecipe activeRecipe, List<class_1799> outputInventory, List<class_1799> inputInventory) {
        Optional<class_8786<OritechRecipe>> newRecipe;
        int chamberCount = this.getBaseAddonData().extraChambers() + 1;
        for (int i = 0; i < chamberCount && !(newRecipe = this.getRecipe()).isEmpty() && ((OritechRecipe)newRecipe.get().comp_1933()).equals(this.currentRecipe) && this.canOutputRecipe(activeRecipe) && this.canProceed(activeRecipe); ++i) {
            super.craftItem(activeRecipe, outputInventory, inputInventory);
            if (!this.hasFluidAddon) continue;
            this.craftFluids(activeRecipe);
        }
    }

    @Override
    public boolean supportExtraChambersAuto() {
        return false;
    }

    private void craftFluids(OritechRecipe activeRecipe) {
        FluidStack output;
        FluidIngredient input = activeRecipe.getFluidInput();
        FluidStack fluidStack = output = activeRecipe.getFluidOutputs().isEmpty() ? null : activeRecipe.getFluidOutputs().getFirst();
        if (input != null && input.amount() > 0L) {
            this.fluidContainer.getInputContainer().extract(this.fluidContainer.getInStack().copyWithAmount(input.amount()), false);
        }
        if (output != null && output.getAmount() > 0L) {
            this.fluidContainer.getOutputContainer().insert(output, false);
        }
    }

    @Override
    public void getAdditionalStatFromAddon(MachineAddonController.AddonBlock addonBlock) {
        if (addonBlock.state().method_26204().equals(BlockContent.MACHINE_FLUID_ADDON)) {
            this.hasFluidAddon = true;
        }
    }

    @Override
    public void resetAddons() {
        super.resetAddons();
        this.hasFluidAddon = false;
    }

    @Override
    public void initAddons(class_2338 brokenAddon) {
        this.hasFluidAddon = false;
        super.initAddons(brokenAddon);
        Optional coreCandidate = this.field_11863.method_35230(this.field_11867.method_10084(), BlockEntitiesContent.MACHINE_CORE_ENTITY);
        if (coreCandidate.isPresent()) {
            MachineCoreEntity core = (MachineCoreEntity)coreCandidate.get();
            core.resetCaches();
        }
        this.field_11863.method_8408(this.field_11867, this.method_11010().method_26204());
        this.field_11863.method_8408(this.field_11867.method_10084(), this.field_11863.method_8320(this.field_11867.method_10084()).method_26204());
    }

    @Override
    protected void method_11007(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11007(nbt, registryLookup);
        nbt.method_10556("fluidAddon", this.hasFluidAddon);
        this.fluidContainer.writeNbt(nbt, "");
    }

    @Override
    protected void method_11014(class_2487 nbt, class_7225.class_7874 registryLookup) {
        super.method_11014(nbt, registryLookup);
        this.hasFluidAddon = nbt.method_10577("fluidAddon");
        this.fluidContainer.readNbt(nbt, "");
    }

    @Override
    protected OritechRecipeType getOwnRecipeType() {
        if (this.hasFluidAddon) {
            return RecipeContent.CENTRIFUGE_FLUID;
        }
        return RecipeContent.CENTRIFUGE;
    }

    @Override
    public InventorySlotAssignment getSlotAssignments() {
        return new InventorySlotAssignment(0, 1, 1, 2);
    }

    @Override
    public List<ScreenProvider.GuiSlot> getGuiSlots() {
        return List.of(new ScreenProvider.GuiSlot(0, 56, 38), new ScreenProvider.GuiSlot(1, 113, 38, true), new ScreenProvider.GuiSlot(2, 113, 56, true));
    }

    @Override
    public class_3917<?> getScreenHandlerType() {
        return ModScreens.CENTRIFUGE_SCREEN;
    }

    @Override
    public int getInventorySize() {
        return 3;
    }

    @Override
    public List<class_2382> getCorePositions() {
        return List.of(new class_2382(0, 1, 0));
    }

    @Override
    public boolean inputOptionsEnabled() {
        return false;
    }

    @Override
    public List<class_2382> getAddonSlots() {
        return List.of(new class_2382(0, 0, -1), new class_2382(0, 0, 1));
    }

    @Override
    @Nullable
    public class_1703 createMenu(int syncId, class_1661 playerInventory, class_1657 player) {
        return new CentrifugeScreenHandler(syncId, playerInventory, this);
    }

    @Override
    public int getAnimationDuration() {
        return 180;
    }

    @Override
    public FluidApi.FluidStorage getFluidStorage(@Nullable class_2350 direction) {
        if (!this.hasFluidAddon) {
            return null;
        }
        return this.fluidContainer.getStorageForDirection(direction);
    }
}

