/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.block.entity.reactor;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import net.minecraft.class_1282;
import net.minecraft.class_1301;
import net.minecraft.class_1309;
import net.minecraft.class_1922;
import net.minecraft.class_1936;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_238;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_3419;
import net.minecraft.class_3481;
import net.minecraft.class_5558;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import rearth.oritech.block.blocks.reactor.NuclearExplosionBlock;
import rearth.oritech.init.BlockEntitiesContent;
import rearth.oritech.init.SoundContent;

public class NuclearExplosionEntity
extends class_2586
implements class_5558<NuclearExplosionEntity> {
    private long startTime = -1L;
    private final Set<class_2338> removedBlocks = new HashSet<class_2338>();
    private final Set<class_2338> borderBlocks = new HashSet<class_2338>();
    private final Set<DirectionExplosionWave> waves = new HashSet<DirectionExplosionWave>();
    private final int size;

    public NuclearExplosionEntity(class_2338 pos, class_2680 state, int size) {
        super(BlockEntitiesContent.REACTOR_EXPLOSION_ENTITY, pos, state);
        this.size = size;
    }

    public NuclearExplosionEntity(class_2338 pos, class_2680 state) {
        super(BlockEntitiesContent.REACTOR_EXPLOSION_ENTITY, pos, state);
        this.size = 9;
    }

    public void tick(class_1937 world, class_2338 pos, class_2680 state, NuclearExplosionEntity blockEntity) {
        long age;
        if (world.field_9236) {
            return;
        }
        int initialRadius = this.size;
        if (this.startTime == -1L) {
            this.startTime = world.method_8510();
            this.explosionSphere(initialRadius + 7, 200, pos);
            world.method_8396(null, pos, SoundContent.NUKE_EXPLOSION, class_3419.field_15245, 30.0f, 1.0f);
        }
        if ((age = world.method_8510() - this.startTime) == 1L) {
            this.createExplosionWaves(initialRadius);
        }
        if (age > 1L) {
            this.waves.forEach(DirectionExplosionWave::nextGeneration);
            this.processBorderBlocks(initialRadius * initialRadius);
        }
        if (age > (long)(initialRadius * 2)) {
            world.method_8501(pos, class_2246.field_10124.method_9564());
        }
    }

    private void createExplosionWaves(int initialRadius) {
        int rayCount = initialRadius / 2 + 3;
        List<class_243> directions = this.getRandomRayDirections(rayCount);
        for (class_243 direction : directions) {
            DirectionExplosionWave data = new DirectionExplosionWave(initialRadius, this.addRandomOffset(direction, 0.15f), this.field_11867.method_10069(0, this.field_11863.field_9229.method_39332(-initialRadius / 2, initialRadius / 2), 0).method_10062());
            this.waves.add(data);
        }
    }

    private void processBorderBlocks(int maxDist) {
        this.borderBlocks.forEach(target -> {
            if (this.removedBlocks.contains(target)) {
                return;
            }
            double distSq = target.method_10262((class_2382)this.field_11867);
            class_2680 targetBlock = this.field_11863.method_8320(target);
            double percentageDist = distSq / (double)(maxDist * maxDist) * 8.0;
            double percentageVaried = percentageDist * ((double)this.field_11863.field_9229.method_43057() * 0.6 - 0.3 + 1.0);
            boolean replaced = false;
            class_2680 replacementState = class_2246.field_10124.method_9564();
            if (targetBlock.method_26164(class_3481.field_15475)) {
                replaced = true;
                class_2680 class_26802 = replacementState = (double)this.field_11863.field_9229.method_43057() < 0.8 ? class_2246.field_22091.method_9564() : class_2246.field_10092.method_9564();
                if (percentageVaried < (double)0.4f) {
                    replacementState = class_2246.field_10124.method_9564();
                }
            } else if (targetBlock.method_26164(class_3481.field_15503)) {
                replaced = true;
                class_2680 class_26803 = replacementState = (double)this.field_11863.field_9229.method_43057() > 0.4 ? class_2246.field_37546.method_9564() : class_2246.field_10124.method_9564();
                if (percentageVaried < (double)0.6f) {
                    replacementState = class_2246.field_10124.method_9564();
                }
            } else if (targetBlock.method_26164(class_3481.field_15462) || targetBlock.method_27852(class_2246.field_10479)) {
                replaced = true;
                class_2680 class_26804 = replacementState = (double)this.field_11863.field_9229.method_43057() > 0.4 ? class_2246.field_10428.method_9564() : class_2246.field_10124.method_9564();
                if (percentageVaried < 0.5) {
                    replacementState = class_2246.field_10124.method_9564();
                }
            } else if (targetBlock.method_27852(class_2246.field_10219)) {
                replaced = true;
                replacementState = percentageVaried < 0.05 ? ((double)this.field_11863.field_9229.method_43057() > 0.5 ? class_2246.field_27165.method_9564() : class_2246.field_10092.method_9564()) : (percentageVaried < 0.3 ? ((double)this.field_11863.field_9229.method_43057() > 0.2 ? class_2246.field_27165.method_9564() : class_2246.field_10092.method_9564()) : (percentageVaried < 0.55 ? ((double)this.field_11863.field_9229.method_43057() > 0.1 ? class_2246.field_10253.method_9564() : class_2246.field_10092.method_9564()) : class_2246.field_10566.method_9564()));
                if ((double)this.field_11863.field_9229.method_43057() > 0.7) {
                    replaced = false;
                }
            } else if (targetBlock.method_27852(class_2246.field_10566)) {
                replaced = true;
                if (percentageVaried < 0.15) {
                    replacementState = (double)this.field_11863.field_9229.method_43057() > 0.6 ? class_2246.field_10253.method_9564() : class_2246.field_10092.method_9564();
                } else if (percentageVaried < 0.3) {
                    replacementState = (double)this.field_11863.field_9229.method_43057() > 0.3 ? class_2246.field_27165.method_9564() : class_2246.field_10253.method_9564();
                } else if (percentageVaried < 0.65) {
                    replacementState = (double)this.field_11863.field_9229.method_43057() > 0.2 ? class_2246.field_10253.method_9564() : class_2246.field_27165.method_9564();
                } else {
                    replaced = false;
                }
                if ((double)this.field_11863.field_9229.method_43057() > 0.1) {
                    replaced = false;
                }
            } else if (targetBlock.method_26164(class_3481.field_25806)) {
                replaced = true;
                if (percentageVaried < 0.3) {
                    replacementState = (double)this.field_11863.field_9229.method_43057() > 0.5 ? class_2246.field_28888.method_9564() : class_2246.field_10092.method_9564();
                } else if (percentageVaried < 0.5) {
                    replacementState = (double)this.field_11863.field_9229.method_43057() > 0.3 ? class_2246.field_10340.method_9564() : class_2246.field_10092.method_9564();
                } else if (percentageVaried < 0.7) {
                    replacementState = (double)this.field_11863.field_9229.method_43057() > 0.2 ? class_2246.field_10474.method_9564() : class_2246.field_10092.method_9564();
                } else {
                    replaced = false;
                }
            } else if (targetBlock.method_26164(class_3481.field_15466) || targetBlock.method_27852(class_2246.field_9979)) {
                replaced = true;
                replacementState = percentageVaried < 0.2 ? ((double)this.field_11863.field_9229.method_43057() > 0.7 ? class_2246.field_9979.method_9564() : class_2246.field_10092.method_9564()) : class_2246.field_10033.method_9564();
                if (percentageVaried > 0.8) {
                    replaced = false;
                }
            }
            if (replaced) {
                this.field_11863.method_30092(target, replacementState, 34, 1);
                if (this.field_11863.method_8320(target.method_10084()).method_45474() && (double)this.field_11863.field_9229.method_43057() > 0.97) {
                    this.field_11863.method_30092(target.method_10084(), class_2246.field_10036.method_9564(), 34, 0);
                }
            }
        });
        this.borderBlocks.clear();
    }

    private void collectExtraEdgeBlocks(class_2338 center) {
        class_2338.method_10097((class_2338)center.method_10069(-8, -8, -8), (class_2338)center.method_10069(8, 8, 8)).forEach(target -> {
            if (this.removedBlocks.contains(target)) {
                return;
            }
            class_2680 targetState = this.field_11863.method_8320(target);
            if (targetState.method_26215()) {
                return;
            }
            this.borderBlocks.add(target.method_10062());
        });
    }

    private int explosionSphere(int radius, int power, class_2338 pos) {
        int radiusSq = radius * radius;
        int radiusSqExtra = (radius + 3) * (radius + 3);
        int usedPower = 0;
        int hardBusters = radius;
        for (class_2338 target : class_2338.method_25996((class_2338)pos, (int)(radius + 3), (int)(radius + 3), (int)(radius + 3))) {
            if (this.removedBlocks.contains(target)) continue;
            double distSq = target.method_10262((class_2382)pos);
            if (distSq > (double)radiusSq) {
                if (!(distSq <= (double)radiusSqExtra)) continue;
                this.borderBlocks.add(target.method_10062());
                continue;
            }
            double removalPercentage = (distSq - (double)((float)radiusSq / 2.0f)) / (double)radiusSq;
            if ((double)this.field_11863.field_9229.method_43057() < removalPercentage - 0.2) {
                this.borderBlocks.add(target.method_10062());
                continue;
            }
            class_2680 targetState = this.field_11863.method_8320(target);
            class_2248 targetBlock = targetState.method_26204();
            float targetHardness = targetBlock.method_9520();
            if (targetBlock instanceof NuclearExplosionBlock || targetState.method_26215() && !targetState.method_26227().method_15771() || targetState.method_26214((class_1922)this.field_11863, pos) < 0.0f || targetHardness > (float)power && hardBusters-- < 0) continue;
            usedPower = (int)((float)usedPower + targetHardness);
            targetBlock.method_9585((class_1936)this.field_11863, pos, targetState);
            this.field_11863.method_30092(target, class_2246.field_10124.method_9564(), 34, 0);
            this.removedBlocks.add(target.method_10062());
            this.borderBlocks.remove(target.method_10062());
            List entityCandidates = this.field_11863.method_8390(class_1309.class, new class_238(pos.method_10059(new class_2382(radius, radius, radius)).method_46558(), pos.method_10081(new class_2382(radius, radius, radius)).method_46558()), class_1301.field_6157.and(class_1301.field_6156));
            entityCandidates.forEach(entity -> {
                double entityDist = entity.method_5707(pos.method_46558());
                double distPercentage = entityDist / (double)radiusSq;
                double damage = (double)radiusSq / distPercentage;
                System.out.println(entityDist + ":" + damage);
                entity.method_5643(new class_1282((class_6880)this.field_11863.method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42331)), (float)damage);
            });
        }
        return usedPower;
    }

    private List<class_243> getRandomRayDirections(int count) {
        ArrayList<class_243> rayDirections = new ArrayList<class_243>(count);
        double angleIncrement = Math.PI * 2 / (double)count;
        for (int i = 0; i < count; ++i) {
            double baseAngle = (double)i * angleIncrement;
            double randomPerturbation = ((double)this.field_11863.field_9229.method_43057() - 0.5) * (angleIncrement / 2.0);
            double angle = baseAngle + randomPerturbation;
            double x = Math.cos(angle);
            double z = Math.sin(angle);
            rayDirections.add(new class_243(x, 0.0, z));
        }
        return rayDirections;
    }

    private class_243 addRandomOffset(class_243 direction, float amount) {
        return direction.method_1031((double)(this.field_11863.field_9229.method_43057() * amount - amount / 2.0f), (double)(this.field_11863.field_9229.method_43057() * amount - amount / 2.0f), (double)(this.field_11863.field_9229.method_43057() * amount - amount / 2.0f));
    }

    private class DirectionExplosionWave {
        private final class_243 direction;
        private int lastRadius;
        private class_2338 lastPosition;
        private int lastRadiusReduction;

        private DirectionExplosionWave(int initialRadius, class_243 direction, class_2338 pos) {
            this.direction = direction;
            this.lastRadius = initialRadius;
            this.lastPosition = pos;
            this.lastRadiusReduction = 1;
        }

        private void nextGeneration() {
            boolean isLastGeneration;
            int expectedPower;
            int currentRadius = this.lastRadius - this.lastRadiusReduction;
            if (currentRadius <= 1) {
                return;
            }
            class_243 rayOffset = this.direction.method_1021((double)currentRadius);
            class_2338 target = this.lastPosition.method_10081((class_2382)class_2338.method_49638((class_2374)rayOffset));
            int power = currentRadius * 3;
            this.lastRadius = currentRadius;
            this.lastPosition = target;
            int usedPower = NuclearExplosionEntity.this.explosionSphere(currentRadius, power, target);
            if (usedPower > (expectedPower = currentRadius * currentRadius * currentRadius * 3)) {
                this.lastRadiusReduction = 2;
            }
            boolean bl = isLastGeneration = currentRadius - this.lastRadiusReduction <= 1;
            if (isLastGeneration) {
                NuclearExplosionEntity.this.collectExtraEdgeBlocks(target.method_10081((class_2382)class_2338.method_49638((class_2374)rayOffset.method_1021(3.0))));
            }
        }
    }
}

