/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.client.ui;

import io.wispforest.owo.ui.base.BaseOwoHandledScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Color;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.HorizontalAlignment;
import io.wispforest.owo.ui.core.OwoUIAdapter;
import io.wispforest.owo.ui.core.Positioning;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import io.wispforest.owo.ui.core.VerticalAlignment;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_1661;
import net.minecraft.class_1703;
import net.minecraft.class_2561;
import net.minecraft.class_437;
import net.minecraft.class_5250;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.api.networking.NetworkManager;
import rearth.oritech.block.entity.addons.InventoryProxyAddonBlockEntity;
import rearth.oritech.client.ui.BasicMachineScreen;
import rearth.oritech.client.ui.InventoryProxyScreenHandler;
import rearth.oritech.util.ScreenProvider;

public class InventoryProxyScreen
extends BaseOwoHandledScreen<FlowLayout, InventoryProxyScreenHandler> {
    private final List<ButtonComponent> buttons = new ArrayList<ButtonComponent>();

    public InventoryProxyScreen(InventoryProxyScreenHandler handler, class_1661 inventory, class_2561 title) {
        super((class_1703)handler, inventory, title);
    }

    @NotNull
    protected OwoUIAdapter<FlowLayout> createAdapter() {
        return OwoUIAdapter.create((class_437)this, Containers::verticalFlow);
    }

    protected void build(FlowLayout rootComponent) {
        rootComponent.surface(Surface.VANILLA_TRANSLUCENT).horizontalAlignment(HorizontalAlignment.CENTER).verticalAlignment(VerticalAlignment.CENTER);
        FlowLayout overlay = Containers.horizontalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)100));
        FlowLayout spacer = Containers.horizontalFlow((Sizing)Sizing.fixed((int)176), (Sizing)Sizing.fixed((int)71));
        rootComponent.child((Component)overlay.surface(BasicMachineScreen.ORITECH_PANEL));
        rootComponent.child((Component)spacer);
        for (ScreenProvider.GuiSlot slot : Objects.requireNonNull(((InventoryProxyScreenHandler)this.field_2797).controllerScreen).getGuiSlots()) {
            ButtonComponent button = Components.button((class_2561)class_2561.method_43470((String)" "), elem -> this.setActiveSlot(slot.index()));
            button.renderer(BasicMachineScreen.ORITECH_BUTTON);
            this.buttons.add(button);
            overlay.child(BasicMachineScreen.getItemFrame(slot.x(), slot.y()));
            overlay.child(button.sizing(Sizing.fixed((int)10)).positioning(Positioning.absolute((int)(slot.x() + 3), (int)(slot.y() + 3))));
        }
        for (int i = 0; i < this.buttons.size(); ++i) {
            ButtonComponent button = this.buttons.get(i);
            button.field_22763 = i != ((InventoryProxyScreenHandler)this.field_2797).selectedSlot;
        }
        this.addTitle(overlay);
        LabelComponent hint = Components.label((class_2561)class_2561.method_43471((String)"tooltip.oritech.addon_proxy_select"));
        hint.horizontalTextAlignment(HorizontalAlignment.CENTER);
        hint.color(new Color(0.2509804f, 0.2509804f, 0.2509804f));
        hint.sizing(Sizing.fixed((int)176), Sizing.content((int)2));
        overlay.child((Component)hint.positioning(Positioning.relative((int)50, (int)90)));
    }

    private void addTitle(FlowLayout overlay) {
        class_5250 blockTitle = ((InventoryProxyScreenHandler)this.field_2797).addonEntity.method_11010().method_26204().method_9518();
        LabelComponent label = Components.label((class_2561)blockTitle);
        label.color(new Color(0.2509804f, 0.2509804f, 0.2509804f));
        label.sizing(Sizing.fixed((int)176), Sizing.content((int)2));
        label.horizontalTextAlignment(HorizontalAlignment.CENTER);
        label.zIndex(1);
        overlay.child((Component)label.positioning(Positioning.relative((int)50, (int)2)));
    }

    private void setActiveSlot(int slot) {
        ((InventoryProxyScreenHandler)this.field_2797).selectedSlot = slot;
        for (int i = 0; i < this.buttons.size(); ++i) {
            ButtonComponent button = this.buttons.get(i);
            button.field_22763 = i != slot;
        }
        ((InventoryProxyScreenHandler)this.field_2797).addonEntity.setTargetSlot(slot);
        NetworkManager.sendToServer(new InventoryProxyAddonBlockEntity.InventoryProxySlotSelectorPacket(((InventoryProxyScreenHandler)this.field_2797).blockPos, slot));
    }
}

