/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.fabric;

import com.google.common.collect.Streams;
import dev.architectury.fluid.FluidStack;
import dev.architectury.hooks.fluid.fabric.FluidStackHooksFabric;
import java.lang.runtime.SwitchBootstraps;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import net.fabricmc.fabric.api.transfer.v1.context.ContainerItemContext;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidStorage;
import net.fabricmc.fabric.api.transfer.v1.fluid.FluidVariant;
import net.fabricmc.fabric.api.transfer.v1.storage.Storage;
import net.fabricmc.fabric.api.transfer.v1.storage.StorageView;
import net.fabricmc.fabric.api.transfer.v1.storage.base.SingleSlotStorage;
import net.fabricmc.fabric.api.transfer.v1.transaction.Transaction;
import net.fabricmc.fabric.api.transfer.v1.transaction.TransactionContext;
import net.fabricmc.fabric.api.transfer.v1.transaction.base.SnapshotParticipant;
import net.minecraft.class_1792;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2586;
import net.minecraft.class_2591;
import net.minecraft.class_2680;
import net.minecraft.class_3612;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import rearth.oritech.Oritech;
import rearth.oritech.api.fluid.BlockFluidApi;
import rearth.oritech.api.fluid.FluidApi;
import rearth.oritech.api.fluid.ItemFluidApi;
import rearth.oritech.api.fluid.containers.DelegatingFluidStorage;
import rearth.oritech.api.fluid.containers.SimpleItemFluidStorage;
import rearth.oritech.fabric.ItemStackStorage;
import rearth.oritech.util.StackContext;

public class FabricFluidApiImpl
implements BlockFluidApi,
ItemFluidApi {
    @Override
    public void registerBlockEntity(Supplier<class_2591<?>> typeSupplier) {
        FluidStorage.SIDED.registerForBlockEntity((entity, direction) -> {
            FluidApi.FluidStorage storage = ((FluidApi.BlockProvider)entity).getFluidStorage((class_2350)direction);
            if (storage == null) {
                return null;
            }
            if (storage instanceof FluidApi.MultiSlotStorage) {
                FluidApi.MultiSlotStorage inOutContainer = (FluidApi.MultiSlotStorage)storage;
                return MultiSlotWrapper.of(inOutContainer);
            }
            if (storage instanceof FluidApi.SingleSlotStorage) {
                FluidApi.SingleSlotStorage singleContainer = (FluidApi.SingleSlotStorage)storage;
                return SingleSlotContainerStorageWrapper.of(singleContainer);
            }
            if (storage instanceof DelegatingFluidStorage) {
                DelegatingFluidStorage delegatedStorage = (DelegatingFluidStorage)storage;
                return DelegatedContainerStorageWrapper.of(delegatedStorage);
            }
            Oritech.LOGGER.error("Error during fluid provider registration, unable to register a fluid container");
            Oritech.LOGGER.error("Erroring container type is: {}", typeSupplier.get());
            return null;
        }, typeSupplier.get());
    }

    @Override
    public void registerForItem(Supplier<class_1792> itemSupplier) {
        FluidStorage.ITEM.registerForItems((stack, context) -> SingleSlotContainerStorageWrapper.of(((FluidApi.ItemProvider)stack.method_7909()).getFluidStorage(stack)), new class_1935[]{(class_1935)itemSupplier.get()});
    }

    @Override
    public FluidApi.FluidStorage find(class_1937 world, class_2338 pos, @Nullable class_2680 state, @Nullable class_2586 entity, @Nullable class_2350 direction) {
        Storage candidate;
        Storage storage = candidate = (Storage)FluidStorage.SIDED.find(world, pos, state, entity, (Object)direction);
        int n = 0;
        return switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{SingleSlotContainerStorageWrapper.class, MultiSlotWrapper.class, DelegatedContainerStorageWrapper.class}, (Object)storage, n)) {
            case -1 -> null;
            case 0 -> {
                SingleSlotContainerStorageWrapper wrapper = (SingleSlotContainerStorageWrapper)storage;
                yield wrapper.container;
            }
            case 1 -> {
                MultiSlotWrapper wrapper = (MultiSlotWrapper)storage;
                yield wrapper.storage.getStorageForDirection(direction);
            }
            case 2 -> {
                DelegatedContainerStorageWrapper wrapper = (DelegatedContainerStorageWrapper)storage;
                yield wrapper.storage;
            }
            default -> new FabricStorageWrapper((Storage<FluidVariant>)candidate, null);
        };
    }

    @Override
    public FluidApi.FluidStorage find(class_1937 world, class_2338 pos, @Nullable class_2350 direction) {
        return this.find(world, pos, null, null, direction);
    }

    @Override
    public FluidApi.FluidStorage find(StackContext stack) {
        ContainerItemContext context = ContainerItemContext.ofSingleSlot((SingleSlotStorage)new ItemStackStorage(stack));
        Storage candidate = (Storage)FluidStorage.ITEM.find(stack.getValue(), (Object)context);
        if (candidate == null) {
            return null;
        }
        if (candidate instanceof SingleSlotContainerStorageWrapper) {
            SingleSlotContainerStorageWrapper wrapper = (SingleSlotContainerStorageWrapper)candidate;
            FluidApi.SingleSlotStorage singleSlotStorage = wrapper.container;
            if (singleSlotStorage instanceof SimpleItemFluidStorage) {
                SimpleItemFluidStorage itemContainer = (SimpleItemFluidStorage)singleSlotStorage;
                return itemContainer.withCallback(ignored -> stack.sync());
            }
        }
        return new FabricStorageWrapper((Storage<FluidVariant>)candidate, stack);
    }

    public static class SingleSlotContainerStorageWrapper
    extends SnapshotParticipant<FluidStack>
    implements Storage<FluidVariant> {
        public final FluidApi.SingleSlotStorage container;
        private Set<StorageView<FluidVariant>> contentView;

        public static SingleSlotContainerStorageWrapper of(@Nullable FluidApi.SingleSlotStorage container) {
            if (container == null) {
                return null;
            }
            return new SingleSlotContainerStorageWrapper(container);
        }

        public SingleSlotContainerStorageWrapper(FluidApi.SingleSlotStorage container) {
            this.container = container;
        }

        public boolean supportsInsertion() {
            return this.container.supportsInsertion();
        }

        public long insert(FluidVariant fluidVariant, long amount, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            transaction.addCloseCallback((transactionContext, result) -> {
                if (result.wasCommitted()) {
                    this.container.update();
                }
            });
            return this.container.insert(FluidStackHooksFabric.fromFabric((FluidVariant)fluidVariant, (long)amount), false);
        }

        public boolean supportsExtraction() {
            return this.container.supportsExtraction();
        }

        public long extract(FluidVariant fluidVariant, long amount, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            transaction.addCloseCallback((transactionContext, result) -> {
                if (result.wasCommitted()) {
                    this.container.update();
                }
            });
            return this.container.extract(FluidStackHooksFabric.fromFabric((FluidVariant)fluidVariant, (long)amount), false);
        }

        @NotNull
        public Iterator<StorageView<FluidVariant>> iterator() {
            if (this.contentView != null) {
                return this.contentView.iterator();
            }
            this.contentView = Collections.singleton(new StorageView<FluidVariant>(){

                public long extract(FluidVariant fluidVariant, long amount, TransactionContext transaction) {
                    return this.extract(fluidVariant, amount, transaction);
                }

                public boolean isResourceBlank() {
                    return container.getStack().getFluid().equals(class_3612.field_15906);
                }

                public FluidVariant getResource() {
                    return FluidStackHooksFabric.toFabric((FluidStack)container.getStack());
                }

                public long getAmount() {
                    return container.getStack().getAmount();
                }

                public long getCapacity() {
                    return container.getCapacity();
                }
            }.getUnderlyingView());
            return this.contentView.iterator();
        }

        protected FluidStack createSnapshot() {
            return this.container.getStack().copy();
        }

        protected void readSnapshot(FluidStack fluidVariantResourceAmount) {
            this.container.setStack(fluidVariantResourceAmount);
        }
    }

    public static class MultiSlotWrapper
    extends SnapshotParticipant<List<FluidStack>>
    implements Storage<FluidVariant> {
        public final FluidApi.MultiSlotStorage storage;

        public static MultiSlotWrapper of(FluidApi.MultiSlotStorage storage) {
            if (storage == null) {
                return null;
            }
            return new MultiSlotWrapper(storage);
        }

        private MultiSlotWrapper(FluidApi.MultiSlotStorage storage) {
            this.storage = storage;
        }

        public boolean supportsInsertion() {
            return this.storage.supportsInsertion();
        }

        public long insert(FluidVariant fluidVariant, long l, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            transaction.addCloseCallback((transactionContext, result) -> {
                if (result.wasCommitted()) {
                    this.storage.update();
                }
            });
            return this.storage.insert(FluidStackHooksFabric.fromFabric((FluidVariant)fluidVariant, (long)l), false);
        }

        public boolean supportsExtraction() {
            return this.storage.supportsExtraction();
        }

        public long extract(FluidVariant fluidVariant, long l, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            transaction.addCloseCallback((transactionContext, result) -> {
                if (result.wasCommitted()) {
                    this.storage.update();
                }
            });
            return this.storage.extract(FluidStackHooksFabric.fromFabric((FluidVariant)fluidVariant, (long)l), false);
        }

        @NotNull
        public Iterator<StorageView<FluidVariant>> iterator() {
            return this.storage.getContent().stream().map(stack -> new StorageView<FluidVariant>(){
                final /* synthetic */ MultiSlotWrapper this$0;
                {
                    this.this$0 = this$0;
                }

                public long extract(FluidVariant fluidVariant, long l, TransactionContext transactionContext) {
                    return this.this$0.extract(fluidVariant, l, transactionContext);
                }

                public boolean isResourceBlank() {
                    return stack.isEmpty();
                }

                public FluidVariant getResource() {
                    return FluidStackHooksFabric.toFabric((FluidStack)stack);
                }

                public long getAmount() {
                    return stack.getAmount();
                }

                public long getCapacity() {
                    return this.this$0.storage.getCapacity();
                }
            }.getUnderlyingView()).iterator();
        }

        protected List<FluidStack> createSnapshot() {
            return this.storage.getContent().stream().map(FluidStack::copy).toList();
        }

        protected void readSnapshot(List<FluidStack> fluidStacks) {
            for (int i = 0; i < fluidStacks.size(); ++i) {
                this.storage.setStack(i, fluidStacks.get(i));
            }
        }
    }

    public static class DelegatedContainerStorageWrapper
    extends SnapshotParticipant<List<FluidStack>>
    implements Storage<FluidVariant> {
        private final DelegatingFluidStorage storage;

        public static DelegatedContainerStorageWrapper of(DelegatingFluidStorage storage) {
            if (storage == null) {
                return null;
            }
            return new DelegatedContainerStorageWrapper(storage);
        }

        private DelegatedContainerStorageWrapper(DelegatingFluidStorage storage) {
            this.storage = storage;
        }

        public boolean supportsInsertion() {
            return this.storage.supportsInsertion();
        }

        public long insert(FluidVariant fluidVariant, long l, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            transaction.addCloseCallback((transactionContext, result) -> {
                if (result.wasCommitted()) {
                    this.storage.update();
                }
            });
            return this.storage.insert(FluidStackHooksFabric.fromFabric((FluidVariant)fluidVariant, (long)l), false);
        }

        public boolean supportsExtraction() {
            return this.storage.supportsExtraction();
        }

        public long extract(FluidVariant fluidVariant, long l, TransactionContext transaction) {
            this.updateSnapshots(transaction);
            transaction.addCloseCallback((transactionContext, result) -> {
                if (result.wasCommitted()) {
                    this.storage.update();
                }
            });
            return this.storage.extract(FluidStackHooksFabric.fromFabric((FluidVariant)fluidVariant, (long)l), false);
        }

        @NotNull
        public Iterator<StorageView<FluidVariant>> iterator() {
            return this.storage.getContent().stream().map(stack -> new StorageView<FluidVariant>(){
                final /* synthetic */ DelegatedContainerStorageWrapper this$0;
                {
                    this.this$0 = this$0;
                }

                public long extract(FluidVariant fluidVariant, long l, TransactionContext transactionContext) {
                    return this.this$0.extract(fluidVariant, l, transactionContext);
                }

                public boolean isResourceBlank() {
                    return stack.isEmpty();
                }

                public FluidVariant getResource() {
                    return FluidStackHooksFabric.toFabric((FluidStack)stack);
                }

                public long getAmount() {
                    return stack.getAmount();
                }

                public long getCapacity() {
                    return this.this$0.storage.getCapacity();
                }
            }.getUnderlyingView()).iterator();
        }

        protected List<FluidStack> createSnapshot() {
            return this.storage.getContent().stream().map(FluidStack::copy).toList();
        }

        protected void readSnapshot(List<FluidStack> fluidStacks) {
            this.storage.setContent(fluidStacks);
        }
    }

    public static class FabricStorageWrapper
    extends FluidApi.FluidStorage {
        public final Storage<FluidVariant> storage;
        @Nullable
        public final StackContext context;

        public FabricStorageWrapper(Storage<FluidVariant> storage, @Nullable StackContext context) {
            this.storage = storage;
            this.context = context;
        }

        @Override
        public long insert(FluidStack in, boolean simulate) {
            try (Transaction transaction = Transaction.openOuter();){
                long inserted = this.storage.insert((Object)FluidStackHooksFabric.toFabric((FluidStack)in), in.getAmount(), (TransactionContext)transaction);
                if (!simulate) {
                    transaction.commit();
                }
                long l = inserted;
                return l;
            }
        }

        @Override
        public long extract(FluidStack out, boolean simulate) {
            try (Transaction transaction = Transaction.openOuter();){
                long extracted = this.storage.extract((Object)FluidStackHooksFabric.toFabric((FluidStack)out), out.getAmount(), (TransactionContext)transaction);
                if (!simulate) {
                    transaction.commit();
                }
                long l = extracted;
                return l;
            }
        }

        @Override
        public List<FluidStack> getContent() {
            return Streams.stream((Iterator)this.storage.iterator()).map(FluidStackHooksFabric::fromFabric).toList();
        }

        @Override
        public void update() {
            if (this.context != null) {
                this.context.sync();
            }
        }

        @Override
        public long getCapacity() {
            Oritech.LOGGER.warn("tried to access capacity of external container");
            return 0L;
        }
    }
}

