/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.init.world.features.resourcenode;

import com.mojang.serialization.Codec;
import java.util.List;
import net.minecraft.class_1922;
import net.minecraft.class_2246;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3031;
import net.minecraft.class_3756;
import net.minecraft.class_5281;
import net.minecraft.class_5819;
import net.minecraft.class_5821;
import net.minecraft.class_7923;
import rearth.oritech.Oritech;
import rearth.oritech.init.world.features.resourcenode.ResourceNodeFeatureConfig;

public class ResourceNodeFeature
extends class_3031<ResourceNodeFeatureConfig> {
    public ResourceNodeFeature(Codec<ResourceNodeFeatureConfig> configCodec) {
        super(configCodec);
    }

    public boolean method_13151(class_5821<ResourceNodeFeatureConfig> context) {
        class_2338 testPos;
        class_5281 world = context.method_33652();
        class_2338 origin = context.method_33655();
        if (world.method_8608()) {
            return false;
        }
        boolean solidBlockFound = false;
        class_2338 deepNodePos = testPos = new class_2338((class_2382)origin);
        class_2338 boulderPos = testPos;
        for (int y = origin.method_10264(); y > world.method_31607(); --y) {
            class_2338 downPos = testPos.method_10074();
            class_2680 testState = world.method_8320(downPos);
            if (testState.method_27852(class_2246.field_9987)) {
                deepNodePos = testPos;
                break;
            }
            if (testState.method_26212((class_1922)world, downPos) && !solidBlockFound) {
                boulderPos = testPos = downPos;
                solidBlockFound = true;
                continue;
            }
            testPos = downPos;
        }
        if (!solidBlockFound || boulderPos.method_10264() < deepNodePos.method_10264() + 10) {
            return false;
        }
        if (Oritech.CONFIG.easyFindFeatures()) {
            this.placeSurfaceBoulder(boulderPos, context);
        }
        this.placeBedrockNode(deepNodePos, context);
        Oritech.LOGGER.debug("placing resource node at " + String.valueOf(boulderPos) + " with deep " + String.valueOf(deepNodePos));
        return true;
    }

    private class_2680 getRandomBlockFromList(List<class_2960> list, class_5819 random) {
        return ((class_2248)class_7923.field_41175.method_10223(this.getRandomFromList(list, random))).method_9564();
    }

    private class_2960 getRandomFromList(List<class_2960> list, class_5819 random) {
        return list.get(random.method_43048(list.size()));
    }

    private void placeBedrockNode(class_2338 startPos, class_5821<ResourceNodeFeatureConfig> context) {
        class_5281 world = context.method_33652();
        class_5819 random = context.method_33654();
        List<class_2960> ores = ((ResourceNodeFeatureConfig)context.method_33656()).nodeOres();
        int radius = ((ResourceNodeFeatureConfig)context.method_33656()).nodeSize();
        class_2680 overlayBlock = ((class_2248)class_7923.field_41175.method_10223(((ResourceNodeFeatureConfig)context.method_33656()).overlayBlock())).method_9564();
        int overlayHeight = ((ResourceNodeFeatureConfig)context.method_33656()).overlayHeight();
        class_3756 noise = new class_3756(random);
        class_2338 centerPos = startPos.method_10086(radius - 2);
        for (class_2338 pos : class_2338.method_25996((class_2338)centerPos, (int)radius, (int)radius, (int)radius)) {
            if (Math.sqrt(pos.method_10262((class_2382)centerPos)) + noise.method_33658((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260()) > (double)radius || (double)pos.method_10264() >= (double)(startPos.method_10264() + overlayHeight + 3) + noise.method_33658((double)pos.method_10263(), (double)(pos.method_10264() + 2), (double)pos.method_10260())) continue;
            if (pos.method_10264() <= startPos.method_10264() + 1 && random.method_43058() <= (double)((ResourceNodeFeatureConfig)context.method_33656()).nodeOreChance()) {
                world.method_8652(pos, this.getRandomBlockFromList(ores, random), 16);
                continue;
            }
            if (pos.method_10264() > startPos.method_10264() + 1 && pos.method_10264() <= startPos.method_10264() + overlayHeight + 1) {
                world.method_8652(pos, overlayBlock, 16);
                continue;
            }
            if (pos.method_10264() <= startPos.method_10264() + 1) continue;
            world.method_8652(pos, class_2246.field_10124.method_9564(), 16);
        }
    }

    private void placeSurfaceBoulder(class_2338 startPos, class_5821<ResourceNodeFeatureConfig> context) {
        class_5281 world = context.method_33652();
        class_5819 random = context.method_33654();
        int radius = ((ResourceNodeFeatureConfig)context.method_33656()).boulderRadius();
        class_2338 movedCenter = startPos.method_30513(class_2350.class_2351.method_16699((class_5819)random), random.method_39332(0, radius - 1));
        List<class_2960> ores = ((ResourceNodeFeatureConfig)context.method_33656()).boulderOres();
        class_3756 noise = new class_3756(random);
        for (class_2338 pos : class_2338.method_25996((class_2338)movedCenter, (int)radius, (int)radius, (int)radius)) {
            if (Math.sqrt(pos.method_10262((class_2382)movedCenter)) > (double)radius + noise.method_33658((double)pos.method_10263(), (double)pos.method_10264(), (double)pos.method_10260())) continue;
            world.method_8652(pos, this.getRandomBlockFromList(ores, random), 16);
        }
    }
}

