/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.item.tools;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_124;
import net.minecraft.class_1268;
import net.minecraft.class_1282;
import net.minecraft.class_1297;
import net.minecraft.class_1309;
import net.minecraft.class_1322;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1836;
import net.minecraft.class_1890;
import net.minecraft.class_1937;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_3419;
import net.minecraft.class_437;
import net.minecraft.class_5134;
import net.minecraft.class_5250;
import net.minecraft.class_5819;
import net.minecraft.class_6880;
import net.minecraft.class_7924;
import net.minecraft.class_8111;
import net.minecraft.class_9274;
import net.minecraft.class_9285;
import net.minecraft.class_9362;
import org.jetbrains.annotations.NotNull;
import rearth.oritech.Oritech;
import rearth.oritech.init.SoundContent;
import rearth.oritech.item.tools.util.OritechEnergyItem;
import rearth.oritech.util.TooltipHelper;

public class ElectricMaceItem
extends class_9362
implements OritechEnergyItem {
    private static final int BASE_ATTACK_DAMAGE = Oritech.CONFIG.electricMace.baseDamage();
    private static final int RF_USAGE = Oritech.CONFIG.electricMace.energyUsage();
    public static final Map<Long, Runnable> PENDING_LIGHTNING_HITS = new HashMap<Long, Runnable>();

    public ElectricMaceItem(class_1792.class_1793 settings) {
        super(settings);
    }

    public static class_9285 createAttributeModifiers() {
        return class_9285.method_57480().method_57487(class_5134.field_23721, new class_1322(field_8006, (double)BASE_ATTACK_DAMAGE, class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_23723, new class_1322(field_8001, (double)-3.4f, class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_49079, new class_1322(Oritech.id("mace_fall_protection"), 10.0, class_1322.class_1323.field_6328), class_9274.field_49217).method_57487(class_5134.field_47759, new class_1322(Oritech.id("mace_reach"), 3.0, class_1322.class_1323.field_6328), class_9274.field_49217).method_57486();
    }

    public void method_59978(class_1799 stack, class_1309 target, class_1309 attacker) {
        float bonus = 0.0f;
        boolean usedEnergy = this.tryUseEnergy(stack, RF_USAGE, null);
        if (usedEnergy && ElectricMaceItem.method_58659((class_1309)attacker)) {
            attacker.method_37908().method_45447(null, target.method_24515(), SoundContent.ELECTRIC_SHOCK, class_3419.field_15248);
            attacker.method_38785();
            bonus = this.method_58403((class_1297)target, BASE_ATTACK_DAMAGE, new class_1282((class_6880)attacker.method_37908().method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42336), (class_1297)attacker));
        }
        if (attacker instanceof class_1657) {
            class_1657 player = (class_1657)attacker;
            class_1937 class_19372 = attacker.method_37908();
            if (class_19372 instanceof class_3218) {
                class_3218 serverWorld = (class_3218)class_19372;
                if (player.method_7357().method_7904((class_1792)this)) {
                    return;
                }
                player.method_7357().method_7906((class_1792)this, 40);
                this.createLightningAttack(serverWorld, player, target, stack, (int)((float)BASE_ATTACK_DAMAGE / 2.0f + bonus / 2.0f));
            }
        }
    }

    private void createLightningAttack(class_3218 world, class_1657 attacker, class_1309 target, class_1799 stack, int damage) {
        class_1937 class_19372;
        boolean usedEnergy = this.tryUseEnergy(stack, RF_USAGE * Oritech.CONFIG.electricMace.lightningCostMultiplier(), null);
        if (usedEnergy && (class_19372 = attacker.method_37908()) instanceof class_3218) {
            class_3218 serverWorld = (class_3218)class_19372;
            class_243 playerPos = attacker.method_33571();
            class_243 targetPos = target.method_33571();
            class_243 offset = targetPos.method_1020(playerPos);
            class_243 up = new class_243(0.0, 1.0, 0.0);
            class_243 cross = offset.method_1036(up).method_1029();
            class_243 pos = targetPos.method_1019(cross.method_1021(14.0)).method_49272(serverWorld.field_9229, 3.0f).method_1031(0.0, 7.0, 0.0);
            ElectricMaceItem.createLightningBolt(serverWorld, pos, target.method_33571().method_49272(serverWorld.field_9229, 0.1f), 10, 0.8f, 4.0, (class_2394)class_2398.field_11208, 0.35f, 2, 0);
            for (int i = 1; i <= 5; ++i) {
                class_243 ownPos = targetPos.method_1019(cross.method_1024((float)(i * 90)).method_1021(14.0)).method_49272(serverWorld.field_9229, 5.0f).method_1031(0.0, 7.0, 0.0);
                PENDING_LIGHTNING_HITS.put(serverWorld.method_8510() + (long)(10 * i), () -> {
                    ElectricMaceItem.createLightningBolt(serverWorld, ownPos, target.method_33571().method_49272(serverWorld.field_9229, 0.1f), 10, 0.8f, 4.0, (class_2394)class_2398.field_11208, 0.35f, 2, 0);
                    target.field_6235 = 0;
                    target.method_5643(new class_1282((class_6880)serverWorld.method_30349().method_30530(class_7924.field_42534).method_40290(class_8111.field_42336), (class_1297)attacker), (float)damage);
                });
            }
        }
    }

    public static void processLightningEvents(class_1937 world) {
        ArrayList<Long> toRemove = new ArrayList<Long>();
        for (Map.Entry<Long, Runnable> entry : PENDING_LIGHTNING_HITS.entrySet()) {
            Long key = entry.getKey();
            if (world.method_8510() <= key) continue;
            Runnable event = entry.getValue();
            event.run();
            toRemove.add(key);
        }
        toRemove.forEach(PENDING_LIGHTNING_HITS::remove);
    }

    public float method_58403(class_1297 target, float baseAttackDamage, class_1282 damageSource) {
        class_1297 attacker = damageSource.method_5526();
        if (attacker instanceof class_1309) {
            class_1309 livingEntity = (class_1309)attacker;
            if (!ElectricMaceItem.method_58659((class_1309)livingEntity)) {
                return 0.0f;
            }
            float fallDist = livingEntity.field_6017;
            float damage = fallDist <= 3.0f ? (float)BASE_ATTACK_DAMAGE * fallDist : (fallDist <= 8.0f ? (float)(BASE_ATTACK_DAMAGE * 4) + 4.0f * (fallDist - 3.0f) : (float)(BASE_ATTACK_DAMAGE * 6) + fallDist - 8.0f);
            class_1937 world = livingEntity.method_37908();
            if (world instanceof class_3218) {
                class_3218 serverWorld = (class_3218)world;
                return damage + class_1890.method_60160((class_3218)serverWorld, (class_1799)livingEntity.method_59958(), (class_1297)target, (class_1282)damageSource, (float)2.0f) * fallDist;
            }
            return damage;
        }
        return 0.0f;
    }

    public void method_7851(class_1799 stack, class_1792.class_9635 context, List<class_2561> tooltip, class_1836 type) {
        class_5250 text = class_2561.method_43469((String)"tooltip.oritech.energy_indicator", (Object[])new Object[]{TooltipHelper.getEnergyText(this.getStoredEnergy(stack)), TooltipHelper.getEnergyText(this.getEnergyCapacity(stack))});
        tooltip.add((class_2561)text.method_27692(class_124.field_1065));
        boolean showExtra = class_437.method_25441();
        if (showExtra) {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.electric_mace").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.electric_mace.1").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        } else {
            tooltip.add((class_2561)class_2561.method_43471((String)"tooltip.oritech.item_extra_info").method_27692(class_124.field_1080).method_27692(class_124.field_1056));
        }
    }

    public boolean method_7878(class_1799 stack, class_1799 ingredient) {
        return false;
    }

    public boolean method_7870(class_1799 stack) {
        return true;
    }

    public int method_31569(class_1799 stack) {
        return Math.round((float)this.getStoredEnergy(stack) * 100.0f / (float)this.getEnergyCapacity(stack) * 13.0f) / 100;
    }

    public boolean method_31567(class_1799 stack) {
        return true;
    }

    public int method_31571(class_1799 stack) {
        return 0xFF7007;
    }

    @Override
    public long getEnergyCapacity(class_1799 stack) {
        return Oritech.CONFIG.electricMace.energyCapacity();
    }

    @Override
    public long getEnergyMaxInput(class_1799 stack) {
        return this.getEnergyCapacity(stack) / 10L;
    }

    public boolean allowComponentsUpdateAnimation(class_1657 player, class_1268 hand, class_1799 oldStack, class_1799 newStack) {
        return false;
    }

    public boolean allowContinuingBlockBreaking(class_1657 player, class_1799 oldStack, class_1799 newStack) {
        return true;
    }

    public boolean shouldCauseReequipAnimation(@NotNull class_1799 oldStack, @NotNull class_1799 newStack, boolean slotChanged) {
        return false;
    }

    public boolean shouldCauseBlockBreakReset(@NotNull class_1799 oldStack, @NotNull class_1799 newStack) {
        return false;
    }

    public static void createLightningBolt(class_3218 level, class_243 startPos, class_243 endPos, int mainSegments, double jitterAmount, double particlesPerMeter, class_2394 particleEffect, float branchChance, int maxBranchDepth, int currentBranchDepth) {
        class_5819 random = level.method_8409();
        class_243 direction = endPos.method_1020(startPos);
        double totalDistance = direction.method_1033();
        if (totalDistance < 0.1) {
            level.method_14199(particleEffect, startPos.field_1352, startPos.field_1351, startPos.field_1350, 5, 0.1, 0.1, 0.1, 0.05);
            return;
        }
        class_243 segmentVector = direction.method_1029().method_1021(totalDistance / (double)mainSegments);
        class_243 previousPoint = startPos;
        if (currentBranchDepth == 0) {
            level.method_43128(null, endPos.field_1352, endPos.field_1351, endPos.field_1350, SoundContent.ELECTRIC_SHOCK, class_3419.field_15248, 0.8f, 0.5f + level.field_9229.method_43057() * 0.8f);
        }
        for (int i = 0; i < mainSegments; ++i) {
            class_243 currentTargetPoint;
            if (i < mainSegments - 1) {
                currentTargetPoint = startPos.method_1019(segmentVector.method_1021((double)(i + 1)));
                currentTargetPoint = currentTargetPoint.method_1031((random.method_43058() - 0.5) * 2.0 * jitterAmount, (random.method_43058() - 0.5) * 2.0 * jitterAmount, (random.method_43058() - 0.5) * 2.0 * jitterAmount);
            } else {
                currentTargetPoint = endPos;
            }
            ElectricMaceItem.spawnParticlesAlongSegment(level, previousPoint, currentTargetPoint, particlesPerMeter, particleEffect);
            if (currentBranchDepth < maxBranchDepth && random.method_43057() < branchChance && i < mainSegments - 1) {
                class_243 branchEndOffset = new class_243((random.method_43058() - 0.5) * totalDistance * 0.3, (random.method_43058() - 0.5) * totalDistance * 0.3, (random.method_43058() - 0.5) * totalDistance * 0.3);
                class_243 branchEnd = currentTargetPoint.method_1019(branchEndOffset);
                ElectricMaceItem.createLightningBolt(level, currentTargetPoint, branchEnd, Math.max(1, mainSegments / 2), jitterAmount * 0.7, particlesPerMeter * 0.7, particleEffect, branchChance * 0.5f, maxBranchDepth, currentBranchDepth + 1);
            }
            previousPoint = currentTargetPoint;
        }
    }

    private static void spawnParticlesAlongSegment(class_3218 level, class_243 p1, class_243 p2, double particlesPerMeter, class_2394 particleEffect) {
        class_243 segment = p2.method_1020(p1);
        double length = segment.method_1033();
        if (length < 0.01) {
            return;
        }
        class_243 unit = segment.method_1029();
        int numParticles = Math.max(1, (int)(length * particlesPerMeter));
        for (int i = 0; i < numParticles; ++i) {
            double progress = (double)i / (double)numParticles;
            class_243 particlePos = p1.method_1019(unit.method_1021(length * progress));
            level.method_14199(particleEffect, particlePos.field_1352, particlePos.field_1351, particlePos.field_1350, 1, 0.0, 0.0, 0.0, 0.0);
        }
    }
}

