/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import java.util.HashMap;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_243;
import net.minecraft.class_2586;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5819;
import net.minecraft.class_7923;
import rearth.oritech.Oritech;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.keyframe.event.SoundKeyframeEvent;

public class AutoPlayingSoundKeyframeHandler<A extends GeoAnimatable>
implements AnimationController.SoundKeyframeHandler<A> {
    private final Supplier<Float> speedSupplier;
    private final Map<class_2960, Long> lastPlayedAt = new HashMap<class_2960, Long>();

    public AutoPlayingSoundKeyframeHandler(Supplier<Float> speedSupplier) {
        this.speedSupplier = speedSupplier;
    }

    public AutoPlayingSoundKeyframeHandler() {
        this.speedSupplier = AutoPlayingSoundKeyframeHandler::getDefaultSpeed;
    }

    private static float getDefaultSpeed() {
        return 1.0f;
    }

    public void handle(SoundKeyframeEvent<A> event) {
        String[] segments = event.getKeyframeData().getSound().split("\\|");
        class_3414 sound = (class_3414)class_7923.field_41172.method_10223(class_2960.method_60654((String)segments[0]));
        if (sound != null) {
            long time = class_310.method_1551().field_1724.field_17892.method_8510();
            long age = time - this.lastPlayedAt.getOrDefault(sound.method_14833(), 0L);
            if (age < 30L) {
                return;
            }
            class_243 pos = class_310.method_1551().field_1724.method_33571();
            GeoAnimatable geoAnimatable = event.getAnimatable();
            if (geoAnimatable instanceof class_2586) {
                class_2586 blockEntity = (class_2586)geoAnimatable;
                pos = blockEntity.method_11016().method_46558();
            }
            double distance = Math.sqrt(class_310.method_1551().field_1773.method_19418().method_19326().method_1025(pos));
            double volumeFalloff = Math.min(1.0, 1.0 / (distance / 4.0));
            if (distance > 25.0) {
                return;
            }
            Float speed = this.speedSupplier.get();
            speed = Float.valueOf(Math.min(Math.max(speed.floatValue(), 0.125f), 8.0f));
            class_5819 random = class_310.method_1551().field_1687.field_9229;
            float volume = segments.length > 1 ? Float.parseFloat(segments[1]) : 1.0f;
            float pitch = segments.length > 2 ? Float.parseFloat(segments[2]) : 1.0f;
            class_3419 source = class_3419.field_15245;
            class_310.method_1551().field_1724.field_17892.method_45446(class_2338.method_49638((class_2374)pos), sound, source, volume *= (float)((double)(Oritech.CONFIG.machineVolumeMultiplier() * this.getPitchRandomMultiplier(random)) * volumeFalloff * 0.5), pitch *= speed.floatValue() * this.getPitchRandomMultiplier(random), true);
            this.lastPlayedAt.put(sound.method_14833(), time);
        }
    }

    private float getPitchRandomMultiplier(class_5819 random) {
        return random.method_43057() * 0.15f + 1.0f;
    }
}

