/*
 * Decompiled with CFR 0.152.
 */
package rearth.oritech.util;

import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2769;
import rearth.oritech.Oritech;
import rearth.oritech.api.energy.containers.DynamicEnergyStorage;
import rearth.oritech.api.item.ItemApi;
import rearth.oritech.block.blocks.addons.MachineAddonBlock;
import rearth.oritech.block.entity.addons.AddonBlockEntity;
import rearth.oritech.util.Geometry;
import rearth.oritech.util.ScreenProvider;

public interface MachineAddonController {
    public static final BaseAddonData DEFAULT_ADDON_DATA;

    public List<class_2338> getConnectedAddons();

    public List<class_2338> getOpenAddonSlots();

    public class_2338 getPosForAddon();

    public class_1937 getWorldForAddon();

    public class_2350 getFacingForAddon();

    public DynamicEnergyStorage getStorageForAddon();

    public ItemApi.InventoryStorage getInventoryForAddon();

    public ScreenProvider getScreenProvider();

    public List<class_2382> getAddonSlots();

    public BaseAddonData getBaseAddonData();

    public void setBaseAddonData(BaseAddonData var1);

    public long getDefaultCapacity();

    public long getDefaultInsertRate();

    default public float getCoreQuality() {
        return 1.0f;
    }

    default public void initAddons(class_2338 brokenAddon) {
        List<AddonBlock> foundAddons = this.getAllAddons(brokenAddon);
        this.gatherAddonStats(foundAddons);
        this.writeAddons(foundAddons);
        this.updateEnergyContainer();
        this.removeOldAddons(foundAddons);
        this.getConnectedAddons().clear();
        this.updateEnergyContainer();
        for (AddonBlock addon : foundAddons) {
            this.getConnectedAddons().add(addon.pos());
        }
    }

    private void removeOldAddons(List<AddonBlock> foundAddons) {
        for (class_2338 addon : this.getConnectedAddons()) {
            class_2680 state;
            if (!foundAddons.stream().noneMatch(newAddon -> newAddon.pos().equals((Object)addon)) || !((state = Objects.requireNonNull(this.getWorldForAddon()).method_8320(addon)).method_26204() instanceof MachineAddonBlock)) continue;
            this.getWorldForAddon().method_8501(addon, (class_2680)state.method_11657((class_2769)MachineAddonBlock.ADDON_USED, (Comparable)Boolean.valueOf(false)));
            this.getWorldForAddon().method_8452(addon, state.method_26204());
        }
    }

    default public void initAddons() {
        this.initAddons(null);
    }

    default public void resetAddons() {
        for (class_2338 addon : this.getConnectedAddons()) {
            class_2680 state = Objects.requireNonNull(this.getWorldForAddon()).method_8320(addon);
            if (!(state.method_26204() instanceof MachineAddonBlock)) continue;
            this.getWorldForAddon().method_8501(addon, (class_2680)state.method_11657((class_2769)MachineAddonBlock.ADDON_USED, (Comparable)Boolean.valueOf(false)));
            this.getWorldForAddon().method_8452(addon, state.method_26204());
        }
        this.getConnectedAddons().clear();
        this.updateEnergyContainer();
    }

    default public List<AddonBlock> getAllAddons(class_2338 brokenAddon) {
        boolean useLayered = Oritech.CONFIG.layeredExtenders();
        int maxIterationCount = (int)this.getCoreQuality() + 1;
        class_1937 world = this.getWorldForAddon();
        class_2338 pos = this.getPosForAddon();
        if (!1.$assertionsDisabled && world == null) {
            throw new AssertionError();
        }
        List<class_2338> openSlots = this.getOpenAddonSlots();
        openSlots.clear();
        int foundExtenders = 0;
        List<class_2382> baseSlots = this.getAddonSlots();
        HashSet<class_2338> searchedPositions = new HashSet<class_2338>(baseSlots.size());
        ArrayList<Object> queuedPositions = new ArrayList<Object>(baseSlots.size());
        ArrayList<AddonBlock> result = new ArrayList<AddonBlock>(baseSlots.size());
        for (class_2382 initialSpot : baseSlots) {
            queuedPositions.add((class_2338)Geometry.offsetToWorldPosition(this.getFacingForAddon(), initialSpot, (class_2382)pos));
        }
        HashSet<class_2338> toAdd = new HashSet<class_2338>();
        HashSet<class_2338> toRemove = new HashSet<class_2338>();
        for (int i = 0; i < maxIterationCount && !queuedPositions.isEmpty(); ++i) {
            for (class_2338 class_23382 : queuedPositions) {
                MachineAddonBlock addonBlock;
                class_2586 candidateEntity;
                class_2680 candidate;
                block12: {
                    block11: {
                        if (searchedPositions.contains(class_23382)) continue;
                        searchedPositions.add(class_23382);
                        toRemove.add(class_23382);
                        candidate = world.method_8320(class_23382);
                        candidateEntity = world.method_8321(class_23382);
                        if (class_23382.equals((Object)brokenAddon)) {
                            openSlots.add(class_23382);
                            continue;
                        }
                        class_2248 class_22482 = candidate.method_26204();
                        if (!(class_22482 instanceof MachineAddonBlock)) break block11;
                        addonBlock = (MachineAddonBlock)class_22482;
                        if (candidateEntity instanceof AddonBlockEntity) break block12;
                    }
                    if (class_23382.equals((Object)pos)) continue;
                    openSlots.add(class_23382);
                    continue;
                }
                AddonBlockEntity candidateAddonEntity = (AddonBlockEntity)candidateEntity;
                if (((Boolean)candidate.method_11654((class_2769)MachineAddonBlock.ADDON_USED)).booleanValue() && !candidateAddonEntity.getControllerPos().equals((Object)pos)) {
                    openSlots.add(class_23382);
                    continue;
                }
                if (addonBlock.getAddonSettings().extender()) {
                    if (foundExtenders >= maxIterationCount - 1 || useLayered) continue;
                    ++foundExtenders;
                }
                AddonBlock entry = new AddonBlock(addonBlock, candidate, class_23382, candidateAddonEntity);
                result.add(entry);
                if (!addonBlock.getAddonSettings().extender()) continue;
                Set<class_2338> neighbors = MachineAddonController.getNeighbors(class_23382);
                for (class_2338 neighbor : neighbors) {
                    if (searchedPositions.contains(neighbor)) continue;
                    toAdd.add(neighbor);
                }
            }
            queuedPositions.addAll(toAdd);
            queuedPositions.removeAll(toRemove);
            toAdd.clear();
            toRemove.clear();
        }
        return result;
    }

    default public void gatherAddonStats(List<AddonBlock> addons) {
        float speed = 1.0f;
        float efficiency = 1.0f;
        long energyAmount = 0L;
        long energyInsert = 0L;
        int extraChambers = 0;
        for (AddonBlock addon : addons) {
            MachineAddonBlock.AddonSettings addonSettings = addon.addonBlock().getAddonSettings();
            if (Oritech.CONFIG.additiveAddons()) {
                speed += 1.0f - addonSettings.speedMultiplier();
                efficiency += 1.0f - addonSettings.efficiencyMultiplier();
            } else {
                speed *= addonSettings.speedMultiplier();
                efficiency *= addonSettings.efficiencyMultiplier();
            }
            energyAmount += addonSettings.addedCapacity();
            energyInsert += addonSettings.addedInsert();
            extraChambers += addonSettings.chamberCount();
            this.getAdditionalStatFromAddon(addon);
        }
        if (Oritech.CONFIG.additiveAddons()) {
            speed = 1.0f / speed;
            float efficiencyChange = efficiency - 1.0f;
            efficiency = 1.0f / efficiency;
            if (efficiencyChange < 0.0f) {
                efficiency = 1.0f + Math.abs(efficiencyChange);
            }
        }
        BaseAddonData baseData = new BaseAddonData(speed, efficiency, energyAmount, energyInsert, extraChambers);
        this.setBaseAddonData(baseData);
    }

    default public void getAdditionalStatFromAddon(AddonBlock addonBlock) {
    }

    default public void writeAddons(List<AddonBlock> addons) {
        class_1937 world = this.getWorldForAddon();
        class_2338 pos = this.getPosForAddon();
        if (!1.$assertionsDisabled && world == null) {
            throw new AssertionError();
        }
        for (AddonBlock addon : addons) {
            class_2680 newState = (class_2680)addon.state().method_11657((class_2769)MachineAddonBlock.ADDON_USED, (Comparable)Boolean.valueOf(true));
            addon.addonEntity().setControllerPos(pos);
            world.method_8501(addon.pos(), newState);
        }
    }

    default public void updateEnergyContainer() {
        DynamicEnergyStorage energyStorage = this.getStorageForAddon();
        BaseAddonData addonData = this.getBaseAddonData();
        energyStorage.capacity = this.getDefaultCapacity() + addonData.energyBonusCapacity;
        energyStorage.maxInsert = this.getDefaultInsertRate() + addonData.energyBonusTransfer;
        energyStorage.amount = Math.min(energyStorage.amount, energyStorage.capacity);
    }

    default public void writeAddonToNbt(class_2487 nbt) {
        BaseAddonData data = this.getBaseAddonData();
        nbt.method_10548("speed", data.speed);
        nbt.method_10548("efficiency", data.efficiency);
        nbt.method_10544("energyBonusCapacity", data.energyBonusCapacity);
        nbt.method_10544("energyBonusTransfer", data.energyBonusTransfer);
        nbt.method_10569("extraChambers", data.extraChambers);
        class_2499 posList = new class_2499();
        for (class_2338 pos : this.getConnectedAddons()) {
            class_2487 posTag = new class_2487();
            posTag.method_10569("x", pos.method_10263());
            posTag.method_10569("y", pos.method_10264());
            posTag.method_10569("z", pos.method_10260());
            posList.add((Object)posTag);
        }
        nbt.method_10566("connectedAddons", (class_2520)posList);
    }

    default public void loadAddonNbtData(class_2487 nbt) {
        BaseAddonData data = new BaseAddonData(nbt.method_10583("speed"), nbt.method_10583("efficiency"), nbt.method_10537("energyBonusCapacity"), nbt.method_10537("energyBonusTransfer"), nbt.method_10550("extraChambers"));
        this.setBaseAddonData(data);
        class_2499 posList = nbt.method_10554("connectedAddons", 10);
        List<class_2338> connectedAddons = this.getConnectedAddons();
        for (class_2520 posTag : posList) {
            class_2487 posCompound = (class_2487)posTag;
            int x = posCompound.method_10550("x");
            int y = posCompound.method_10550("y");
            int z = posCompound.method_10550("z");
            class_2338 pos = new class_2338(x, y, z);
            connectedAddons.add(pos);
        }
    }

    private static Set<class_2338> getNeighbors(class_2338 pos) {
        return Set.of(pos.method_10069(-1, 0, 0), pos.method_10069(1, 0, 0), pos.method_10069(0, 0, -1), pos.method_10069(0, 0, 1), pos.method_10069(0, -1, 0), pos.method_10069(0, 1, 0));
    }

    static {
        if (1.$assertionsDisabled) {
            // empty if block
        }
        DEFAULT_ADDON_DATA = new BaseAddonData(1.0f, 1.0f, 0L, 0L, 0);
    }

    public record AddonBlock(MachineAddonBlock addonBlock, class_2680 state, class_2338 pos, AddonBlockEntity addonEntity) {
    }

    public record BaseAddonData(float speed, float efficiency, long energyBonusCapacity, long energyBonusTransfer, int extraChambers) {
    }
}

