/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.client.gui.screen;

import com.google.common.base.Function;
import com.google.common.collect.Lists;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.logging.LogUtils;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.gui.Widgets;
import io.github.mortuusars.exposure.client.gui.screen.album.ChildPhotographScreen;
import io.github.mortuusars.exposure.client.image.Image;
import io.github.mortuusars.exposure.client.image.PalettedImage;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.client.render.image.RenderCoordinates;
import io.github.mortuusars.exposure.client.task.ExportExposuresTask;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.data.ColorPalettes;
import io.github.mortuusars.exposure.data.export.ExportLook;
import io.github.mortuusars.exposure.data.export.ExportSize;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.item.util.ItemAndStack;
import io.github.mortuusars.exposure.world.level.storage.ExposureIdentifier;
import io.github.mortuusars.exposure_catalog.ExposureCatalog;
import io.github.mortuusars.exposure_catalog.client.gui.Mode;
import io.github.mortuusars.exposure_catalog.client.gui.Order;
import io.github.mortuusars.exposure_catalog.client.gui.Sorting;
import io.github.mortuusars.exposure_catalog.client.gui.screen.ConfirmScreen;
import io.github.mortuusars.exposure_catalog.client.gui.screen.SelectionHandler;
import io.github.mortuusars.exposure_catalog.client.gui.screen.Thumbnail;
import io.github.mortuusars.exposure_catalog.client.gui.screen.tooltip.BelowOrAboveAreaTooltipPositioner;
import io.github.mortuusars.exposure_catalog.client.gui.screen.widget.EnumButton;
import io.github.mortuusars.exposure_catalog.data.ExposureInfo;
import io.github.mortuusars.exposure_catalog.data.client.CatalogClient;
import io.github.mortuusars.exposure_catalog.network.Packets;
import io.github.mortuusars.exposure_catalog.network.packet.serverbound.CatalogClosedC2SP;
import io.github.mortuusars.exposure_catalog.network.packet.serverbound.DeleteExposureC2SP;
import io.github.mortuusars.exposure_catalog.network.packet.serverbound.QueryExposuresC2SP;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1129;
import net.minecraft.class_1144;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_1799;
import net.minecraft.class_1935;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_342;
import net.minecraft.class_344;
import net.minecraft.class_3518;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import net.minecraft.class_5244;
import net.minecraft.class_5250;
import net.minecraft.class_5348;
import net.minecraft.class_768;
import net.minecraft.class_7919;
import net.minecraft.class_8000;
import net.minecraft.class_8494;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CatalogScreen
extends class_437 {
    public static final class_8666 REFRESH_BUTTON_SPRITES = Widgets.threeStateSprites((class_2960)ExposureCatalog.resource("refresh"));
    public static final class_8666 EXPORT_BUTTON_SPRITES = Widgets.threeStateSprites((class_2960)ExposureCatalog.resource("export"));
    public static final class_8666 EXPORT_STOP_BUTTON_SPRITES = Widgets.threeStateSprites((class_2960)ExposureCatalog.resource("export_stop"));
    public static final class_8666 DELETE_BUTTON_SPRITES = Widgets.threeStateSprites((class_2960)ExposureCatalog.resource("delete"));
    public static final class_2960 TEXTURE = ExposureCatalog.resource("textures/gui/catalog.png");
    public static final int TEX_SIZE = 512;
    public static final int ROWS = 4;
    public static final int COLS = 6;
    protected static final int SCROLL_THUMB_TOP_HEIGHT = 3;
    protected static final int SCROLL_THUMB_MID_HEIGHT = 4;
    protected static final int SCROLL_THUMB_BOT_HEIGHT = 2;
    public static final int REFRESH_COOLDOWN_MS = 500;
    public static final int RELOAD_COOLDOWN_MS = 5000;
    protected final File stateFile;
    protected int imageWidth;
    protected int imageHeight;
    protected int leftPos;
    protected int topPos;
    protected class_768 windowArea;
    protected class_768 scrollBarArea;
    protected class_768 searchBarArea;
    protected class_768 thumbnailsArea;
    protected EnumButton<Order> orderButton;
    protected EnumButton<Sorting> sortingButton;
    protected class_342 searchBox;
    protected EnumButton<Mode> modeButton;
    protected class_768 scrollThumb;
    protected List<Thumbnail> thumbnails;
    protected class_4185 refreshButton;
    protected class_4185 exportButton;
    protected class_4185 exportStopButton;
    protected class_4185 deleteButton;
    protected Mode mode;
    protected Order order;
    protected Sorting sorting;
    protected ExportSize exportSize;
    protected ExportLook exportLook;
    protected boolean isLoading;
    protected boolean haveExposures;
    protected List<String> exposures;
    protected List<String> textures;
    protected ArrayList<String> filteredItems;
    protected SelectionHandler selection;
    protected int totalRows;
    protected int topRowIndex;
    protected boolean isThumbnailsGridFocused;
    protected int focusedThumbnailIndex;
    protected boolean isDraggingScrollbar;
    protected int topRowIndexAtDragStart;
    protected double dragDelta;
    protected boolean initialized;
    protected long refreshCooldownExpireTime;
    protected long lastScrolledTime;

    public CatalogScreen() {
        super((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog"));
        this.stateFile = new File(class_310.method_1551().field_1697, "exposure_catalog_state.json");
        this.windowArea = new class_768(0, 0, 361, 265);
        this.scrollBarArea = new class_768(343, 22, 10, 221);
        this.searchBarArea = new class_768(219, 7, 118, 10);
        this.thumbnailsArea = new class_768(8, 22, 329, 221);
        this.scrollThumb = new class_768(0, 0, 0, 0);
        this.thumbnails = Collections.synchronizedList(new ArrayList());
        this.mode = Mode.EXPOSURES;
        this.order = Order.ASCENDING;
        this.sorting = Sorting.DATE;
        this.exportSize = ExportSize.X1;
        this.exportLook = ExportLook.REGULAR;
        this.haveExposures = true;
        this.exposures = new ArrayList<String>();
        this.textures = Collections.emptyList();
        this.filteredItems = new ArrayList();
        this.selection = new SelectionHandler();
        this.totalRows = 0;
        this.topRowIndex = 0;
        this.isDraggingScrollbar = false;
        this.topRowIndexAtDragStart = 0;
        this.dragDelta = 0.0;
        this.refreshCooldownExpireTime = 0L;
        this.lastScrolledTime = 0L;
    }

    public void onExposuresReceived(Map<String, ExposureInfo> exposuresList) {
        this.isLoading = false;
        this.haveExposures = !exposuresList.isEmpty();
        this.exposures = new ArrayList<String>(exposuresList.keySet().stream().toList());
        this.orderAndSortExposuresList(this.order, this.sorting);
        if (this.mode == Mode.EXPOSURES) {
            this.topRowIndex = 0;
            this.refreshSearchResults();
        }
    }

    protected void method_25426() {
        super.method_25426();
        this.imageWidth = this.windowArea.method_3319();
        this.imageHeight = this.windowArea.method_3320();
        this.leftPos = this.field_22789 / 2 - this.imageWidth / 2;
        this.topPos = this.field_22790 / 2 - this.imageHeight / 2;
        this.scrollBarArea = new class_768(this.leftPos + 343, this.topPos + 22, 10, 221);
        this.searchBarArea = new class_768(this.leftPos + 219, this.topPos + 7, 118, 10);
        this.thumbnailsArea = new class_768(this.leftPos + 8, this.topPos + 22, 329, 221);
        this.orderButton = new EnumButton<Order>(Order.class, this.leftPos + 188, this.topPos + 6, 12, 12, ExposureCatalog.resource("order"), (b, prev, current) -> this.changeOrder((Order)current), (class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.order")){

            public void method_25354(class_1144 handler) {
                CatalogScreen.this.playClickSound();
            }
        };
        this.orderButton.setTooltipFunc((Function<Order, class_7919>)((Function)value -> {
            class_5250 component = class_2561.method_43471((String)"gui.exposure_catalog.catalog.order");
            for (Order v : Order.values()) {
                component.method_27693("\n ");
                component.method_10852((class_2561)class_2561.method_43471((String)("gui.exposure_catalog.catalog.order." + v.method_15434())).method_27696(class_2583.field_24360.method_36139(value == v ? 0x6677FF : 0x444444)));
            }
            return class_7919.method_47407((class_2561)component);
        }));
        this.method_37063((class_364)this.orderButton);
        this.sortingButton = new EnumButton<Sorting>(Sorting.class, this.leftPos + 203, this.topPos + 6, 12, 12, ExposureCatalog.resource("sorting"), (b, prev, current) -> this.changeSorting((Sorting)current), (class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.sorting")){

            public void method_25354(class_1144 handler) {
                CatalogScreen.this.playClickSound();
            }
        };
        this.sortingButton.setTooltipFunc((Function<Sorting, class_7919>)((Function)value -> {
            class_5250 component = class_2561.method_43471((String)"gui.exposure_catalog.catalog.sorting");
            for (Sorting v : Sorting.values()) {
                component.method_27693("\n ");
                component.method_10852((class_2561)class_2561.method_43471((String)("gui.exposure_catalog.catalog.sorting." + v.method_15434())).method_27696(class_2583.field_24360.method_36139(value == v ? 0x6677FF : 0x444444)));
            }
            return class_7919.method_47407((class_2561)component);
        }));
        this.method_37063((class_364)this.sortingButton);
        int n = this.searchBarArea.method_3321() + 1;
        int n2 = this.searchBarArea.method_3322() + 1;
        int n3 = this.searchBarArea.method_3319();
        Objects.requireNonNull(this.field_22793);
        this.searchBox = new class_342(this.field_22793, n, n2, n3, 9, (class_2561)class_2561.method_43471((String)"itemGroup.search"));
        this.searchBox.method_1880(99);
        this.searchBox.method_1858(false);
        this.searchBox.method_1862(true);
        this.searchBox.method_1868(0xFFFFFF);
        this.method_37063((class_364)this.searchBox);
        this.modeButton = new EnumButton<Mode>(Mode.class, this.leftPos + 342, this.topPos + 6, 12, 12, ExposureCatalog.resource("mode"), (b, prev, current) -> this.changeMode((Mode)current), (class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.mode")){

            public void method_25354(class_1144 handler) {
                CatalogScreen.this.playClickSound();
            }
        };
        this.modeButton.setTooltipFunc((Function<Mode, class_7919>)((Function)value -> {
            class_5250 component = class_2561.method_43471((String)"gui.exposure_catalog.catalog.mode").method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.mode.hotkey"));
            for (Mode v : Mode.values()) {
                component.method_27693("\n ");
                component.method_10852((class_2561)class_2561.method_43471((String)("gui.exposure_catalog.catalog.mode." + v.method_15434())).method_27696(class_2583.field_24360.method_36139(value == v ? 0x6677FF : 0x444444)));
            }
            return class_7919.method_47407((class_2561)component);
        }));
        this.method_37063((class_364)this.modeButton);
        this.refreshButton = new class_344(this.leftPos + 7, this.topPos + 247, 12, 12, REFRESH_BUTTON_SPRITES, b -> this.refresh());
        this.refreshButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.refresh").method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.refresh.hotkey")).method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.refresh.tooltip"))));
        this.method_37063((class_364)this.refreshButton);
        this.exportButton = new class_344(this.leftPos + 26, this.topPos + 247, 12, 12, EXPORT_BUTTON_SPRITES, b -> this.exportExposures()){

            public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
                if (this.method_25367()) {
                    this.method_47400(class_7919.method_47407((class_2561)CatalogScreen.this.createExportButtonTooltip()));
                }
                super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
            }

            public boolean method_25402(double mouseX, double mouseY, int button) {
                if (!(this.method_25367() && this.field_22763 && this.field_22764)) {
                    return super.method_25402(mouseX, mouseY, button);
                }
                if (class_437.method_25441()) {
                    CatalogScreen.this.exportSize = ExportSize.values()[(CatalogScreen.this.exportSize.ordinal() + 1) % ExportSize.values().length];
                    CatalogScreen.this.playClickSound();
                    return true;
                }
                if (class_437.method_25442()) {
                    CatalogScreen.this.exportLook = ExportLook.values()[(CatalogScreen.this.exportLook.ordinal() + 1) % ExportLook.values().length];
                    CatalogScreen.this.playClickSound();
                    return true;
                }
                return super.method_25402(mouseX, mouseY, button);
            }

            public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
                if (!(this.method_25367() && this.field_22763 && this.field_22764)) {
                    return super.method_25401(mouseX, mouseY, scrollX, scrollY);
                }
                if (class_437.method_25441()) {
                    int newValue = CatalogScreen.this.exportSize.ordinal() - (int)scrollY;
                    if (newValue < 0) {
                        newValue = ExportSize.values().length - 1;
                    } else if (newValue >= ExportSize.values().length) {
                        newValue = 0;
                    }
                    if (CatalogScreen.this.exportSize != ExportSize.values()[newValue]) {
                        CatalogScreen.this.playClickSound();
                        CatalogScreen.this.exportSize = ExportSize.values()[newValue];
                    }
                    return true;
                }
                if (class_437.method_25442()) {
                    int newValue = CatalogScreen.this.exportLook.ordinal() - (int)scrollY;
                    if (newValue < 0) {
                        newValue = ExportLook.values().length - 1;
                    } else if (newValue >= ExportLook.values().length) {
                        newValue = 0;
                    }
                    if (CatalogScreen.this.exportLook != ExportLook.values()[newValue]) {
                        CatalogScreen.this.playClickSound();
                        CatalogScreen.this.exportLook = ExportLook.values()[newValue];
                    }
                    return true;
                }
                return super.method_25401(mouseX, mouseY, scrollX, scrollY);
            }

            public boolean method_25404(int keyCode, int scanCode, int modifiers) {
                if (!(this.method_25367() && this.field_22763 && this.field_22764)) {
                    return super.method_25404(keyCode, scanCode, modifiers);
                }
                if (class_8494.method_51255((int)keyCode) && class_437.method_25441()) {
                    CatalogScreen.this.exportSize = ExportSize.values()[(CatalogScreen.this.exportSize.ordinal() + 1) % ExportSize.values().length];
                    CatalogScreen.this.playClickSound();
                    return true;
                }
                if (class_8494.method_51255((int)keyCode) && class_437.method_25442()) {
                    CatalogScreen.this.exportLook = ExportLook.values()[(CatalogScreen.this.exportLook.ordinal() + 1) % ExportLook.values().length];
                    CatalogScreen.this.playClickSound();
                    return true;
                }
                return super.method_25404(keyCode, scanCode, modifiers);
            }
        };
        this.exportButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.export")));
        this.method_37063((class_364)this.exportButton);
        this.exportStopButton = new class_344(this.leftPos + 26, this.topPos + 247, 12, 12, EXPORT_STOP_BUTTON_SPRITES, b -> ExportExposuresTask.stopCurrentTask());
        this.exportStopButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.export_stop").method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.export.hotkey"))));
        this.method_37063((class_364)this.exportStopButton);
        this.deleteButton = new class_344(this.leftPos + 342, this.topPos + 247, 12, 12, DELETE_BUTTON_SPRITES, b -> this.deleteExposures());
        this.deleteButton.method_47400(class_7919.method_47407((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.delete").method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.delete.hotkey")).method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.delete.tooltip"))));
        this.method_37063((class_364)this.deleteButton);
        if (!this.initialized) {
            this.loadState();
            ExposureClient.exposureStore().clear();
            Packets.sendToServer(new QueryExposuresC2SP(false));
            this.isLoading = true;
            if (this.mode == Mode.TEXTURES) {
                this.refresh();
            }
            this.initialized = true;
        }
        this.updateElements();
    }

    protected void playClickSound() {
        class_310.method_1551().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)Exposure.SoundEvents.CAMERA_DIAL_CLICK.get()), (float)1.0f, (float)0.8f));
    }

    protected class_2561 createExportButtonTooltip() {
        class_5250 tooltip = class_2561.method_43471((String)("gui.exposure_catalog.catalog.export." + (this.selection.isEmpty() || this.selection.size() == this.exposures.size() ? "all" : "selected"))).method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.export.hotkey"));
        tooltip.method_27693("\n");
        tooltip.method_10852((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.export.location_info"));
        tooltip.method_27693("\n").method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.export.size"));
        for (ExportSize exportSize : ExportSize.values()) {
            tooltip.method_27693("\n");
            tooltip.method_10852((class_2561)class_2561.method_43471((String)("gui.exposure_catalog.catalog.export.size." + exportSize.method_15434())).method_27696(class_2583.field_24360.method_36139(this.exportSize == exportSize ? 0x6677FF : 0x444444)));
        }
        tooltip.method_27693("\n").method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.export.look"));
        for (ExportSize exportSize : ExportLook.values()) {
            tooltip.method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)("gui.exposure_catalog.catalog.export.look." + exportSize.method_15434())).method_27696(class_2583.field_24360.method_36139(this.exportLook == exportSize ? 0x6677FF : 0x444444)));
        }
        tooltip.method_27693("\n").method_27693("\n").method_10852((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.export.control_info"));
        return tooltip;
    }

    protected boolean canRefresh() {
        if (this.mode == Mode.TEXTURES) {
            return true;
        }
        if (this.mode == Mode.EXPOSURES && this.isLoading) {
            return false;
        }
        return class_156.method_658() >= this.refreshCooldownExpireTime;
    }

    protected void refresh() {
        if (!this.canRefresh()) {
            return;
        }
        if (this.mode == Mode.EXPOSURES) {
            ExposureClient.exposureStore().clear();
            boolean reload = class_437.method_25442();
            Packets.sendToServer(new QueryExposuresC2SP(reload));
            if (reload) {
                this.isLoading = true;
                CatalogClient.clear();
            }
            this.refreshCooldownExpireTime = class_156.method_658() + (long)(reload ? 5000 : 500);
        } else if (this.mode == Mode.TEXTURES) {
            Map resources = class_310.method_1551().method_1478().method_14488("textures", rl -> true);
            this.textures = resources.keySet().stream().map(class_2960::toString).filter(s -> !s.endsWith(".license")).collect(Collectors.toCollection(ArrayList::new));
            this.orderTexturesList(this.order);
            this.refreshSearchResults();
            this.updateElements();
        }
    }

    protected void exportExposures() {
        ArrayList<String> exposureIds;
        if (this.mode == Mode.TEXTURES) {
            return;
        }
        List<String> list = exposureIds = !this.selection.isEmpty() ? this.selection.get().stream().map(i -> this.filteredItems.get((int)i)).toList() : this.filteredItems;
        if (exposureIds.size() > 100) {
            class_5250 message = class_2561.method_43469((String)"gui.exposure_catalog.catalog.confirm.message.export_all", (Object[])new Object[]{exposureIds.size()});
            ConfirmScreen confirmScreen = new ConfirmScreen(this, (class_2561)message, class_5244.field_24336, b -> this.exportExposures(exposureIds, this.exportSize, this.exportLook), class_5244.field_24337, b -> {});
            class_310.method_1551().method_1507((class_437)confirmScreen);
        } else {
            this.exportExposures(exposureIds, this.exportSize, this.exportLook);
        }
    }

    protected void exportExposures(List<String> exposureIds, ExportSize size, ExportLook look) {
        ExportExposuresTask.start(exposureIds, (ExportSize)size, (ExportLook)look);
    }

    protected void deleteExposures() {
        if (this.mode != Mode.EXPOSURES || this.selection.isEmpty() || this.filteredItems.isEmpty()) {
            return;
        }
        if (class_437.method_25442()) {
            this.deleteExposuresNoConfirm();
        } else {
            class_5250 message;
            if (this.selection.size() == 1) {
                String exposureId = this.filteredItems.get(this.selection.get().iterator().next());
                message = class_2561.method_43469((String)"gui.exposure_catalog.catalog.confirm.message.delete_one", (Object[])new Object[]{exposureId});
            } else {
                message = class_2561.method_43469((String)"gui.exposure_catalog.catalog.confirm.message.delete_many", (Object[])new Object[]{this.selection.size()});
            }
            ConfirmScreen confirmScreen = new ConfirmScreen(this, (class_2561)message, class_5244.field_24336, b -> this.deleteExposuresNoConfirm(), class_5244.field_24337, b -> {});
            class_310.method_1551().method_1507((class_437)confirmScreen);
        }
    }

    protected void deleteExposuresNoConfirm() {
        int globalIndex;
        if (this.mode != Mode.EXPOSURES || this.selection.isEmpty() || this.filteredItems.isEmpty()) {
            return;
        }
        ArrayList<String> removedIds = new ArrayList<String>();
        for (Integer index : this.selection.get()) {
            if (index < 0 || index >= this.filteredItems.size()) continue;
            String exposureId = this.filteredItems.get(index);
            Packets.sendToServer(new DeleteExposureC2SP(exposureId));
            removedIds.add(exposureId);
        }
        for (String id : removedIds) {
            this.exposures.remove(id);
            this.filteredItems.remove(id);
            CatalogClient.removeExposure(id);
            this.scrollTo(this.topRowIndex);
        }
        this.selection.clear();
        if (this.isThumbnailsGridFocused && (globalIndex = this.focusedThumbnailIndex + this.topRowIndex * 6) >= 0 && globalIndex < this.filteredItems.size() - 1) {
            this.selection.select(globalIndex);
        }
        this.updateElements();
    }

    protected void updateButtons() {
        this.orderButton.setState(this.order);
        this.sortingButton.setState(this.sorting);
        this.modeButton.setState(this.mode);
        this.sortingButton.field_22763 = this.mode == Mode.EXPOSURES;
        this.exportButton.field_22764 = this.mode == Mode.EXPOSURES && !ExportExposuresTask.isRunning();
        this.exportButton.field_22763 = this.mode == Mode.EXPOSURES && !ExportExposuresTask.isRunning();
        this.exportStopButton.field_22764 = ExportExposuresTask.isRunning();
        this.exportStopButton.field_22763 = ExportExposuresTask.isRunning();
        this.deleteButton.field_22763 = this.mode == Mode.EXPOSURES && !this.selection.isEmpty();
        this.refreshButton.field_22763 = this.canRefresh();
    }

    protected void changeMode(Mode mode) {
        this.mode = mode;
        if (mode == Mode.EXPOSURES && this.exposures.isEmpty() || mode == Mode.TEXTURES && this.textures.isEmpty()) {
            this.refresh();
        }
        this.updateButtons();
        this.refreshSearchResults();
    }

    protected void changeOrder(Order order) {
        this.order = order;
        if (this.mode == Mode.EXPOSURES) {
            this.orderAndSortExposuresList(this.order, this.sorting);
        } else {
            this.orderTexturesList(this.order);
        }
        this.updateButtons();
        this.refreshSearchResults();
    }

    protected void changeSorting(Sorting sorting) {
        this.sorting = sorting;
        if (this.mode == Mode.EXPOSURES) {
            this.orderAndSortExposuresList(this.order, this.sorting);
        }
        this.updateButtons();
        this.refreshSearchResults();
    }

    protected void orderAndSortExposuresList(Order order, Sorting sorting) {
        this.exposures.sort(Comparator.naturalOrder());
        if (sorting == Sorting.DATE) {
            Comparator<String> comparator = new Comparator<String>(this){

                @Override
                public int compare(String s1, String s2) {
                    return Long.compare(this.getTimestamp(s1), this.getTimestamp(s2));
                }

                private long getTimestamp(String exposureId) {
                    @Nullable ExposureInfo exposureInfo = CatalogClient.getExposures().get(exposureId);
                    return exposureInfo != null ? exposureInfo.tag().unixTimestamp() : 0L;
                }
            };
            this.exposures.sort(comparator);
        }
        if (order == Order.DESCENDING) {
            Collections.reverse(this.exposures);
        }
    }

    protected void orderTexturesList(Order order) {
        this.textures.sort(order == Order.ASCENDING ? Comparator.naturalOrder() : Comparator.reverseOrder());
    }

    protected void method_41843() {
        String searchBoxValue = this.searchBox.method_1882();
        super.method_41843();
        this.searchBox.method_1852(searchBoxValue);
    }

    protected void refreshSearchResults() {
        List<String> items = this.mode == Mode.EXPOSURES ? this.exposures : this.textures;
        String filter = this.searchBox != null ? this.searchBox.method_1882().trim() : "";
        String[] queries = filter.split("\\s+");
        this.filterSearchResults(items, queries, this.mode);
        this.totalRows = (int)Math.ceil((float)this.filteredItems.size() / 6.0f);
        this.selection.clear();
        this.scroll(Integer.MIN_VALUE);
    }

    protected void filterSearchResults(Collection<String> items, String[] queries, Mode mode) {
        this.filteredItems.clear();
        if (queries.length == 0) {
            this.filteredItems.addAll(items);
            return;
        }
        ArrayList<String> filtered = new ArrayList<String>(items);
        for (String query : queries) {
            if (query.isEmpty()) continue;
            if (mode == Mode.EXPOSURES && (query.startsWith("=") || query.startsWith("!="))) {
                boolean negative = query.startsWith("!=");
                String filter = query.substring(negative ? 2 : 1);
                if (filter.isEmpty()) continue;
                if ("printed".startsWith(filter)) {
                    filtered.removeIf(id -> !CatalogClient.getExposures().getOrDefault(id, ExposureInfo.EMPTY).tag().wasPrinted() ^ negative);
                    continue;
                }
                if ("projected".startsWith(filter)) {
                    filtered.removeIf(id -> !CatalogClient.getExposures().getOrDefault(id, ExposureInfo.EMPTY).tag().loaded() ^ negative);
                    continue;
                }
                if ("color".startsWith(filter)) {
                    filtered.removeIf(id -> CatalogClient.getExposures().getOrDefault(id, ExposureInfo.EMPTY).tag().type() != ExposureType.COLOR ^ negative);
                    continue;
                }
                if ("bw".startsWith(filter)) {
                    filtered.removeIf(id -> CatalogClient.getExposures().getOrDefault(id, ExposureInfo.EMPTY).tag().type() != ExposureType.BLACK_AND_WHITE ^ negative);
                    continue;
                }
                if (filter.startsWith("size:")) {
                    String sizeStr = filter.substring(5);
                    if (sizeStr.isEmpty() || !sizeStr.matches("^[0-9]+$")) continue;
                    int size = Integer.parseInt(sizeStr);
                    filtered.removeIf(id -> CatalogClient.getExposures().get(id).width() != size ^ negative);
                    continue;
                }
                if (filter.startsWith("palette:")) {
                    String palette = filter.substring(8).toLowerCase();
                    class_1129 tree = class_1129.plainText(filtered, id -> CatalogClient.getExposures().get(id).paletteId().toString().lines());
                    ArrayList matches = new ArrayList(tree.method_4810(palette));
                    if (negative) {
                        filtered.removeAll(matches);
                        continue;
                    }
                    filtered = matches;
                    continue;
                }
                filtered.clear();
                continue;
            }
            class_1129 tree = class_1129.plainText(filtered, String::lines);
            filtered = new ArrayList(tree.method_4810(query.toLowerCase(Locale.ROOT)));
        }
        this.filteredItems.addAll(filtered);
    }

    public void updateThumbnailsGrid() {
        this.thumbnails.clear();
        for (int row = 0; row < 4; ++row) {
            int gridIndex;
            int idIndex;
            for (int column = 0; column < 6 && (idIndex = (gridIndex = column + row * 6) + this.topRowIndex * 6) < this.filteredItems.size(); ++column) {
                int thumbnailX = column * 54;
                int thumbnailY = row * 54;
                String item = this.filteredItems.get(idIndex);
                ExposureIdentifier identifier = this.mode == Mode.EXPOSURES ? ExposureIdentifier.id((String)item) : ExposureIdentifier.texture((class_2960)class_2960.method_60654((String)item));
                class_768 area = new class_768(this.thumbnailsArea.method_3321() + 5 + thumbnailX, this.thumbnailsArea.method_3322() + 5 + thumbnailY, 48, 48);
                boolean isSelected = this.selection.get().contains(idIndex);
                Thumbnail thumbnail = new Thumbnail(idIndex, gridIndex, identifier, area, isSelected);
                this.thumbnails.add(thumbnail);
            }
        }
        this.focusedThumbnailIndex = class_3532.method_15340((int)this.focusedThumbnailIndex, (int)0, (int)(this.thumbnails.size() - 1));
    }

    public boolean method_25421() {
        return false;
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        this.updateButtons();
        this.method_52752(guiGraphics);
        guiGraphics.method_25293(TEXTURE, this.leftPos, this.topPos, this.imageWidth, this.imageHeight, 0.0f, 0.0f, this.imageWidth, this.imageHeight, 512, 512);
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        this.renderScrollBar(guiGraphics, mouseX, mouseY, partialTick);
        this.renderThumbnailsGrid(guiGraphics, mouseX, mouseY, partialTick);
        this.renderLabels(guiGraphics, mouseX, mouseY, partialTick);
        this.renderTooltip(guiGraphics, mouseX, mouseY, partialTick);
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    protected void renderThumbnailsGrid(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        for (Thumbnail thumbnail : this.thumbnails) {
            class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
            RenderableImage image = this.getThumbnailImage(thumbnail);
            RenderCoordinates coords = new RenderCoordinates((float)thumbnail.area().method_3321(), (float)thumbnail.area().method_3322(), (float)thumbnail.area().method_3319(), (float)thumbnail.area().method_3320());
            ExposureClient.imageRenderer().render(image, guiGraphics.method_51448(), (class_4597)bufferSource, coords, 0xF000F0, 255, 255, 255, 255);
            bufferSource.method_22993();
            int frameVOffset = thumbnail.selected() ? 108 : (thumbnail.isMouseOver(mouseX, mouseY) ? 54 : 0);
            RenderSystem.enableBlend();
            guiGraphics.method_25290(TEXTURE, thumbnail.area().method_3321() - 3, thumbnail.area().method_3322() - 3, 371.0f, (float)frameVOffset, 54, 54, 512, 512);
            RenderSystem.disableBlend();
        }
    }

    protected RenderableImage getThumbnailImage(Thumbnail thumbnail) {
        if (thumbnail.identifier().isTexture() || class_310.method_1551().method_47392()) {
            return ExposureClient.renderedExposures().getOrCreateRaw(thumbnail.identifier());
        }
        String id = (String)thumbnail.identifier().getId().orElseThrow();
        return (class_156.method_658() - this.lastScrolledTime < 250L ? CatalogClient.getThumbnail(id) : CatalogClient.getOrQueryThumbnail(id)).map(thumb -> new PalettedImage(thumb.width(), thumb.height(), thumb.pixels(), thumb.paletteId())).map(img -> RenderableImage.of((String)("thumbnail_" + id), (Image)img)).orElse(RenderableImage.EMPTY);
    }

    protected void renderTooltip(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.searchBox.method_25405((double)mouseX, (double)mouseY)) {
            ArrayList<Object> lines = new ArrayList<Object>();
            lines.add(class_2561.method_43471((String)"gui.exposure_catalog.searchbar").method_27693(" ").method_10852((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.searchbar.hotkey")));
            if (class_437.method_25442()) {
                lines.add(class_2561.method_43471((String)"gui.exposure_catalog.searchbar.tooltip.size"));
                lines.add(class_2561.method_43471((String)"gui.exposure_catalog.searchbar.tooltip.palette"));
                lines.add(class_2561.method_43471((String)"gui.exposure_catalog.searchbar.tooltip.color"));
                lines.add(class_2561.method_43471((String)"gui.exposure_catalog.searchbar.tooltip.bw"));
                lines.add(class_2561.method_43471((String)"gui.exposure_catalog.searchbar.tooltip.printed"));
                lines.add(class_2561.method_43471((String)"gui.exposure_catalog.searchbar.tooltip.projected"));
                lines.add(class_5244.field_39003);
                lines.add(class_2561.method_43471((String)"gui.exposure_catalog.searchbar.tooltip.filters"));
                lines.add(class_2561.method_43471((String)"gui.exposure_catalog.searchbar.tooltip.invert"));
            } else {
                lines.add(class_2561.method_43471((String)"gui.exposure_catalog.searchbar.tooltip.control_info"));
            }
            guiGraphics.method_51437(this.field_22793, lines, Optional.empty(), mouseX, mouseY);
        }
        for (Thumbnail thumbnail : this.thumbnails) {
            if (thumbnail.isMouseOver(mouseX, mouseY)) {
                List<class_2561> lines = this.getThumbnailTooltipLines(thumbnail);
                guiGraphics.method_51437(this.field_22793, lines, Optional.empty(), mouseX, mouseY);
                break;
            }
            if (!this.isThumbnailsGridFocused || thumbnail.gridIndex() != this.focusedThumbnailIndex) continue;
            List<class_2561> lines = this.getThumbnailTooltipLines(thumbnail);
            guiGraphics.method_51436(this.field_22793, Lists.transform(lines, class_2561::method_30937), (class_8000)new BelowOrAboveAreaTooltipPositioner(thumbnail.area()), mouseX, mouseY);
            break;
        }
    }

    @NotNull
    private List<class_2561> getThumbnailTooltipLines(Thumbnail thumbnail) {
        ArrayList<class_2561> lines = new ArrayList<class_2561>();
        lines.add((class_2561)class_2561.method_43470((String)thumbnail.identifier().toValueString()));
        thumbnail.identifier().ifId(exposureId -> {
            @Nullable ExposureInfo exposureInfo = CatalogClient.getExposures().get(exposureId);
            if (exposureInfo != null) {
                long timestampSeconds = exposureInfo.tag().unixTimestamp();
                if (timestampSeconds > 0L) {
                    Date date = new Date(timestampSeconds * 1000L);
                    String pattern = "yyyy-MM-dd HH:mm:ss";
                    SimpleDateFormat format = new SimpleDateFormat(pattern);
                    String format1 = format.format(date);
                    lines.add((class_2561)class_2561.method_43470((String)format1).method_27692(class_124.field_1080));
                }
                lines.add((class_2561)class_2561.method_43470((String)(exposureInfo.width() + "x" + exposureInfo.height())).method_27692(class_124.field_1080));
                if (!exposureInfo.paletteId().equals((Object)ColorPalettes.DEFAULT.method_29177())) {
                    lines.add((class_2561)class_2561.method_43469((String)"gui.exposure_catalog.catalog.tooltip.palette", (Object[])new Object[]{exposureInfo.paletteId().toString()}).method_27692(class_124.field_1080));
                }
                if (exposureInfo.tag().wasPrinted()) {
                    lines.add((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.tooltip.printed").method_27692(class_124.field_1080));
                }
                if (exposureInfo.tag().loaded()) {
                    lines.add((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.tooltip.projected").method_27692(class_124.field_1080));
                }
            }
        });
        lines.add((class_2561)class_2561.method_43473());
        if (class_437.method_25442()) {
            lines.add((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.thumbnail.tooltip.view"));
            lines.add((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.thumbnail.tooltip.selection"));
            lines.add((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.thumbnail.tooltip.selection.shift"));
            lines.add((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.thumbnail.tooltip.selection.clear"));
        } else {
            lines.add((class_2561)class_2561.method_43471((String)"gui.exposure_catalog.thumbnail.tooltip.control_info"));
        }
        return lines;
    }

    protected boolean isMouseOver(class_768 rect, double mouseX, double mouseY) {
        return mouseX >= (double)rect.method_3321() && mouseX < (double)(rect.method_3321() + rect.method_3319()) && mouseY >= (double)rect.method_3322() && mouseY < (double)(rect.method_3322() + rect.method_3320());
    }

    protected void renderScrollBar(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        int state = 0;
        if (!this.canScroll()) {
            state = 2;
        } else if (this.isDraggingScrollbar || this.isMouseOver(this.scrollThumb, mouseX, mouseY)) {
            state = 1;
        }
        int thumbStateOffset = 9;
        guiGraphics.method_25290(TEXTURE, this.scrollThumb.method_3321(), this.scrollThumb.method_3322(), 361.0f, (float)(state * thumbStateOffset), this.scrollThumb.method_3319(), 3, 512, 512);
        int middleParts = (this.scrollThumb.method_3320() - 3 - 2) / 4;
        for (int i = 0; i < middleParts; ++i) {
            guiGraphics.method_25290(TEXTURE, this.scrollThumb.method_3321(), this.scrollThumb.method_3322() + i * 4 + 3, 361.0f, (float)(3 + state * thumbStateOffset), this.scrollThumb.method_3319(), 4, 512, 512);
        }
        guiGraphics.method_25290(TEXTURE, this.scrollThumb.method_3321(), this.scrollThumb.method_3322() + middleParts * 4 + 3, 361.0f, (float)(7 + state * thumbStateOffset), this.scrollThumb.method_3319(), 2, 512, 512);
    }

    protected void renderLabels(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        class_5250 title = this.mode == Mode.EXPOSURES ? class_2561.method_43471((String)"gui.exposure_catalog.catalog.exposures") : class_2561.method_43471((String)"gui.exposure_catalog.catalog.textures");
        guiGraphics.method_51439(this.field_22793, (class_2561)title, this.leftPos + 8, this.topPos + 8, -12500671, false);
        if (this.mode == Mode.EXPOSURES && !this.isLoading && !this.haveExposures) {
            class_5250 component = class_2561.method_43471((String)"gui.exposure_catalog.catalog.no_exposures");
            int x = this.thumbnailsArea.method_3321() + this.thumbnailsArea.method_3319() / 2 - this.field_22793.method_27525((class_5348)component) / 2;
            int y = this.thumbnailsArea.method_3322() + this.thumbnailsArea.method_3320() / 2 - 5;
            guiGraphics.method_51439(this.field_22793, (class_2561)component, x, y, -12500671, false);
        }
        if (this.isLoading && this.mode == Mode.EXPOSURES) {
            int dotAnimation = (int)(class_156.method_658() / 750L % 3L) + 1;
            class_5250 component = class_2561.method_43471((String)("gui.exposure_catalog.catalog.loading" + dotAnimation)).method_27696(class_2583.field_24360.method_36139(-12500671));
            guiGraphics.method_51439(this.field_22793, (class_2561)component, this.leftPos + this.imageWidth / 2 - this.field_22793.method_27525((class_5348)component) / 2, this.topPos + 249, -12500671, false);
        } else if (!this.filteredItems.isEmpty()) {
            String filteredCountStr = Integer.toString(this.filteredItems.size());
            class_5250 countComponent = class_2561.method_43470((String)filteredCountStr).method_27696(class_2583.field_24360.method_36139(-12500671));
            if (!this.selection.isEmpty()) {
                String selectedCountStr = Integer.toString(this.selection.size());
                countComponent = class_2561.method_43470((String)selectedCountStr).method_27696(class_2583.field_24360.method_36139(-13084453)).method_10852((class_2561)class_2561.method_43470((String)"/").method_27696(class_2583.field_24360.method_36139(-12500671))).method_10852((class_2561)countComponent);
            }
            guiGraphics.method_51439(this.field_22793, (class_2561)countComponent, this.leftPos + this.imageWidth / 2 - this.field_22793.method_27525((class_5348)countComponent) / 2, this.topPos + 249, -12500671, false);
        }
        if (this.searchBox.method_1885() && !this.searchBox.method_25370() && this.searchBox.method_1882().isEmpty()) {
            guiGraphics.method_51439(this.field_22793, (class_2561)class_2561.method_43471((String)"gui.exposure_catalog.catalog.search_bar_placeholder_text"), this.searchBarArea.method_3321() + 2, this.searchBarArea.method_3322() + 1, -4276546, false);
        }
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        this.method_25395(null);
        this.isThumbnailsGridFocused = false;
        if (button == 1 && this.searchBox.method_25405(mouseX, mouseY)) {
            String value = this.searchBox.method_1882();
            this.searchBox.method_1852("");
            if (!value.equals(this.searchBox.method_1882())) {
                this.refreshSearchResults();
            }
            this.method_25395((class_364)this.searchBox);
            return true;
        }
        if (super.method_25402(mouseX, mouseY, button)) {
            return true;
        }
        if (button == 2) {
            return false;
        }
        if (this.isMouseOver(this.thumbnailsArea, mouseX, mouseY)) {
            for (Thumbnail thumbnail : this.thumbnails) {
                if (!thumbnail.isMouseOver(mouseX, mouseY)) continue;
                if (class_437.method_25441() || button == 1) {
                    if (class_437.method_25442()) {
                        int start = Math.min(thumbnail.index(), this.selection.getLastSelectedIndex());
                        int end = Math.max(thumbnail.index(), this.selection.getLastSelectedIndex());
                        for (int i = start; i <= end; ++i) {
                            if (this.selection.get().contains(i)) continue;
                            this.selection.select(i);
                        }
                    } else if (this.selection.get().contains(thumbnail.index())) {
                        this.selection.remove(thumbnail.index());
                    } else {
                        this.selection.select(thumbnail.index());
                    }
                    this.updateElements();
                } else {
                    this.openPhotographView(thumbnail.index());
                }
                return true;
            }
            if (!this.selection.isEmpty()) {
                this.selection.clear();
                this.updateThumbnailsGrid();
                return true;
            }
        }
        if (this.canScroll()) {
            if (this.isMouseOver(this.scrollThumb, mouseX, mouseY)) {
                this.method_25398(true);
                this.isDraggingScrollbar = true;
                this.dragDelta = 0.0;
                this.topRowIndexAtDragStart = this.topRowIndex;
                return true;
            }
            if (this.isMouseOver(this.scrollBarArea, mouseX, mouseY)) {
                int direction = mouseY < (double)this.scrollThumb.method_3322() ? -1 : 1;
                this.scroll(4 * direction);
                return true;
            }
        }
        return false;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (!this.isDraggingScrollbar || button != 0) {
            return super.method_25403(mouseX, mouseY, button, dragX, dragY);
        }
        this.dragDelta += dragY;
        double threshold = (double)this.scrollBarArea.method_3320() / (double)Math.max(this.totalRows, 1);
        int rows = (int)(this.dragDelta / threshold);
        if (rows != 0 || this.topRowIndex != this.topRowIndexAtDragStart) {
            this.scrollTo(this.topRowIndexAtDragStart + rows);
        }
        return true;
    }

    public boolean method_25406(double mouseX, double mouseY, int button) {
        this.isDraggingScrollbar = false;
        return super.method_25406(mouseX, mouseY, button);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.method_25401(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        this.scroll((int)(-scrollY));
        return true;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (keyCode == 256 && (this.searchBox.method_25370() || this.isThumbnailsGridFocused)) {
            this.method_25395(null);
            this.isThumbnailsGridFocused = false;
            return true;
        }
        if (this.isThumbnailsGridFocused && keyCode == 257) {
            this.openPhotographView(this.thumbnails.get(this.focusedThumbnailIndex).index());
            return true;
        }
        if (this.searchBox.method_20315() && keyCode != 258) {
            String string = this.searchBox.method_1882();
            if (this.searchBox.method_25404(keyCode, scanCode, modifiers)) {
                if (!string.equals(this.searchBox.method_1882())) {
                    this.refreshSearchResults();
                }
                return true;
            }
            if (keyCode != 256) {
                return true;
            }
        }
        if (this.tabKeyPressed(keyCode)) {
            return true;
        }
        if (this.arrowKeysPressed(keyCode)) {
            return true;
        }
        if (keyCode == 268) {
            this.selection.clear();
            this.selection.select(0);
            this.focusedThumbnailIndex = 0;
            this.scroll(Integer.MIN_VALUE);
            return true;
        }
        if (keyCode == 269) {
            this.selection.clear();
            this.selection.select(this.filteredItems.size() - 1);
            this.focusedThumbnailIndex = this.filteredItems.size() - 1;
            this.scroll(Integer.MAX_VALUE);
            return true;
        }
        if (keyCode == 261) {
            this.deleteExposures();
            return true;
        }
        if (class_437.method_25441()) {
            if (keyCode == 70) {
                this.method_25395((class_364)this.searchBox);
                return true;
            }
            if (keyCode == 77) {
                this.changeMode(Mode.values()[(this.mode.ordinal() + 1) % Mode.values().length]);
                this.playClickSound();
                return true;
            }
            if (keyCode == 82) {
                if (this.canRefresh()) {
                    this.refresh();
                    this.playClickSound();
                }
                return true;
            }
            if (keyCode == 69) {
                if (ExportExposuresTask.isRunning()) {
                    ExportExposuresTask.stopCurrentTask();
                } else {
                    this.exportExposures();
                }
                this.playClickSound();
                return true;
            }
            if (keyCode == 65) {
                this.selection.clear();
                this.selection.select(IntStream.range(0, this.filteredItems.size()).boxed().toList());
                this.updateElements();
                this.playClickSound();
                return true;
            }
            if (keyCode == 68) {
                if (!this.selection.isEmpty()) {
                    this.selection.clear();
                    this.updateElements();
                    this.playClickSound();
                }
                return true;
            }
        }
        if (class_310.method_1551().field_1690.field_1822.method_1417(keyCode, scanCode)) {
            this.method_25419();
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    private boolean tabKeyPressed(int keyCode) {
        if (keyCode != 258) {
            return false;
        }
        if (!this.filteredItems.isEmpty() && !class_437.method_25442() && this.method_25399() == this.modeButton) {
            this.method_25395(null);
            this.isThumbnailsGridFocused = true;
            this.focusedThumbnailIndex = 0;
            this.selection.clear();
            this.selection.select(this.focusedThumbnailIndex + this.topRowIndex * 6);
            this.updateElements();
            return true;
        }
        if (!this.filteredItems.isEmpty() && class_437.method_25442() && this.method_25399() == this.refreshButton && !this.isThumbnailsGridFocused) {
            this.method_25395(null);
            this.isThumbnailsGridFocused = true;
            this.focusedThumbnailIndex = 0;
            this.selection.clear();
            this.selection.select(this.focusedThumbnailIndex + this.topRowIndex * 6);
            this.updateElements();
            return true;
        }
        if (this.isThumbnailsGridFocused) {
            class_4185 newFocusTarget = class_437.method_25442() ? this.modeButton : this.refreshButton;
            this.method_25395((class_364)newFocusTarget);
            this.isThumbnailsGridFocused = false;
            if (this.selection.size() == 1 && this.selection.get().iterator().next() == this.focusedThumbnailIndex + this.topRowIndex * 6) {
                this.selection.clear();
                this.updateElements();
            }
            return true;
        }
        return false;
    }

    private boolean arrowKeysPressed(int keyCode) {
        if (this.filteredItems.isEmpty() || !List.of(Integer.valueOf(263), Integer.valueOf(262), Integer.valueOf(265), Integer.valueOf(264)).contains(keyCode)) {
            return false;
        }
        if (!this.isThumbnailsGridFocused) {
            this.method_25395(null);
            this.isThumbnailsGridFocused = true;
            this.focusedThumbnailIndex = 0;
            this.selection.select(this.focusedThumbnailIndex + this.topRowIndex * 6);
            this.updateElements();
            return true;
        }
        Map<Integer, Integer> keys = Map.of(263, -1, 262, 1, 265, -6, 264, 6);
        int change = keys.get(keyCode);
        int oldIndex = this.focusedThumbnailIndex;
        int newIndex = this.focusedThumbnailIndex + change;
        if (newIndex < 0) {
            if (this.topRowIndex <= 0) {
                return true;
            }
            this.scroll(-1);
            newIndex += 6;
        } else if (newIndex > 23) {
            if (this.topRowIndex >= this.totalRows - 4) {
                return true;
            }
            this.scroll(1);
            newIndex -= 6;
        }
        this.focusedThumbnailIndex = class_3532.method_15340((int)newIndex, (int)0, (int)(this.thumbnails.size() - 1));
        if (!class_437.method_25442()) {
            this.selection.clear();
        } else {
            int lesser = Math.min(oldIndex, newIndex);
            int larger = Math.max(oldIndex, newIndex);
            for (int i = lesser; i <= larger; ++i) {
                this.selection.select(i + this.topRowIndex * 6);
            }
        }
        this.selection.select(this.focusedThumbnailIndex + this.topRowIndex * 6);
        this.updateElements();
        return true;
    }

    protected void updateElements() {
        this.totalRows = (int)Math.ceil((float)this.filteredItems.size() / 6.0f);
        this.updateScrollThumb();
        this.updateButtons();
        this.updateThumbnailsGrid();
    }

    public boolean method_25400(char codePoint, int modifiers) {
        if (this.searchBox.method_20315()) {
            String string = this.searchBox.method_1882();
            if (this.searchBox.method_25400(codePoint, modifiers)) {
                if (!string.equals(this.searchBox.method_1882())) {
                    this.refreshSearchResults();
                }
                return true;
            }
        }
        return false;
    }

    public boolean canScroll() {
        return this.totalRows > 4;
    }

    public void scroll(int rows) {
        this.scrollTo(this.topRowIndex + rows);
    }

    public void scrollTo(int row) {
        int maxRowWhenAtEnd = Math.max(0, (int)Math.ceil((float)(this.filteredItems.size() - 24) / 6.0f));
        this.topRowIndex = class_3532.method_15340((int)row, (int)0, (int)maxRowWhenAtEnd);
        this.updateScrollThumb();
        this.updateThumbnailsGrid();
        this.lastScrolledTime = class_156.method_658();
    }

    protected void updateScrollThumb() {
        int minSize = 9;
        float ratio = 4.0f / (float)Math.max(this.totalRows, 1);
        int size = class_3532.method_15340((int)class_3532.method_15386((float)((float)this.scrollBarArea.method_3320() * ratio)), (int)minSize, (int)this.scrollBarArea.method_3320());
        int midSize = size - 3 - 2;
        int correctedMidSize = Math.max(midSize - midSize % 4, 4);
        size = 3 + correctedMidSize + 2;
        float topRowPos = (float)this.topRowIndex / (float)Math.max(1, this.totalRows - 4);
        int pos = (int)class_3532.method_37959((float)topRowPos, (float)0.0f, (float)1.0f, (float)0.0f, (float)(this.scrollBarArea.method_3320() - size));
        this.scrollThumb = new class_768(this.scrollBarArea.method_3321(), this.scrollBarArea.method_3322() + pos, this.scrollBarArea.method_3319(), size);
    }

    protected void openPhotographView(int clickedIndex) {
        ArrayList<String> items = !this.selection.isEmpty() ? this.selection.get().stream().map(i -> this.filteredItems.get((int)i)).toList() : this.filteredItems;
        ArrayList<ItemAndStack> photographs = new ArrayList<ItemAndStack>(items.stream().map(item -> {
            class_1799 stack = new class_1799((class_1935)Exposure.Items.PHOTOGRAPH.get());
            ExposureIdentifier identifier = this.mode == Mode.EXPOSURES ? ExposureIdentifier.id((String)item) : ExposureIdentifier.texture((class_2960)class_2960.method_60654((String)item));
            Frame frame = Frame.create().setIdentifier(identifier).toImmutable();
            stack.method_57379(Exposure.DataComponents.PHOTOGRAPH_FRAME, (Object)frame);
            return new ItemAndStack(stack);
        }).toList());
        String clickedId = this.filteredItems.get(clickedIndex);
        int clickedIdIndex = Math.max(0, items.indexOf(clickedId));
        Collections.rotate(photographs, -clickedIdIndex);
        ChildPhotographScreen screen = new ChildPhotographScreen((class_437)this, photographs);
        class_310.method_1551().method_1507((class_437)screen);
        Minecrft.get().method_1483().method_4873((class_1113)class_1109.method_4757((class_3414)((class_3414)Exposure.SoundEvents.PHOTOGRAPH_RUSTLE.get()), (float)(Minecrft.level().method_8409().method_43057() * 0.2f + 1.3f), (float)0.75f));
    }

    public void method_25419() {
        this.saveState();
        CatalogClient.clear();
        ExposureClient.exposureStore().clear();
        Packets.sendToServer(CatalogClosedC2SP.INSTANCE);
        super.method_25419();
    }

    protected void saveState() {
        JsonObject obj = new JsonObject();
        obj.addProperty("mode", this.mode.method_15434());
        obj.addProperty("order", this.order.method_15434());
        obj.addProperty("sorting", this.sorting.method_15434());
        obj.addProperty("export_size", this.exportSize.method_15434());
        obj.addProperty("export_look", this.exportLook.method_15434());
        try (FileWriter writer = new FileWriter(this.stateFile);){
            new GsonBuilder().setPrettyPrinting().create().toJson((JsonElement)obj, (Appendable)writer);
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Cannot save catalog state: " + String.valueOf(e));
        }
    }

    protected void loadState() {
        try {
            if (!Files.exists(this.stateFile.toPath(), new LinkOption[0]) || Files.size(this.stateFile.toPath()) == 0L) {
                return;
            }
            try (FileReader reader = new FileReader(this.stateFile);){
                JsonObject obj = class_3518.method_15255((Reader)reader);
                this.mode = Mode.fromSerializedString(obj.get("mode").getAsString());
                this.order = Order.fromSerializedString(obj.get("order").getAsString());
                this.sorting = Sorting.fromSerializedString(obj.get("sorting").getAsString());
                this.exportSize = ExportSize.byName((String)obj.get("export_size").getAsString());
                this.exportLook = ExportLook.byName((String)obj.get("export_look").getAsString());
            }
        }
        catch (Exception e) {
            LogUtils.getLogger().error("Cannot load catalog state: {}", (Object)e.toString());
        }
    }
}

