/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure_catalog.client.gui.screen.widget;

import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import io.github.mortuusars.exposure.client.gui.Widgets;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4185;
import net.minecraft.class_437;
import net.minecraft.class_7919;
import net.minecraft.class_8494;
import net.minecraft.class_8666;
import org.jetbrains.annotations.Nullable;

public class EnumButton<T extends Enum<T>>
extends class_4185 {
    protected final List<T> states;
    protected final Map<T, class_8666> sprites;
    protected final OnStateChanged<T> onStateChanged;
    protected int currentStateIndex;
    @Nullable
    protected Function<T, class_7919> tooltipFunc;
    @Nullable
    protected class_7919 defaultTooltip;

    public EnumButton(Class<T> enumClass, int x, int y, int width, int height, class_2960 sprite, OnStateChanged<T> onStateChanged, class_2561 message) {
        super(x, y, width, height, message, b -> {}, n -> class_2561.method_43473());
        this.states = Arrays.asList((Enum[])enumClass.getEnumConstants());
        this.sprites = new HashMap<T, class_8666>();
        this.onStateChanged = onStateChanged;
        this.currentStateIndex = 0;
        for (Enum state : this.states) {
            String name = state.name().toLowerCase();
            class_8666 sprites = Widgets.threeStateSprites((class_2960)sprite.method_48331("_" + name));
            this.sprites.put(state, sprites);
        }
    }

    public T getState() {
        return (T)((Enum)this.states.get(this.currentStateIndex));
    }

    public void setState(T state) {
        this.setStateIndex(((Enum)state).ordinal());
    }

    public void setStateIndex(int index) {
        Preconditions.checkElementIndex((int)index, (int)this.states.size());
        this.currentStateIndex = index;
    }

    public void changeState(T state) {
        T previousState = this.getState();
        if (!((Enum)previousState).equals(state)) {
            this.setState(state);
            this.onStateChanged.onStateChanged(this, previousState, state);
        }
    }

    public void changeStateIndex(int index) {
        int previousIndex = this.currentStateIndex;
        if (previousIndex != index) {
            this.setStateIndex(index);
            this.onStateChanged.onStateChanged(this, (Enum)this.states.get(previousIndex), (Enum)this.states.get(index));
        }
    }

    public void previousState() {
        this.changeStateIndex((this.currentStateIndex - 1 + this.states.size()) % this.states.size());
    }

    public void nextState() {
        this.changeStateIndex((this.currentStateIndex + 1) % this.states.size());
    }

    public void setDefaultTooltip(@Nullable class_7919 tooltip) {
        this.defaultTooltip = tooltip;
    }

    public void setTooltipFunc(@Nullable Function<T, class_7919> tooltipFunc) {
        this.tooltipFunc = tooltipFunc;
    }

    public void method_48579(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        if (this.method_25367()) {
            this.method_47400(this.tooltipFunc != null ? (class_7919)this.tooltipFunc.apply(this.getState()) : this.defaultTooltip);
        }
        class_8666 sprites = this.sprites.get(this.getState());
        class_2960 resourceLocation = sprites.method_52729(this.method_37303(), this.method_25367());
        guiGraphics.method_52706(resourceLocation, this.method_46426(), this.method_46427(), this.field_22758, this.field_22759);
    }

    public boolean method_25402(double mouseX, double mouseY, int button) {
        if (this.method_37303() && this.method_25361(mouseX, mouseY)) {
            if (button == 1) {
                this.previousState();
            } else {
                this.nextState();
            }
            this.method_25354(class_310.method_1551().method_1483());
            return true;
        }
        return false;
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (this.method_37303() && this.method_25361(mouseX, mouseY)) {
            if (scrollY < 0.0) {
                this.previousState();
            } else {
                this.nextState();
            }
            this.method_25354(class_310.method_1551().method_1483());
            return true;
        }
        return false;
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        if (this.method_37303() && class_8494.method_51255((int)keyCode)) {
            if (class_437.method_25442()) {
                this.previousState();
            } else {
                this.nextState();
            }
            this.method_25354(class_310.method_1551().method_1483());
            return true;
        }
        return super.method_25404(keyCode, scanCode, modifiers);
    }

    public static interface OnStateChanged<T extends Enum<T>> {
        public void onStateChanged(EnumButton<T> var1, T var2, T var3);
    }
}

