/*
 * Decompiled with CFR 0.152.
 */
package net.combat_roll.internals;

import net.combat_roll.CombatRollMod;
import net.combat_roll.api.CombatRoll;
import net.combat_roll.client.CombatRollClient;
import net.combat_roll.mixin.PlayerEntityAccessor;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3414;
import net.minecraft.class_3419;
import net.minecraft.class_5134;
import net.minecraft.class_746;
import net.minecraft.class_7923;

public class RollManager {
    public boolean isEnabled = true;
    private int timeSinceLastRoll = 10;
    private float currentCooldownProgress = 0.0f;
    private int currentCooldownLength = 0;
    private int maxRolls = 1;
    private int availableRolls = 0;

    public static int rollDuration() {
        return CombatRollMod.config.roll_duration;
    }

    public CooldownInfo getCooldown() {
        return new CooldownInfo((int)this.currentCooldownProgress, this.currentCooldownLength, this.availableRolls, this.maxRolls);
    }

    public boolean isRollAvailable(class_1657 player) {
        return this.isEnabled && !this.isRolling() && this.availableRolls > 0 && !((PlayerEntityAccessor)player).invokeIsImmobile_combat_roll() && player.method_6034() && player.method_45325(class_5134.field_23719) > 0.0;
    }

    public boolean isRolling() {
        return this.timeSinceLastRoll <= RollManager.rollDuration();
    }

    public void onRoll(class_746 player) {
        --this.availableRolls;
        this.timeSinceLastRoll = 0;
        this.updateCooldownLength(player);
    }

    public void tick(class_746 player) {
        this.maxRolls = (int)player.method_45325(CombatRoll.Attributes.COUNT.entry);
        ++this.timeSinceLastRoll;
        if (this.availableRolls < this.maxRolls) {
            this.currentCooldownProgress += this.increment((class_1657)player);
            if (this.currentCooldownProgress >= (float)this.currentCooldownLength) {
                this.rechargeRoll(player);
            }
        }
        if (this.availableRolls == this.maxRolls) {
            this.currentCooldownProgress = 0.0f;
        }
        if (this.availableRolls > this.maxRolls) {
            this.availableRolls = this.maxRolls;
        }
    }

    private float increment(class_1657 player) {
        return (float)(player.method_45325(CombatRoll.Attributes.RECHARGE.entry) / 20.0);
    }

    private void rechargeRoll(class_746 player) {
        class_3414 cooldownReady;
        ++this.availableRolls;
        this.currentCooldownProgress = Math.max(this.currentCooldownProgress - (float)this.currentCooldownLength, 0.0f);
        this.updateCooldownLength(player);
        if (CombatRollClient.config.playCooldownSound && (cooldownReady = (class_3414)class_7923.field_41172.method_10223(class_2960.method_60654((String)"combat_roll:roll_cooldown_ready"))) != null) {
            player.method_37908().method_8486(player.method_23317(), player.method_23318(), player.method_23321(), cooldownReady, class_3419.field_15248, 1.0f, 1.0f, false);
        }
    }

    private void updateCooldownLength(class_746 player) {
        float duration = CombatRollMod.config.roll_cooldown;
        this.currentCooldownLength = Math.round(duration * 20.0f);
    }

    public record CooldownInfo(int elapsed, int total, int availableRolls, int maxRolls) {
    }
}

