/*
 * Decompiled with CFR 0.152.
 */
package fuzs.pickupnotifier.client.handler;

import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import fuzs.puzzleslib.api.config.v3.json.JsonConfigFileUtil;
import fuzs.puzzleslib.api.config.v3.serialization.ConfigDataSet;
import fuzs.puzzleslib.api.core.v1.utility.ResourceLocationHelper;
import java.io.FileReader;
import java.io.Reader;
import java.util.Arrays;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1937;
import net.minecraft.class_2960;
import net.minecraft.class_3518;
import net.minecraft.class_5321;
import net.minecraft.class_7924;

public class ItemBlacklistManager {
    public static final ItemBlacklistManager INSTANCE = new ItemBlacklistManager();
    private DimensionBlacklist defaultBlacklist = DimensionBlacklist.create(false);
    private Map<class_5321<class_1937>, DimensionBlacklist> dimensionBlacklists = Maps.newIdentityHashMap();

    private ItemBlacklistManager() {
    }

    public boolean isItemAllowed(class_5321<class_1937> dimension, class_1792 item) {
        DimensionBlacklist blacklist = this.dimensionBlacklists.getOrDefault(dimension, this.defaultBlacklist);
        if (blacklist.inverted()) {
            return blacklist.items().contains(item);
        }
        return !blacklist.items().contains(item);
    }

    public void loadAll(String directory) {
        this.defaultBlacklist = DimensionBlacklist.create(false);
        this.dimensionBlacklists = Maps.newIdentityHashMap();
        JsonConfigFileUtil.getAllAndLoad((String)directory, file -> {}, this::deserializeDataEntry, () -> {});
    }

    private void deserializeDataEntry(FileReader reader) {
        DimensionBlacklist blacklist;
        String[] items;
        class_5321 dimension;
        JsonElement jsonElement = (JsonElement)JsonConfigFileUtil.GSON.fromJson((Reader)reader, JsonElement.class);
        JsonObject jsonObject = class_3518.method_15295((JsonElement)jsonElement, (String)"pick ups config");
        boolean inverted = jsonObject.has("inverted") ? class_3518.method_15270((JsonObject)jsonObject, (String)"inverted") : false;
        if (jsonObject.has("dimension")) {
            class_2960 resourceLocation = ResourceLocationHelper.parse((String)class_3518.method_15265((JsonObject)jsonObject, (String)"dimension"));
            dimension = class_5321.method_29179((class_5321)class_7924.field_41223, (class_2960)resourceLocation);
        } else {
            dimension = null;
        }
        if (jsonObject.has("items")) {
            JsonArray jsonArray = class_3518.method_15261((JsonObject)jsonObject, (String)"items");
            items = (String[])JsonConfigFileUtil.GSON.fromJson((JsonElement)jsonArray, String[].class);
        } else {
            items = new String[]{};
        }
        if (dimension != null) {
            blacklist = this.dimensionBlacklists.computeIfAbsent((class_5321<class_1937>)dimension, dimension1 -> DimensionBlacklist.create(inverted));
            if (inverted != blacklist.inverted()) {
                throw new IllegalStateException("Found multiple configs for dimension %s where one is inverted and the other one is not, this is not allowed!".formatted(dimension));
            }
        } else {
            if (inverted != this.defaultBlacklist.inverted()) {
                this.defaultBlacklist = DimensionBlacklist.create(inverted);
            }
            blacklist = this.defaultBlacklist;
        }
        blacklist.items().addAll((Collection<class_1792>)ConfigDataSet.from((class_5321)class_7924.field_41197, Arrays.asList(items), (Class[])new Class[0]));
    }

    private record DimensionBlacklist(Set<class_1792> items, boolean inverted) {
        public static DimensionBlacklist create(boolean inverted) {
            return new DimensionBlacklist(Sets.newIdentityHashSet(), inverted);
        }
    }
}

