/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.client.texture_renderer;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.mojang.blaze3d.systems.RenderSystem;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.FrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.client.texture_renderer.TickableFrameBufferBackedDynamicTexture;
import net.mehvahdjukaar.moonlight.api.util.Utils;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1011;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_276;
import net.minecraft.class_286;
import net.minecraft.class_287;
import net.minecraft.class_289;
import net.minecraft.class_290;
import net.minecraft.class_293;
import net.minecraft.class_2960;
import net.minecraft.class_308;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_757;
import net.minecraft.class_8251;
import net.minecraft.class_9801;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix4f;
import org.joml.Matrix4fStack;
import org.joml.Matrix4fc;

public class RenderedTexturesManager {
    private static final LoadingCache<class_2960, FrameBufferBackedDynamicTexture> TEXTURE_CACHE = CacheBuilder.newBuilder().removalListener(i -> RenderSystem.recordRenderCall(((FrameBufferBackedDynamicTexture)((Object)((Object)i.getValue())))::close)).expireAfterAccess(2L, TimeUnit.MINUTES).build((CacheLoader)new CacheLoader<class_2960, FrameBufferBackedDynamicTexture>(){

        public FrameBufferBackedDynamicTexture load(class_2960 key) {
            return null;
        }
    });

    public static void clearCache() {
        TEXTURE_CACHE.invalidateAll();
    }

    public static FrameBufferBackedDynamicTexture requestTexture(class_2960 id, int textureSize, Consumer<FrameBufferBackedDynamicTexture> textureDrawingFunction, boolean updateEachFrame) {
        FrameBufferBackedDynamicTexture texture = (FrameBufferBackedDynamicTexture)((Object)TEXTURE_CACHE.getIfPresent((Object)id));
        if (texture == null) {
            texture = updateEachFrame ? new TickableFrameBufferBackedDynamicTexture(id, textureSize, textureDrawingFunction) : new FrameBufferBackedDynamicTexture(id, textureSize, textureDrawingFunction);
            TEXTURE_CACHE.put((Object)id, (Object)texture);
            RenderSystem.recordRenderCall(texture::initialize);
        }
        return texture;
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemStackTexture(class_2960 res, class_1799 stack, int size) {
        return RenderedTexturesManager.requestTexture(res, size, t -> RenderedTexturesManager.drawItem(t, stack), true);
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemTexture(class_1792 item, int size) {
        return RenderedTexturesManager.requestFlatItemTexture(item, size, null);
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemTexture(class_1792 item, int size, @Nullable Consumer<class_1011> postProcessing) {
        class_2960 id = Moonlight.res(Utils.getID(item).toString().replace(":", "/") + "/" + size);
        return RenderedTexturesManager.requestFlatItemTexture(id, item, size, postProcessing, false);
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemTexture(class_2960 id, class_1792 item, int size, @Nullable Consumer<class_1011> postProcessing) {
        return RenderedTexturesManager.requestFlatItemTexture(id, item, size, postProcessing, false);
    }

    public static FrameBufferBackedDynamicTexture requestFlatItemTexture(class_2960 id, class_1792 item, int size, @Nullable Consumer<class_1011> postProcessing, boolean updateEachFrame) {
        return RenderedTexturesManager.requestTexture(id, size, t -> {
            RenderedTexturesManager.drawItem(t, item.method_7854());
            if (postProcessing != null) {
                t.download();
                class_1011 img = t.getPixels();
                postProcessing.accept(img);
                t.upload();
            }
        }, updateEachFrame);
    }

    public static void drawItem(FrameBufferBackedDynamicTexture tex, class_1799 stack) {
        RenderedTexturesManager.drawAsInGUI(tex, g -> g.method_51445(stack, 0, 0));
    }

    public static void drawTexture(FrameBufferBackedDynamicTexture tex, class_2960 texture) {
        RenderedTexturesManager.drawAsInGUI(tex, s -> {
            RenderSystem.setShaderTexture((int)0, (class_2960)texture);
            class_4587.class_4665 pose = s.method_51448().method_23760();
            RenderSystem.disableDepthTest();
            RenderSystem.depthMask((boolean)false);
            RenderSystem.disableBlend();
            RenderSystem.setShader(class_757::method_34543);
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            class_287 bufferBuilder = class_289.method_1348().method_60827(class_293.class_5596.field_27382, class_290.field_1585);
            bufferBuilder.method_56824(pose, 0.0f, 16.0f, 0.0f).method_22913(0.0f, 0.0f);
            bufferBuilder.method_56824(pose, 16.0f, 16.0f, 0.0f).method_22913(1.0f, 0.0f);
            bufferBuilder.method_56824(pose, 16.0f, 0.0f, 0.0f).method_22913(1.0f, 1.0f);
            bufferBuilder.method_56824(pose, 0.0f, 0.0f, 0.0f).method_22913(0.0f, 1.0f);
            class_286.method_43433((class_9801)bufferBuilder.method_60800());
        });
    }

    public static void drawNormalized(FrameBufferBackedDynamicTexture tex, Consumer<class_4587> drawFunction) {
        RenderedTexturesManager.drawAsInGUI(tex, g -> {
            class_4587 s = g.method_51448();
            float scale = 0.0625f;
            s.method_46416(8.0f, 8.0f, 0.0f);
            s.method_22905(scale, scale, 1.0f);
            drawFunction.accept(s);
        });
    }

    public static void drawAsInGUI(FrameBufferBackedDynamicTexture tex, Consumer<class_332> drawFunction) {
        float fogStart = RenderSystem.getShaderFogStart();
        float fogEnd = RenderSystem.getShaderFogEnd();
        RenderSystem.setShaderFogStart((float)2.1474836E9f);
        RenderSystem.setShaderFogEnd((float)2.1474836E9f);
        RenderSystem.clear((int)256, (boolean)class_310.field_1703);
        class_310 mc = class_310.method_1551();
        class_276 frameBuffer = tex.getFrameBuffer();
        frameBuffer.method_1230(class_310.field_1703);
        frameBuffer.method_1235(true);
        int size = 16;
        RenderSystem.backupProjectionMatrix();
        Matrix4f matrix4f = new Matrix4f().setOrtho(0.0f, (float)size, (float)size, 0.0f, -1000.0f, 1000.0f);
        RenderSystem.setProjectionMatrix((Matrix4f)matrix4f, (class_8251)class_8251.field_43361);
        Matrix4fStack posestack = RenderSystem.getModelViewStack();
        posestack.pushMatrix();
        posestack.set((Matrix4fc)new Matrix4f().identity());
        RenderSystem.applyModelViewMatrix();
        class_308.method_24211();
        class_332 guiGraphics = new class_332(mc, mc.method_22940().method_23000());
        drawFunction.accept(guiGraphics);
        guiGraphics.method_51452();
        posestack.popMatrix();
        RenderSystem.applyModelViewMatrix();
        RenderSystem.restoreProjectionMatrix();
        mc.method_1522().method_1235(true);
        RenderSystem.setShaderFogStart((float)fogStart);
        RenderSystem.setShaderFogEnd((float)fogEnd);
    }
}

