/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.map.client;

import com.google.common.collect.Maps;
import java.util.Map;
import java.util.function.Function;
import net.mehvahdjukaar.moonlight.api.map.client.MapDecorationRenderer;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecoration;
import net.mehvahdjukaar.moonlight.api.map.decoration.MLMapDecorationType;
import net.mehvahdjukaar.moonlight.core.map.MapDataInternal;
import net.minecraft.class_1921;
import net.minecraft.class_22;
import net.minecraft.class_2960;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_4597;
import net.minecraft.class_5321;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class MapDecorationClientManager {
    public static final class_2960 LOCATION_MAP_MARKERS = class_2960.method_60656((String)"textures/atlas/map_decorations.png");
    public static final class_1921 MAP_MARKERS_RENDER_TYPE = class_1921.method_23028((class_2960)LOCATION_MAP_MARKERS);
    private static final Map<class_2960, Function<class_2960, MapDecorationRenderer<?>>> CUSTOM_RENDERERS_FACTORIES = Maps.newHashMap();
    private static final Map<MLMapDecorationType<?, ?>, MapDecorationRenderer<?>> RENDERERS = Maps.newHashMap();

    public static <T extends MLMapDecoration> void registerCustomRenderer(class_2960 typeFactoryId, Function<class_2960, MapDecorationRenderer<T>> renderer) {
        CUSTOM_RENDERERS_FACTORIES.put(typeFactoryId, renderer);
    }

    private static MapDecorationRenderer<?> createRenderer(class_6880<MLMapDecorationType<?, ?>> type) {
        class_2960 id = ((class_5321)type.method_40230().get()).method_29177();
        Function<class_2960, MapDecorationRenderer<?>> custom = CUSTOM_RENDERERS_FACTORIES.get(((MLMapDecorationType)type.comp_349()).getCustomFactoryID());
        if (custom != null) {
            return custom.apply(id);
        }
        return new MapDecorationRenderer(id);
    }

    public static <E extends MLMapDecoration> MapDecorationRenderer<E> getRenderer(E decoration) {
        return MapDecorationClientManager.getRenderer(decoration.getType());
    }

    @Deprecated(forRemoval=true)
    public static <E extends MLMapDecoration, T extends MLMapDecorationType<E, ?>> MapDecorationRenderer<E> getRenderer(T type) {
        return MapDecorationClientManager.getRenderer(MapDataInternal.hackyGetRegistry().method_47983(type));
    }

    public static <E extends MLMapDecoration> MapDecorationRenderer<E> getRenderer(class_6880<MLMapDecorationType<?, ?>> type) {
        return RENDERERS.computeIfAbsent((MLMapDecorationType)type.comp_349(), t -> MapDecorationClientManager.createRenderer(type));
    }

    public static <T extends MLMapDecoration> boolean render(T decoration, class_4587 matrixStack, class_4588 vertexBuilder, class_4597 buffer, @Nullable class_22 mapData, boolean isOnFrame, int light, int index) {
        MapDecorationRenderer renderer = MapDecorationClientManager.getRenderer(decoration);
        if (renderer != null) {
            return renderer.render(decoration, matrixStack, vertexBuilder, buffer, mapData, isOnFrame, light, index);
        }
        return false;
    }
}

