/*
 * Decompiled with CFR 0.152.
 */
package net.mehvahdjukaar.moonlight.api.resources.recipe;

import com.google.common.base.Preconditions;
import com.mojang.serialization.Codec;
import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.MapLike;
import com.mojang.serialization.RecordBuilder;
import dev.architectury.injectables.annotations.ExpectPlatform;
import io.netty.handler.codec.DecoderException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.stream.Stream;
import net.mehvahdjukaar.moonlight.api.resources.recipe.fabric.BlockTypeSwapIngredientImpl;
import net.mehvahdjukaar.moonlight.api.set.BlockType;
import net.mehvahdjukaar.moonlight.api.set.BlockTypeRegistry;
import net.mehvahdjukaar.moonlight.core.Moonlight;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1935;
import net.minecraft.class_2960;
import net.minecraft.class_9129;
import net.minecraft.class_9139;
import org.jetbrains.annotations.NotNull;

public abstract class BlockTypeSwapIngredient<T extends BlockType> {
    protected final class_1856 inner;
    protected final T fromType;
    protected final T toType;
    protected final BlockTypeRegistry<T> registry;
    private List<class_1799> items;
    public static final class_2960 ID = Moonlight.res("block_type_swap");
    public static final MapCodec<BlockTypeSwapIngredient<?>> CODEC = BlockTypeSwapIngredient.makeCodec(false);
    public static final MapCodec<BlockTypeSwapIngredient<?>> CODEC_NONEMPTY = BlockTypeSwapIngredient.makeCodec(true);
    public static final class_9139<class_9129, BlockTypeSwapIngredient<?>> STREAM_CODEC = new class_9139<class_9129, BlockTypeSwapIngredient<?>>(){

        public BlockTypeSwapIngredient<?> decode(class_9129 object) {
            class_1856 inner = (class_1856)class_1856.field_48355.decode((Object)object);
            BlockTypeRegistry reg = (BlockTypeRegistry)BlockTypeRegistry.getRegistryStreamCodec().decode((Object)object);
            class_9139 slowCodec = reg.getStreamCodecExplicit();
            try {
                BlockType from = (BlockType)slowCodec.decode((Object)object);
                BlockType to = (BlockType)slowCodec.decode((Object)object);
                return BlockTypeSwapIngredient.create(inner, from, to, reg);
            }
            catch (DecoderException e) {
                throw new RuntimeException("Failed to decode block type swap ingredient", e);
            }
        }

        public void encode(class_9129 buf, BlockTypeSwapIngredient<?> ing) {
            class_1856.field_48355.encode((Object)buf, (Object)ing.inner);
            BlockTypeRegistry.getRegistryStreamCodec().encode((Object)buf, ing.registry);
            class_9139 streamCodec = ing.registry.getStreamCodecExplicit();
            streamCodec.encode((Object)buf, ing.fromType);
            streamCodec.encode((Object)buf, ing.toType);
        }
    };

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockType> class_1856 create(class_1856 original, @NotNull T from, @NotNull T to) {
        void var2_2;
        void var1_1;
        return BlockTypeSwapIngredientImpl.create(original, var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @ExpectPlatform
    @ExpectPlatform.Transformed
    public static <T extends BlockType> BlockTypeSwapIngredient<T> create(class_1856 original, @NotNull T from, @NotNull T to, BlockTypeRegistry<T> reg) {
        void var3_3;
        void var2_2;
        void var1_1;
        return BlockTypeSwapIngredientImpl.create(original, var1_1, var2_2, var3_3);
    }

    protected BlockTypeSwapIngredient(class_1856 inner, T fromType, T toType, BlockTypeRegistry<T> reg) {
        Preconditions.checkNotNull(toType, (Object)"Found null to block type for BlockTypeSwapIngredient");
        Preconditions.checkNotNull(fromType, (Object)"Found null from block type for BlockTypeSwapIngredient");
        this.inner = inner;
        this.fromType = fromType;
        this.toType = toType;
        this.registry = reg;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object obj) {
        if (!(obj instanceof BlockTypeSwapIngredient)) return false;
        BlockTypeSwapIngredient ing = (BlockTypeSwapIngredient)obj;
        if (!this.inner.equals((Object)ing.inner)) return false;
        if (this.fromType != ing.fromType) return false;
        if (this.toType != ing.toType) return false;
        return true;
    }

    public int hashCode() {
        return Objects.hash(this.inner, this.fromType, this.toType);
    }

    public class_1856 getInner() {
        return this.inner;
    }

    public boolean test(class_1799 stack) {
        if (stack != null) {
            for (class_1799 itemStack : this.getMatchingStacks()) {
                if (!itemStack.method_31574(stack.method_7909())) continue;
                return true;
            }
        }
        return false;
    }

    public final List<class_1799> convertItems(List<class_1799> toConvert) {
        class_1799 it;
        T type;
        ArrayList<class_1799> newItems = new ArrayList<class_1799>();
        boolean success = false;
        Iterator<class_1799> iterator = toConvert.iterator();
        while (iterator.hasNext() && (type = this.registry.getBlockTypeOf((class_1935)(it = iterator.next()).method_7909())) == this.fromType) {
            class_1792 newItem = BlockType.changeItemType(it.method_7909(), this.fromType, this.toType);
            if (newItem == null) continue;
            newItems.add(it.method_60503((class_1935)newItem));
            success = true;
        }
        if (!success) {
            newItems.addAll(toConvert);
        }
        return newItems;
    }

    public List<class_1799> getMatchingStacks() {
        if (this.items == null) {
            this.items = this.convertItems(Arrays.asList(this.inner.method_8105()));
        }
        return this.items;
    }

    @NotNull
    private static MapCodec<BlockTypeSwapIngredient<?>> makeCodec(final boolean nonEmpty) {
        return new MapCodec<BlockTypeSwapIngredient<?>>(){

            public <T> Stream<T> keys(DynamicOps<T> ops) {
                return Stream.of("block_type", "from", "to", "ingredient").map(arg_0 -> ops.createString(arg_0));
            }

            public <T> DataResult<BlockTypeSwapIngredient<?>> decode(DynamicOps<T> ops, MapLike<T> input) {
                Codec ingCodec = nonEmpty ? class_1856.field_46096 : class_1856.field_46095;
                class_1856 inner = (class_1856)ingCodec.parse(ops, input.get(ops.createString("ingredient"))).result().orElseThrow();
                BlockTypeRegistry reg = (BlockTypeRegistry)BlockTypeRegistry.getRegistryCodec().parse(ops, input.get(ops.createString("block_type"))).result().orElseThrow();
                Object fromType = ops.createString("from");
                BlockType from = (BlockType)reg.getCodec().parse(ops, input.get(fromType)).result().orElseThrow();
                Object toType = ops.createString("to");
                BlockType to = (BlockType)reg.getCodec().parse(ops, input.get(toType)).result().orElseThrow();
                return DataResult.success(BlockTypeSwapIngredient.create(inner, from, to, reg));
            }

            public <T> RecordBuilder<T> encode(BlockTypeSwapIngredient<?> ingr, DynamicOps<T> ops, RecordBuilder<T> prefix) {
                Codec ingCodec = nonEmpty ? class_1856.field_46096 : class_1856.field_46095;
                prefix.add(ops.createString("ingredient"), ingCodec.encodeStart(ops, (Object)ingr.inner));
                prefix.add(ops.createString("block_type"), BlockTypeRegistry.getRegistryCodec().encodeStart(ops, ingr.registry));
                Codec codec = ingr.registry.getCodec();
                prefix.add(ops.createString("from"), codec.encodeStart(ops, ingr.fromType));
                prefix.add(ops.createString("to"), codec.encodeStart(ops, ingr.toType));
                return prefix;
            }
        };
    }
}

