/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.data;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.Codec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import com.yungnickyoung.minecraft.ribbits.data.RibbitInstrument;
import com.yungnickyoung.minecraft.ribbits.data.RibbitProfession;
import com.yungnickyoung.minecraft.ribbits.data.RibbitUmbrellaType;
import com.yungnickyoung.minecraft.ribbits.module.RibbitInstrumentModule;
import com.yungnickyoung.minecraft.ribbits.module.RibbitProfessionModule;
import com.yungnickyoung.minecraft.ribbits.module.RibbitUmbrellaTypeModule;
import net.minecraft.class_2540;
import net.minecraft.class_2960;
import net.minecraft.class_9139;
import org.jetbrains.annotations.Nullable;

public class RibbitData {
    public static final Codec<RibbitData> CODEC = RecordCodecBuilder.create(instance -> instance.group((App)class_2960.field_25139.fieldOf("profession").forGetter(data -> data.profession.getId()), (App)class_2960.field_25139.fieldOf("umbrella").forGetter(data -> data.umbrellaType.getId()), (App)class_2960.field_25139.fieldOf("instrument").forGetter(data -> data.instrument.getId())).apply((Applicative)instance, instance.stable(RibbitData::new)));
    public static final class_9139<class_2540, RibbitData> STREAM_CODEC = class_9139.method_56436((class_9139)class_2960.field_48267, data -> data.profession.getId(), (class_9139)class_2960.field_48267, data -> data.umbrellaType.getId(), (class_9139)class_2960.field_48267, data -> data.instrument.getId(), RibbitData::new);
    private RibbitProfession profession;
    private final RibbitUmbrellaType umbrellaType;
    private RibbitInstrument instrument;

    private RibbitData(class_2960 professionId, class_2960 umbrellaTypeId, class_2960 instrumentId) {
        this.profession = RibbitProfessionModule.getProfession(professionId);
        this.umbrellaType = RibbitUmbrellaTypeModule.getUmbrellaType(umbrellaTypeId);
        this.instrument = RibbitInstrumentModule.getInstrument(instrumentId);
    }

    public RibbitData(RibbitProfession profession, RibbitUmbrellaType umbrellaType, RibbitInstrument instrument) {
        this.profession = profession;
        this.umbrellaType = umbrellaType;
        this.instrument = instrument;
    }

    public RibbitData(class_2540 buf) {
        this.profession = RibbitProfessionModule.getProfession(buf.method_10810());
        this.umbrellaType = RibbitUmbrellaTypeModule.getUmbrellaType(buf.method_10810());
        this.instrument = RibbitInstrumentModule.getInstrument(buf.method_10810());
    }

    public void write(class_2540 buf) {
        buf.method_10812(this.getProfession().getId());
        buf.method_10812(this.getUmbrellaType().getId());
        buf.method_10812(this.getInstrument().getId());
    }

    public RibbitProfession getProfession() {
        return this.profession;
    }

    public void setProfession(RibbitProfession profession) {
        this.profession = profession;
    }

    public RibbitUmbrellaType getUmbrellaType() {
        return this.umbrellaType;
    }

    public RibbitInstrument getInstrument() {
        return this.instrument;
    }

    public void setInstrument(@Nullable RibbitInstrument instrument) {
        this.instrument = instrument;
    }
}

