/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.entity;

import com.mojang.serialization.DynamicOps;
import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.ribbits.data.RibbitData;
import com.yungnickyoung.minecraft.ribbits.data.RibbitInstrument;
import com.yungnickyoung.minecraft.ribbits.entity.goal.RibbitApplyBuffGoal;
import com.yungnickyoung.minecraft.ribbits.entity.goal.RibbitFishGoal;
import com.yungnickyoung.minecraft.ribbits.entity.goal.RibbitGoHomeGoal;
import com.yungnickyoung.minecraft.ribbits.entity.goal.RibbitPlayMusicGoal;
import com.yungnickyoung.minecraft.ribbits.entity.goal.RibbitStopAndStareAtFrogGoal;
import com.yungnickyoung.minecraft.ribbits.entity.goal.RibbitStrollGoal;
import com.yungnickyoung.minecraft.ribbits.entity.goal.RibbitWaterCropsGoal;
import com.yungnickyoung.minecraft.ribbits.module.EntityDataSerializerModule;
import com.yungnickyoung.minecraft.ribbits.module.ParticleTypeModule;
import com.yungnickyoung.minecraft.ribbits.module.RibbitInstrumentModule;
import com.yungnickyoung.minecraft.ribbits.module.RibbitProfessionModule;
import com.yungnickyoung.minecraft.ribbits.module.RibbitTradeModule;
import com.yungnickyoung.minecraft.ribbits.module.RibbitUmbrellaTypeModule;
import com.yungnickyoung.minecraft.ribbits.module.SoundModule;
import java.time.LocalDate;
import java.time.temporal.ChronoField;
import java.util.HashSet;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_1266;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1282;
import net.minecraft.class_1296;
import net.minecraft.class_1297;
import net.minecraft.class_1299;
import net.minecraft.class_1303;
import net.minecraft.class_1308;
import net.minecraft.class_1314;
import net.minecraft.class_1315;
import net.minecraft.class_1347;
import net.minecraft.class_1352;
import net.minecraft.class_1361;
import net.minecraft.class_1374;
import net.minecraft.class_1409;
import net.minecraft.class_156;
import net.minecraft.class_1657;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_1914;
import net.minecraft.class_1915;
import net.minecraft.class_1916;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_2394;
import net.minecraft.class_2398;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_2680;
import net.minecraft.class_2940;
import net.minecraft.class_2941;
import net.minecraft.class_2943;
import net.minecraft.class_2945;
import net.minecraft.class_3218;
import net.minecraft.class_3414;
import net.minecraft.class_3532;
import net.minecraft.class_3730;
import net.minecraft.class_4255;
import net.minecraft.class_5132;
import net.minecraft.class_5134;
import net.minecraft.class_5425;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import software.bernie.geckolib.animatable.GeoAnimatable;
import software.bernie.geckolib.animatable.GeoEntity;
import software.bernie.geckolib.animatable.instance.AnimatableInstanceCache;
import software.bernie.geckolib.animation.AnimatableManager;
import software.bernie.geckolib.animation.AnimationController;
import software.bernie.geckolib.animation.AnimationState;
import software.bernie.geckolib.animation.PlayState;
import software.bernie.geckolib.animation.RawAnimation;
import software.bernie.geckolib.util.GeckoLibUtil;

public class RibbitEntity
extends class_1296
implements GeoEntity,
class_1915 {
    private final AnimatableInstanceCache cache = GeckoLibUtil.createInstanceCache((GeoAnimatable)this);
    private static final RawAnimation IDLE = RawAnimation.begin().thenPlay("idle");
    private static final RawAnimation IDLE_HOLDING_1 = RawAnimation.begin().thenPlay("idle_holding_1");
    private static final RawAnimation IDLE_HOLDING_2 = RawAnimation.begin().thenPlay("idle_holding_2");
    private static final RawAnimation IDLE_HOLDING_HAT = RawAnimation.begin().thenPlay("idle_holding_hat");
    private static final RawAnimation IDLE_HOLDING_FISHERMAN = RawAnimation.begin().thenPlay("idle_holding_fisherman");
    private static final RawAnimation WALK = RawAnimation.begin().thenPlay("walk");
    private static final RawAnimation WALK_HOLDING_1 = RawAnimation.begin().thenPlay("walk_holding_1");
    private static final RawAnimation WALK_HOLDING_2 = RawAnimation.begin().thenPlay("walk_holding_2");
    private static final RawAnimation WALK_HOLDING_HAT = RawAnimation.begin().thenPlay("walk_holding_hat");
    private static final RawAnimation WALK_HOLDING_FISHERMAN = RawAnimation.begin().thenPlay("walk_holding_fisherman");
    private static final RawAnimation SORCERER_BUFF = RawAnimation.begin().thenPlay("spell");
    private static final RawAnimation SORCERER_BUFF_HOLDING = RawAnimation.begin().thenPlay("spell_holding");
    private static final RawAnimation FISH = RawAnimation.begin().thenPlay("fishing");
    private static final RawAnimation FISH_HOLDING = RawAnimation.begin().thenPlay("fishing_holding");
    private static final RawAnimation WATER_CROPS = RawAnimation.begin().thenPlay("water_crops");
    private static final RawAnimation WATER_CROPS_HOLDING = RawAnimation.begin().thenPlay("water_crops_holding");
    private static final RawAnimation FALLING = RawAnimation.begin().thenPlay("ribbit_fall");
    private static final RawAnimation FALLING_FISHERMAN = RawAnimation.begin().thenPlay("fisherman_ribbit_fall");
    @Nullable
    private class_1657 tradingPlayer;
    @Nullable
    protected class_1916 offers;
    private long lastRestockGameTime;
    private int numberOfRestocksToday;
    private long lastRestockCheckDayTime;
    public static final float WATER_SPEED_MULTIPLIER = 2.0f;
    private final RibbitPlayMusicGoal musicGoal = new RibbitPlayMusicGoal(this, 1.0, 2000, 3000);
    private final RibbitWaterCropsGoal waterCropsGoal = new RibbitWaterCropsGoal(this, 16.0, 1.0f, 1200);
    private final RibbitFishGoal fishGoal = new RibbitFishGoal(this, 16.0, 1.0f, 600, 1800);
    private final RibbitApplyBuffGoal applyBuffGoal = new RibbitApplyBuffGoal(this, 32.0, 12000);
    private static final class_2940<RibbitData> RIBBIT_DATA = class_2945.method_12791(RibbitEntity.class, EntityDataSerializerModule.RIBBIT_DATA_SERIALIZER);
    private static final class_2940<Boolean> PLAYING_INSTRUMENT = class_2945.method_12791(RibbitEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> UMBRELLA_FALLING = class_2945.method_12791(RibbitEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> WATERING = class_2945.method_12791(RibbitEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> FISHING = class_2945.method_12791(RibbitEntity.class, (class_2941)class_2943.field_13323);
    private static final class_2940<Boolean> BUFFING = class_2945.method_12791(RibbitEntity.class, (class_2941)class_2943.field_13323);
    private RibbitData sidedRibbitData = new RibbitData(RibbitProfessionModule.NITWIT, RibbitUmbrellaTypeModule.UMBRELLA_1, RibbitInstrumentModule.NONE);
    private boolean isPlayingInstrument = false;
    private boolean isUmbrellaFalling = false;
    private boolean isWatering = false;
    private boolean isFishing = false;
    private boolean isBuffing = false;
    private int ticksPlayingMusic;
    private class_2338 homePosition;
    private Set<RibbitEntity> ribbitsPlayingMusic = new HashSet<RibbitEntity>();
    private Set<class_1657> playersHearingMusic = new HashSet<class_1657>();
    private Set<RibbitInstrument> bandMembers = new HashSet<RibbitInstrument>();
    @Nullable
    private RibbitEntity masterRibbit;
    private int buffCooldown = 0;
    private int waterCropsCooldown = 0;

    public RibbitEntity(class_1299<RibbitEntity> entityType, class_1937 level) {
        super(entityType, level);
        ((class_1409)this.method_5942()).method_6363(true);
        this.reassessGoals();
    }

    protected void method_5959() {
        super.method_5959();
        this.field_6201.method_6277(0, (class_1352)new class_4255((class_1308)this, true));
        this.field_6201.method_6277(0, (class_1352)new class_1347((class_1308)this));
        this.field_6201.method_6277(1, (class_1352)new RibbitGoHomeGoal(this, 1.8f, 1.0f, 60));
        this.field_6201.method_6277(2, (class_1352)new class_1374((class_1314)this, 1.5));
        this.field_6201.method_6277(3, (class_1352)new RibbitStopAndStareAtFrogGoal(this, 4.0f));
        this.field_6201.method_6277(4, (class_1352)new class_1361((class_1308)this, class_1657.class, 8.0f));
        this.field_6201.method_6277(5, (class_1352)new RibbitStrollGoal(this, 1.0, 16));
    }

    public void method_6007() {
        super.method_6007();
        if (!this.method_37908().field_9236) {
            if (this.field_6012 % 600 == 0 && this.method_6032() < this.method_6063()) {
                this.method_6033(Math.min(this.method_6032() + 1.0f, this.method_6063()));
            }
            if (this.method_24828() && this.isUmbrellaFalling()) {
                this.setUmbrellaFalling(false);
            }
            if (this.field_6017 >= 2.0f || this.isUmbrellaFalling()) {
                class_243 velocity = this.method_18798();
                this.method_38785();
                this.method_18800(velocity.field_1352, -0.1, velocity.field_1350);
                this.setUmbrellaFalling(true);
            }
            if (this.buffCooldown > 0) {
                --this.buffCooldown;
            }
            if (this.waterCropsCooldown > 0) {
                --this.waterCropsCooldown;
            }
            if (this.shouldRestock()) {
                this.restock();
            }
        }
    }

    public void method_5773() {
        super.method_5773();
        if (this.getBuffing() && this.method_37908().method_8608()) {
            double radius = 1.25;
            for (float theta = 0.0f; theta < (float)Math.PI * 2; theta += this.field_5974.method_43057() * 0.8f + 0.5f) {
                this.method_37908().method_8406((class_2394)ParticleTypeModule.SPELL.get(), this.method_23317() + (double)class_3532.method_15362((float)theta) * radius, this.method_23318(), this.method_23321() + (double)class_3532.method_15374((float)theta) * radius, 0.0, 0.0, 0.0);
            }
        }
    }

    protected void method_5693(class_2945.class_9222 builder) {
        super.method_5693(builder);
        builder.method_56912(RIBBIT_DATA, (Object)new RibbitData(RibbitProfessionModule.NITWIT, RibbitUmbrellaTypeModule.UMBRELLA_1, RibbitInstrumentModule.NONE));
        builder.method_56912(PLAYING_INSTRUMENT, (Object)false);
        builder.method_56912(UMBRELLA_FALLING, (Object)false);
        builder.method_56912(WATERING, (Object)false);
        builder.method_56912(FISHING, (Object)false);
        builder.method_56912(BUFFING, (Object)false);
    }

    public void method_5749(@NotNull class_2487 tag) {
        super.method_5749(tag);
        if (tag.method_10573("RibbitData", 10)) {
            RibbitData.CODEC.parse((DynamicOps)class_2509.field_11560, (Object)tag.method_10580("RibbitData")).resultOrPartial(arg_0 -> ((Logger)RibbitsCommon.LOGGER).error(arg_0)).ifPresent(this::setRibbitData);
        }
        if (tag.method_10573("Offers", 10)) {
            class_1916.field_48850.parse((DynamicOps)this.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)tag.method_10580("Offers")).resultOrPartial(class_156.method_29188((String)"Failed to load offers: ", arg_0 -> ((Logger)RibbitsCommon.LOGGER).warn(arg_0))).ifPresent(offers -> {
                this.offers = offers;
            });
        }
        this.homePosition = tag.method_10545("HomePosX") && tag.method_10545("HomePosY") && tag.method_10545("HomePosZ") ? new class_2338(tag.method_10550("HomePosX"), tag.method_10550("HomePosY"), tag.method_10550("HomePosZ")) : new class_2338((class_2382)this.method_24515());
        this.reassessGoals();
    }

    public void method_5652(@NotNull class_2487 tag) {
        class_1916 offers;
        super.method_5652(tag);
        RibbitData.CODEC.encodeStart((DynamicOps)class_2509.field_11560, (Object)this.getRibbitData()).resultOrPartial(arg_0 -> ((Logger)RibbitsCommon.LOGGER).error(arg_0)).ifPresent(t -> tag.method_10566("RibbitData", t));
        if (!this.method_37908().field_9236 && !(offers = this.method_8264()).isEmpty()) {
            tag.method_10566("Offers", (class_2520)class_1916.field_48850.encodeStart((DynamicOps)this.method_56673().method_57093((DynamicOps)class_2509.field_11560), (Object)offers).getOrThrow());
        }
        if (this.homePosition != null) {
            tag.method_10569("HomePosX", this.homePosition.method_10263());
            tag.method_10569("HomePosY", this.homePosition.method_10264());
            tag.method_10569("HomePosZ", this.homePosition.method_10260());
        }
    }

    public void method_5674(@NotNull class_2940<?> dataAccessor) {
        super.method_5674(dataAccessor);
        if (RIBBIT_DATA.equals(dataAccessor)) {
            this.sidedRibbitData = (RibbitData)this.field_6011.method_12789(RIBBIT_DATA);
        } else if (UMBRELLA_FALLING.equals(dataAccessor)) {
            this.isUmbrellaFalling = (Boolean)this.field_6011.method_12789(UMBRELLA_FALLING);
        } else if (PLAYING_INSTRUMENT.equals(dataAccessor)) {
            this.isPlayingInstrument = (Boolean)this.field_6011.method_12789(PLAYING_INSTRUMENT);
        } else if (FISHING.equals(dataAccessor)) {
            this.isFishing = (Boolean)this.field_6011.method_12789(FISHING);
        } else if (WATERING.equals(dataAccessor)) {
            this.isWatering = (Boolean)this.field_6011.method_12789(WATERING);
        } else if (BUFFING.equals(dataAccessor)) {
            this.isBuffing = (Boolean)this.field_6011.method_12789(BUFFING);
        }
    }

    @ParametersAreNonnullByDefault
    public class_1315 method_5943(class_5425 level, class_1266 difficulty, class_3730 spawnType, @Nullable class_1315 groupData) {
        class_1315 data = super.method_5943(level, difficulty, spawnType, groupData);
        this.reassessGoals();
        this.homePosition = this.method_24515();
        return data;
    }

    public boolean method_5974(double $$0) {
        return false;
    }

    @NotNull
    public class_1269 method_5992(class_1657 player, @NotNull class_1268 interactionHand) {
        class_1799 itemStack = player.method_5998(interactionHand);
        if (player.method_21823() && itemStack.method_31574(class_1802.field_27063)) {
            this.homePosition = this.method_24515();
            this.method_37908().method_8421((class_1297)this, (byte)12);
            if (!player.method_31549().field_7477) {
                itemStack.method_7934(1);
            }
        } else if (this.method_5805() && !this.isTrading() && !this.method_6113()) {
            if (this.method_6109()) {
                return class_1269.field_5811;
            }
            boolean bl = this.method_8264().isEmpty();
            if (bl) {
                return class_1269.field_5811;
            }
            if (!this.method_37908().field_9236 && !this.offers.isEmpty()) {
                this.startTrading(player);
            }
            return class_1269.method_29236((boolean)this.method_37908().field_9236);
        }
        return super.method_5992(player, interactionHand);
    }

    public void reassessGoals() {
        if (this.method_37908().field_9236) {
            return;
        }
        this.field_6201.method_6280((class_1352)this.musicGoal);
        this.field_6201.method_6280((class_1352)this.waterCropsGoal);
        this.field_6201.method_6280((class_1352)this.fishGoal);
        this.field_6201.method_6280((class_1352)this.applyBuffGoal);
        if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.NITWIT)) {
            this.field_6201.method_6277(6, (class_1352)this.musicGoal);
        } else if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.GARDENER)) {
            this.field_6201.method_6277(6, (class_1352)this.waterCropsGoal);
        } else if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.FISHERMAN)) {
            this.field_6201.method_6277(6, (class_1352)this.fishGoal);
        } else if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.SORCERER)) {
            this.field_6201.method_6277(6, (class_1352)this.applyBuffGoal);
        }
    }

    public float method_6029() {
        return super.method_6029();
    }

    public void method_5711(byte flag) {
        if (flag == 12) {
            this.addParticlesAroundSelf((class_2394)class_2398.field_11201);
        }
        super.method_5711(flag);
    }

    protected void addParticlesAroundSelf(class_2394 particleOptions) {
        for (int i = 0; i < 5; ++i) {
            double d = this.field_5974.method_43059() * 0.02;
            double e = this.field_5974.method_43059() * 0.02;
            double f = this.field_5974.method_43059() * 0.02;
            this.method_37908().method_8406(particleOptions, this.method_23322(1.0), this.method_23319() + 1.0, this.method_23325(1.0), d, e, f);
        }
    }

    public int method_5978() {
        return 0;
    }

    public int method_5986() {
        return 0;
    }

    @Nullable
    public class_1296 method_5613(class_3218 level, class_1296 parent) {
        return null;
    }

    public void setInstrument(RibbitInstrument instrument) {
        this.getRibbitData().setInstrument(instrument);
        this.field_6011.method_49743(RIBBIT_DATA, (Object)this.getRibbitData(), true);
    }

    public int getBuffCooldown() {
        return this.buffCooldown;
    }

    public void setBuffCooldown(int cooldown) {
        this.buffCooldown = cooldown;
    }

    public int getWaterCropsCooldown() {
        return this.waterCropsCooldown;
    }

    public void setWaterCropsCooldown(int cooldown) {
        this.waterCropsCooldown = cooldown;
    }

    public RibbitData getRibbitData() {
        return this.sidedRibbitData;
    }

    public void setRibbitData(RibbitData data) {
        this.field_6011.method_12778(RIBBIT_DATA, (Object)data);
    }

    public class_2338 getHomePosition() {
        return this.homePosition;
    }

    public boolean getPlayingInstrument() {
        return this.isPlayingInstrument;
    }

    public void setPlayingInstrument(boolean playingInstrument) {
        this.field_6011.method_12778(PLAYING_INSTRUMENT, (Object)playingInstrument);
    }

    public boolean isUmbrellaFalling() {
        return this.isUmbrellaFalling;
    }

    public void setUmbrellaFalling(boolean umbrellaFalling) {
        this.field_6011.method_12778(UMBRELLA_FALLING, (Object)umbrellaFalling);
    }

    public boolean getWatering() {
        return this.isWatering;
    }

    public void setWatering(boolean isWatering) {
        this.field_6011.method_12778(WATERING, (Object)isWatering);
    }

    public boolean getFishing() {
        return this.isFishing;
    }

    public void setFishing(boolean isFishing) {
        this.field_6011.method_12778(FISHING, (Object)isFishing);
    }

    public boolean getBuffing() {
        return this.isBuffing;
    }

    public void setBuffing(boolean isBuffing) {
        this.field_6011.method_12778(BUFFING, (Object)isBuffing);
    }

    public int getTicksPlayingMusic() {
        return this.ticksPlayingMusic;
    }

    public void setTicksPlayingMusic(int ticksPlayingMusic) {
        this.ticksPlayingMusic = ticksPlayingMusic;
    }

    public Set<RibbitEntity> getRibbitsPlayingMusic() {
        return this.ribbitsPlayingMusic;
    }

    public void setRibbitsPlayingMusic(Set<RibbitEntity> ribbitsPlayingMusic) {
        this.ribbitsPlayingMusic = new HashSet<RibbitEntity>(ribbitsPlayingMusic);
    }

    public void addRibbitToPlayingMusic(RibbitEntity ribbit) {
        this.ribbitsPlayingMusic.add(ribbit);
    }

    public void removeRibbitFromPlayingMusic(RibbitEntity ribbit) {
        this.ribbitsPlayingMusic.remove((Object)ribbit);
    }

    public Set<class_1657> getPlayersHearingMusic() {
        return this.playersHearingMusic;
    }

    public void setPlayersHearingMusic(Set<class_1657> playersHearingMusic) {
        this.playersHearingMusic = new HashSet<class_1657>(playersHearingMusic);
    }

    @Nullable
    public RibbitEntity getMasterRibbit() {
        return this.masterRibbit;
    }

    public void setMasterRibbit(RibbitEntity masterRibbit) {
        this.masterRibbit = masterRibbit;
    }

    public boolean isMasterRibbit() {
        return this.equals((Object)this.getMasterRibbit());
    }

    public void findNewMasterRibbit() {
        RibbitEntity newMaster = this.getRibbitsPlayingMusic().stream().filter(ribbit -> ribbit != this).findAny().orElse(null);
        if (newMaster != null) {
            for (RibbitEntity ribbit2 : this.getRibbitsPlayingMusic()) {
                ribbit2.setMasterRibbit(newMaster);
            }
            this.getRibbitsPlayingMusic().remove((Object)this);
            this.removeBandMember(this.getRibbitData().getInstrument());
            newMaster.setRibbitsPlayingMusic(this.getRibbitsPlayingMusic());
            newMaster.setPlayersHearingMusic(this.getPlayersHearingMusic());
            newMaster.setTicksPlayingMusic(this.getTicksPlayingMusic());
            newMaster.setBandMembers(this.getBandMembers());
        }
        this.getRibbitsPlayingMusic().clear();
        this.getPlayersHearingMusic().clear();
        this.setTicksPlayingMusic(0);
        this.clearBandMembers();
    }

    public boolean isBandFull() {
        return this.bandMembers.size() == RibbitInstrumentModule.getNumInstruments();
    }

    public void addBandMember(RibbitInstrument instrument) {
        this.bandMembers.add(instrument);
    }

    public void removeBandMember(RibbitInstrument instrument) {
        this.bandMembers.remove(instrument);
    }

    public void clearBandMembers() {
        this.bandMembers.clear();
    }

    public Set<RibbitInstrument> getBandMembers() {
        return this.bandMembers;
    }

    public void setBandMembers(Set<RibbitInstrument> bandMembers) {
        this.bandMembers = new HashSet<RibbitInstrument>(bandMembers);
    }

    public void method_5650(class_1297.class_5529 reason) {
        if (this.isMasterRibbit()) {
            this.findNewMasterRibbit();
        } else if (this.isPlayingInstrument && this.getMasterRibbit() != null) {
            this.getMasterRibbit().getRibbitsPlayingMusic().remove((Object)this);
            this.getMasterRibbit().removeBandMember(this.getRibbitData().getInstrument());
        }
        super.method_5650(reason);
    }

    public static class_5132.class_5133 createRibbitAttributes() {
        return RibbitEntity.method_26828().method_26868(class_5134.field_23716, 15.0).method_26868(class_5134.field_23719, 0.125).method_26868(class_5134.field_23721, 1.0);
    }

    @Nullable
    protected class_3414 method_5994() {
        return (class_3414)SoundModule.ENTITY_RIBBIT_AMBIENT.get();
    }

    @Nullable
    protected class_3414 method_6011(class_1282 $$0) {
        return (class_3414)SoundModule.ENTITY_RIBBIT_HURT.get();
    }

    @Nullable
    protected class_3414 method_6002() {
        return (class_3414)SoundModule.ENTITY_RIBBIT_DEATH.get();
    }

    protected void method_5712(class_2338 pos, class_2680 blockstate) {
        super.method_5712(pos, blockstate);
        this.method_5783((class_3414)SoundModule.ENTITY_RIBBIT_STEP.get(), 1.0f, 1.0f);
    }

    public boolean isPrideRibbit() {
        Random rand = new Random(this.method_5667().getLeastSignificantBits());
        return RibbitEntity.isPrideMonth() && this.getRibbitData().getProfession().equals(RibbitProfessionModule.NITWIT) && rand.nextFloat() < 0.33f;
    }

    private static boolean isPrideMonth() {
        if (RibbitsCommon.CONFIG.prideFlagAllYear) {
            return true;
        }
        LocalDate date = LocalDate.now();
        int month = date.get(ChronoField.MONTH_OF_YEAR);
        return month == 6;
    }

    public boolean isInRain() {
        class_2338 pos = this.method_24515();
        return this.method_37908().method_8520(pos) || this.method_37908().method_8520(class_2338.method_49637((double)pos.method_10263(), (double)this.method_5829().field_1325, (double)pos.method_10260()));
    }

    private <E extends GeoAnimatable> PlayState predicate(AnimationState<E> state) {
        if (this.isUmbrellaFalling()) {
            state.getController().setAnimation(this.getRibbitData().getProfession() == RibbitProfessionModule.FISHERMAN ? FALLING_FISHERMAN : FALLING);
        } else if (this.getPlayingInstrument() && this.getRibbitData().getInstrument() != RibbitInstrumentModule.NONE) {
            state.getController().setAnimation(RawAnimation.begin().thenPlay(this.getRibbitData().getInstrument().getAnimationName()));
        } else if (this.getBuffing()) {
            state.getController().setAnimation(this.isInRain() ? SORCERER_BUFF_HOLDING : SORCERER_BUFF);
        } else if (this.getFishing()) {
            state.getController().setAnimation(this.isInRain() ? FISH_HOLDING : FISH);
        } else if (this.getWatering()) {
            state.getController().setAnimation(this.isInRain() ? WATER_CROPS_HOLDING : WATER_CROPS);
        } else if (state.isMoving() && !this.method_5799()) {
            state.getController().setAnimation(this.getWalkAnimation());
        } else {
            state.getController().setAnimation(this.getIdleAnimation());
        }
        return PlayState.CONTINUE;
    }

    private RawAnimation getWalkAnimation() {
        if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.FISHERMAN)) {
            return this.isInRain() ? WALK_HOLDING_FISHERMAN : WALK_HOLDING_2;
        }
        if (this.isPrideRibbit()) {
            return WALK_HOLDING_2;
        }
        if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.SORCERER) || this.getRibbitData().getProfession().equals(RibbitProfessionModule.GARDENER)) {
            return this.isInRain() ? WALK_HOLDING_HAT : WALK;
        }
        return this.isInRain() ? WALK_HOLDING_1 : WALK;
    }

    private RawAnimation getIdleAnimation() {
        if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.FISHERMAN)) {
            return this.isInRain() ? IDLE_HOLDING_FISHERMAN : IDLE_HOLDING_2;
        }
        if (this.isPrideRibbit()) {
            return IDLE_HOLDING_2;
        }
        if (this.getRibbitData().getProfession().equals(RibbitProfessionModule.SORCERER) || this.getRibbitData().getProfession().equals(RibbitProfessionModule.GARDENER)) {
            return this.isInRain() ? IDLE_HOLDING_HAT : IDLE;
        }
        return this.isInRain() ? IDLE_HOLDING_1 : IDLE;
    }

    public void registerControllers(AnimatableManager.ControllerRegistrar controllerRegistrar) {
        controllerRegistrar.add(new AnimationController((GeoAnimatable)this, "controller", 5, this::predicate));
    }

    public AnimatableInstanceCache getAnimatableInstanceCache() {
        return this.cache;
    }

    @Nullable
    public class_1657 method_8257() {
        return this.tradingPlayer;
    }

    public class_1916 method_8264() {
        if (this.offers == null) {
            this.offers = new class_1916();
            RibbitTradeModule.updateTrades(this);
        }
        return this.offers;
    }

    public void method_8261(class_1916 merchantOffers) {
    }

    public void method_8262(class_1914 merchantOffer) {
        merchantOffer.method_8244();
        this.field_6191 = -this.method_5970();
        this.rewardTradeXp(merchantOffer);
    }

    protected void rewardTradeXp(class_1914 merchantOffer) {
        int i = 3 + this.field_5974.method_43048(4);
        if (merchantOffer.method_8256()) {
            this.method_37908().method_8649((class_1297)new class_1303(this.method_37908(), this.method_23317(), this.method_23318() + 0.5, this.method_23321(), i));
        }
    }

    public void method_8258(class_1799 itemStack) {
        if (!this.method_37908().field_9236 && this.field_6191 > -this.method_5970() + 20) {
            this.field_6191 = -this.method_5970();
        }
    }

    private void startTrading(class_1657 player) {
        this.method_8259(player);
        this.method_17449(player, this.method_5476(), 0);
    }

    public void method_8259(@Nullable class_1657 player) {
        boolean bl = this.method_8257() != null && player == null;
        this.tradingPlayer = player;
        if (bl) {
            this.stopTrading();
        }
    }

    protected void stopTrading() {
        this.method_8259(null);
        this.resetSpecialPrices();
    }

    private void resetSpecialPrices() {
        for (class_1914 merchantOffer : this.method_8264()) {
            merchantOffer.method_19276();
        }
    }

    public boolean method_20708() {
        return true;
    }

    public void restock() {
        this.updateDemand();
        for (class_1914 merchantOffer : this.method_8264()) {
            merchantOffer.method_19275();
        }
        this.resendOffersToTradingPlayer();
        this.lastRestockGameTime = this.method_37908().method_8510();
        ++this.numberOfRestocksToday;
    }

    private void resendOffersToTradingPlayer() {
        class_1916 merchantOffers = this.method_8264();
        class_1657 player = this.method_8257();
        if (player != null && !merchantOffers.isEmpty()) {
            player.method_17354(player.field_7512.field_7763, merchantOffers, 0, this.method_19269(), this.method_19270(), this.method_20708());
        }
    }

    private boolean needsToRestock() {
        for (class_1914 merchantOffer : this.method_8264()) {
            if (!merchantOffer.method_21834()) continue;
            return true;
        }
        return false;
    }

    private boolean allowedToRestock() {
        return this.numberOfRestocksToday == 0 || this.numberOfRestocksToday < 2 && this.method_37908().method_8510() > this.lastRestockGameTime + 2400L;
    }

    public boolean shouldRestock() {
        long l = this.lastRestockGameTime + 12000L;
        long m = this.method_37908().method_8510();
        boolean bl = m > l;
        long n = this.method_37908().method_8532();
        if (this.lastRestockCheckDayTime > 0L) {
            long p = n / 24000L;
            long o = this.lastRestockCheckDayTime / 24000L;
            bl |= p > o;
        }
        this.lastRestockCheckDayTime = n;
        if (bl) {
            this.lastRestockGameTime = m;
            this.resetNumberOfRestocks();
        }
        return this.allowedToRestock() && this.needsToRestock();
    }

    private void resetNumberOfRestocks() {
        this.catchUpDemand();
        this.numberOfRestocksToday = 0;
    }

    private void catchUpDemand() {
        int i = 2 - this.numberOfRestocksToday;
        if (i > 0) {
            for (class_1914 merchantOffer : this.method_8264()) {
                merchantOffer.method_19275();
            }
        }
        for (int j = 0; j < i; ++j) {
            this.updateDemand();
        }
        this.resendOffersToTradingPlayer();
    }

    private void updateDemand() {
        for (class_1914 merchantOffer : this.method_8264()) {
            merchantOffer.method_19274();
        }
    }

    public boolean isTrading() {
        return this.tradingPlayer != null;
    }

    public int method_19269() {
        return 0;
    }

    public void method_19271(int i) {
    }

    public boolean method_19270() {
        return false;
    }

    public class_3414 method_18010() {
        return null;
    }

    public boolean method_38069() {
        return this.method_37908().method_8608();
    }
}

