/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.module;

import com.yungnickyoung.minecraft.ribbits.RibbitsCommon;
import com.yungnickyoung.minecraft.ribbits.data.RibbitInstrument;
import com.yungnickyoung.minecraft.ribbits.module.SoundModule;
import com.yungnickyoung.minecraft.yungsapi.api.autoregister.AutoRegister;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import javax.annotation.Nullable;
import net.minecraft.class_2960;
import net.minecraft.class_3414;

@AutoRegister(value="ribbits")
public class RibbitInstrumentModule {
    private static final Map<class_2960, RibbitInstrument> INSTRUMENT_REGISTRY = new HashMap<class_2960, RibbitInstrument>();
    private static final Set<RibbitInstrument> VALID_INSTRUMENTS = new HashSet<RibbitInstrument>();
    public static final RibbitInstrument NONE = RibbitInstrumentModule.register("none", "", "", null);
    public static final RibbitInstrument BASS = RibbitInstrumentModule.register("bass", "geo/bass_ribbit.geo.json", "play_bass", (class_3414)SoundModule.MUSIC_RIBBIT_BASS.get());
    public static final RibbitInstrument BONGO = RibbitInstrumentModule.register("bongo", "geo/bongo_ribbit.geo.json", "play_bongo", (class_3414)SoundModule.MUSIC_RIBBIT_BONGO.get());
    public static final RibbitInstrument FLUTE = RibbitInstrumentModule.register("flute", "geo/flute_ribbit.geo.json", "play_flute", (class_3414)SoundModule.MUSIC_RIBBIT_FLUTE.get());
    public static final RibbitInstrument GUITAR = RibbitInstrumentModule.register("guitar", "geo/guitar_ribbit.geo.json", "play_guitar", (class_3414)SoundModule.MUSIC_RIBBIT_GUITAR.get());

    public static RibbitInstrument register(String name, String modelPath, String animationName, class_3414 instrumentSoundEvent) {
        class_2960 id = RibbitsCommon.id(name);
        RibbitInstrument instrument = new RibbitInstrument(id, RibbitsCommon.id(modelPath), animationName, instrumentSoundEvent);
        INSTRUMENT_REGISTRY.put(id, instrument);
        if (!name.equals("none")) {
            VALID_INSTRUMENTS.add(instrument);
        }
        return instrument;
    }

    @Nullable
    public static RibbitInstrument getInstrument(class_2960 id) {
        return INSTRUMENT_REGISTRY.get(id);
    }

    public static RibbitInstrument getRandomInstrument() {
        Random random = new Random();
        List instrumentList = VALID_INSTRUMENTS.stream().toList();
        return (RibbitInstrument)instrumentList.get(random.nextInt(instrumentList.size()));
    }

    public static RibbitInstrument getRandomInstrument(Set<RibbitInstrument> currBandMembers) {
        Random random = new Random();
        List<RibbitInstrument> instrumentList = VALID_INSTRUMENTS.stream().filter(instrument -> !currBandMembers.contains(instrument)).toList();
        if (instrumentList.isEmpty()) {
            return null;
        }
        return instrumentList.get(random.nextInt(instrumentList.size()));
    }

    public static int getNumInstruments() {
        return VALID_INSTRUMENTS.size();
    }

    @AutoRegister(value="_ignored")
    public static void initRibbitsInstruments() {
        RibbitsCommon.LOGGER.info("Registering Ribbit instruments...");
    }
}

