/*
 * Decompiled with CFR 0.152.
 */
package com.yungnickyoung.minecraft.ribbits.world.processor;

import com.mojang.serialization.MapCodec;
import com.yungnickyoung.minecraft.ribbits.module.StructureProcessorTypeModule;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.class_156;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3491;
import net.minecraft.class_3492;
import net.minecraft.class_3499;
import net.minecraft.class_3828;
import net.minecraft.class_4538;
import net.minecraft.class_5819;
import org.jetbrains.annotations.NotNull;

@ParametersAreNonnullByDefault
public class BrewingStandProcessor
extends class_3491 {
    public static final BrewingStandProcessor INSTANCE = new BrewingStandProcessor();
    public static final MapCodec<BrewingStandProcessor> CODEC = MapCodec.unit(() -> INSTANCE);

    public class_3499.class_3501 method_15110(class_4538 levelReader, class_2338 jigsawPiecePos, class_2338 jigsawPieceBottomCenterPos, class_3499.class_3501 blockInfoLocal, class_3499.class_3501 blockInfoGlobal, class_3492 structurePlacementData) {
        if (blockInfoGlobal.comp_1342().method_26204() == class_2246.field_10333) {
            class_5819 randomSource = structurePlacementData.method_15115(blockInfoGlobal.comp_1341());
            class_2487 tag = blockInfoGlobal.comp_1343();
            class_2499 itemsListTag = tag.method_10554("Items", 10);
            this.populateItemsList(itemsListTag, randomSource);
            blockInfoGlobal = new class_3499.class_3501(blockInfoGlobal.comp_1341(), blockInfoGlobal.comp_1342(), tag);
        }
        return blockInfoGlobal;
    }

    @NotNull
    protected class_3828<?> method_16772() {
        return StructureProcessorTypeModule.BREWING_STAND_PROCESSOR;
    }

    private void populateItemsList(class_2499 itemsListTag, class_5819 randomSource) {
        int n = randomSource.method_43048(5);
        switch (n) {
            case 1: {
                this.addBrewingRecipe(itemsListTag, "minecraft:sugar", "minecraft:swiftness", 4, 0.5f, randomSource);
                break;
            }
            case 2: {
                this.addBrewingRecipe(itemsListTag, "minecraft:pufferfish", "minecraft:water_breathing", 3, 0.5f, randomSource);
                break;
            }
            case 3: {
                this.addBrewingRecipe(itemsListTag, "minecraft:phantom_membrane", "minecraft:slow_falling", 1, 0.4f, randomSource);
                break;
            }
            case 4: {
                this.addBrewingRecipe(itemsListTag, "minecraft:rabbit_foot", "minecraft:leaping", 1, 0.25f, randomSource);
            }
        }
    }

    private void addBrewingRecipe(class_2499 itemsListTag, String inputItemId, String outputPotionId, int maxInputCount, float bonusOutputChance, class_5819 randomSource) {
        itemsListTag.add((Object)((class_2520)class_156.method_654((Object)new class_2487(), itemTag -> this.putInputItem((class_2487)itemTag, inputItemId, (byte)(randomSource.method_43048(maxInputCount) + 1)))));
        itemsListTag.add((Object)((class_2520)class_156.method_654((Object)new class_2487(), itemTag -> this.putPotionInSlot((class_2487)itemTag, (byte)1, outputPotionId))));
        if (randomSource.method_43057() < bonusOutputChance) {
            int bonusSlot = randomSource.method_43056() ? 0 : 2;
            itemsListTag.add((Object)((class_2520)class_156.method_654((Object)new class_2487(), itemTag -> this.putPotionInSlot((class_2487)itemTag, (byte)bonusSlot, outputPotionId))));
        }
    }

    private void putInputItem(class_2487 itemTag, String itemId, byte count) {
        itemTag.method_10567("Slot", (byte)3);
        itemTag.method_10582("id", itemId);
        itemTag.method_10567("count", count);
    }

    private void putPotionInSlot(class_2487 itemTag, byte slot, String potionId) {
        itemTag.method_10567("Slot", slot);
        itemTag.method_10582("id", "minecraft:potion");
        itemTag.method_10567("count", (byte)1);
        itemTag.method_10566("components", (class_2520)class_156.method_654((Object)new class_2487(), componentsTag -> componentsTag.method_10566("minecraft:potion_contents", (class_2520)class_156.method_654((Object)new class_2487(), potionContentsTag -> potionContentsTag.method_10582("potion", potionId)))));
    }
}

