/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.plugin.AlmostUnifiedPlugin;
import com.almostreliable.unified.api.unification.recipe.CustomIngredientUnifierRegistry;
import com.almostreliable.unified.api.unification.recipe.RecipeUnifierRegistry;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.ListIterator;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import net.minecraft.class_2960;
import org.jetbrains.annotations.Nullable;

public final class PluginManager {
    @Nullable
    private static PluginManager INSTANCE;
    private final List<AlmostUnifiedPlugin> plugins;

    private PluginManager(List<AlmostUnifiedPlugin> plugins) {
        this.plugins = plugins;
    }

    public static PluginManager instance() {
        if (INSTANCE == null) {
            throw new IllegalStateException("PluginManager is not initialized");
        }
        return INSTANCE;
    }

    public static void init(Collection<AlmostUnifiedPlugin> plugins) {
        if (INSTANCE != null) {
            throw new IllegalStateException("PluginManager is already initialized");
        }
        ArrayList<AlmostUnifiedPlugin> sortedPlugins = new ArrayList<AlmostUnifiedPlugin>(plugins);
        sortedPlugins.sort((a, b) -> {
            if (a.getPluginId().method_12836().equals("almostunified")) {
                return -1;
            }
            if (b.getPluginId().method_12836().equals("almostunified")) {
                return 1;
            }
            return a.getPluginId().method_12833(b.getPluginId());
        });
        String ids = sortedPlugins.stream().map(AlmostUnifiedPlugin::getPluginId).map(class_2960::toString).collect(Collectors.joining(", "));
        AlmostUnifiedCommon.LOGGER.info("Loaded plugins: {}", (Object)ids);
        INSTANCE = new PluginManager(sortedPlugins);
    }

    public void registerCustomIngredientUnifiers(CustomIngredientUnifierRegistry registry) {
        this.forEachPlugin(plugin -> plugin.registerCustomIngredientUnifiers(registry));
    }

    public void registerRecipeUnifiers(RecipeUnifierRegistry registry) {
        this.forEachPlugin(plugin -> plugin.registerRecipeUnifiers(registry));
    }

    public void forEachPlugin(Consumer<AlmostUnifiedPlugin> consumer) {
        ListIterator<AlmostUnifiedPlugin> it = this.plugins.listIterator();
        while (it.hasNext()) {
            AlmostUnifiedPlugin plugin = it.next();
            try {
                consumer.accept(plugin);
            }
            catch (Exception e) {
                it.remove();
                AlmostUnifiedCommon.LOGGER.error("Failed to process plugin {}, removing it.", (Object)plugin.getPluginId(), (Object)e);
            }
        }
    }
}

