/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.compat.viewer;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.api.unification.UnificationEntry;
import com.almostreliable.unified.api.unification.UnificationLookup;
import com.almostreliable.unified.api.unification.UnificationSettings;
import com.almostreliable.unified.utils.Utils;
import com.almostreliable.unified.utils.VanillaTagWrapper;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import net.minecraft.class_1792;
import net.minecraft.class_1802;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import net.minecraft.class_7923;
import net.minecraft.class_7924;

public final class ItemHider {
    public static final class_6862<class_1792> HIDE_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Utils.getRL("hide"));
    public static final class_6862<class_1792> EMI_STRICT_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)Utils.getRL("emi_strict"));

    private ItemHider() {
    }

    public static void applyHideTags(VanillaTagWrapper<class_1792> tags, Collection<UnificationSettings> handlers, boolean emiHidingStrict) {
        for (UnificationSettings handler : handlers) {
            if (!handler.shouldHideVariantItems()) continue;
            ItemHider.applyHideTags(tags, handler);
        }
        if (emiHidingStrict) {
            tags.add(EMI_STRICT_TAG.comp_327(), (class_6880<class_1792>)class_7923.field_41178.method_47983((Object)class_1802.field_8688));
        }
    }

    public static void applyHideTags(VanillaTagWrapper<class_1792> tags, UnificationSettings handler) {
        Set<class_6880<class_1792>> holdersToHide = ItemHider.createHidingItems(handler);
        for (class_6880<class_1792> holder : holdersToHide) {
            tags.add(HIDE_TAG.comp_327(), holder);
        }
    }

    public static Set<class_6880<class_1792>> createHidingItems(UnificationSettings handler) {
        HashSet<class_6880<class_1792>> hidings = new HashSet<class_6880<class_1792>>();
        for (class_6862<class_1792> tag : handler.getTags()) {
            Collection<UnificationEntry<class_1792>> entriesByTag = handler.getTagEntries(tag);
            if (Utils.allSameNamespace(entriesByTag)) continue;
            HashSet<UnificationEntry<class_1792>> replacements = new HashSet<UnificationEntry<class_1792>>();
            for (UnificationEntry<class_1792> holder : entriesByTag) {
                replacements.add(ItemHider.getReplacementForItem(handler, holder));
            }
            HashSet<class_6880.class_6883<class_1792>> toHide = new HashSet<class_6880.class_6883<class_1792>>();
            HashSet<String> toHideIds = new HashSet<String>();
            for (UnificationEntry<class_1792> entry : entriesByTag) {
                if (replacements.contains(entry)) continue;
                toHide.add(entry.asHolderOrThrow());
                toHideIds.add(entry.id().toString());
            }
            if (toHide.isEmpty()) continue;
            AlmostUnifiedCommon.LOGGER.info("[AutoHiding] Hiding {}/{} items for tag '#{}' -> {}", (Object)toHide.size(), (Object)entriesByTag.size(), (Object)tag.comp_327(), toHideIds);
            hidings.addAll(toHide);
        }
        return hidings;
    }

    private static UnificationEntry<class_1792> getReplacementForItem(UnificationLookup repMap, UnificationEntry<class_1792> entry) {
        UnificationEntry<class_1792> replacement = repMap.getVariantItemTarget(entry);
        if (replacement == null) {
            return entry;
        }
        return replacement;
    }
}

