/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.config;

import com.almostreliable.unified.AlmostUnifiedCommon;
import com.almostreliable.unified.AlmostUnifiedPlatform;
import com.almostreliable.unified.utils.JsonUtils;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Supplier;
import java.util.regex.Pattern;
import java.util.stream.Collectors;

public class Config {
    private static final String CONFIG_DIR_PROPERTY = "almostunified.configDir";
    private final String name;

    Config(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public static <T extends Config> T load(String name, Serializer<T> serializer) {
        AlmostUnifiedCommon.LOGGER.info("Loading config '{}.json'.", (Object)name);
        JsonObject json = JsonUtils.safeReadFromFile(Config.buildPath(Config.createConfigDir(), name), new JsonObject());
        T config = serializer.deserialize(json);
        if (serializer.isInvalid()) {
            Config.save(Config.buildPath(Config.createConfigDir(), ((Config)config).getName()), config, serializer);
        }
        return config;
    }

    static Path createConfigDir() {
        Path path = AlmostUnifiedPlatform.INSTANCE.getConfigPath();
        String property = System.getProperty(CONFIG_DIR_PROPERTY);
        if (property != null) {
            path = Path.of(property, new String[0]);
        }
        try {
            Files.createDirectories(path, new FileAttribute[0]);
        }
        catch (IOException e) {
            AlmostUnifiedCommon.LOGGER.error("Failed to create config directory.", (Throwable)e);
        }
        return path;
    }

    static <T extends Config> void save(Path path, T config, Serializer<T> serializer) {
        if (Files.exists(path, new LinkOption[0])) {
            Config.backupConfig(path);
        } else {
            AlmostUnifiedCommon.LOGGER.warn("Config '{}.json' not found. Creating default config.", (Object)config.getName());
        }
        JsonObject json = serializer.serialize(config);
        Gson gson = new GsonBuilder().setPrettyPrinting().create();
        String jsonString = gson.toJson((JsonElement)json);
        try {
            Files.writeString(path, (CharSequence)jsonString, StandardOpenOption.CREATE, StandardOpenOption.WRITE);
        }
        catch (IOException e) {
            AlmostUnifiedCommon.LOGGER.error("Failed to save config '{}'.", (Object)config.getName(), (Object)e);
        }
    }

    boolean hasMatchInPatterns(Iterable<Pattern> patterns, String toCheck) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(toCheck).matches()) continue;
            return true;
        }
        return false;
    }

    private static void backupConfig(Path path) {
        AlmostUnifiedCommon.LOGGER.warn("Config '{}' is invalid. Backing up and recreating.", (Object)path.getFileName());
        Path backupPath = path.resolveSibling(String.valueOf(path.getFileName()) + ".bak");
        try {
            Files.deleteIfExists(backupPath);
            Files.move(path, backupPath, new CopyOption[0]);
        }
        catch (IOException e) {
            AlmostUnifiedCommon.LOGGER.error("Config '{}' could not be backed up.", (Object)path.getFileName(), (Object)e);
        }
    }

    private static Path buildPath(Path path, String name) {
        return path.resolve(name + ".json");
    }

    public static abstract class Serializer<T extends Config> {
        private boolean valid;

        T deserialize(JsonObject json) {
            this.valid = true;
            return this.handleDeserialization(json);
        }

        abstract T handleDeserialization(JsonObject var1);

        abstract JsonObject serialize(T var1);

        <V> V safeGet(Supplier<V> supplier, V defaultValue) {
            try {
                return supplier.get();
            }
            catch (Exception e) {
                this.setInvalid();
                return defaultValue;
            }
        }

        void setInvalid() {
            this.valid = false;
        }

        boolean isInvalid() {
            return !this.valid;
        }

        Set<Pattern> deserializePatterns(JsonObject json, String configKey, List<String> defaultValue) {
            return this.safeGet(() -> JsonUtils.toList(json.getAsJsonArray(configKey)).stream().map(Pattern::compile).collect(Collectors.toSet()), new HashSet<Pattern>(defaultValue.stream().map(Pattern::compile).toList()));
        }

        void serializePatterns(JsonObject json, String configKey, Set<Pattern> patterns) {
            json.add(configKey, (JsonElement)JsonUtils.toArray(patterns.stream().map(Pattern::pattern).toList()));
        }
    }
}

