/*
 * Decompiled with CFR 0.152.
 */
package com.almostreliable.unified.utils;

import com.almostreliable.unified.api.unification.UnificationEntry;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import net.minecraft.class_2378;
import net.minecraft.class_2960;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_6880;
import org.jetbrains.annotations.Nullable;

public class VanillaTagWrapper<T> {
    private final class_2378<T> registry;
    private final Map<class_2960, Collection<class_6880<T>>> vanillaTags;
    @Nullable
    private Map<class_6880<T>, Set<class_2960>> holdersToTags;
    private final Set<class_2960> modifiedTags = new HashSet<class_2960>();

    public static <T> VanillaTagWrapper<T> of(class_2378<T> registry, Map<class_2960, Collection<class_6880<T>>> vanillaTags) {
        return new VanillaTagWrapper<T>(registry, vanillaTags);
    }

    public VanillaTagWrapper(class_2378<T> registry, Map<class_2960, Collection<class_6880<T>>> vanillaTags) {
        this.registry = registry;
        this.vanillaTags = vanillaTags;
    }

    public void add(class_2960 tag, class_6880<T> holder) {
        if (this.modifiedTags.contains(tag)) {
            this.vanillaTags.get(tag).add(holder);
            return;
        }
        Collection<class_6880<T>> existingHolders = this.vanillaTags.get(tag);
        HashSet<class_6880<T>> newHolders = existingHolders == null ? new HashSet<class_6880<T>>() : new HashSet<class_6880<T>>(existingHolders);
        newHolders.add(holder);
        this.vanillaTags.put(tag, newHolders);
        this.modifiedTags.add(tag);
    }

    public boolean has(class_6862<T> tag) {
        return this.vanillaTags.containsKey(tag.comp_327());
    }

    public Collection<class_6880<T>> get(class_6862<T> tag) {
        return Collections.unmodifiableCollection(this.vanillaTags.getOrDefault(tag.comp_327(), Collections.emptyList()));
    }

    public Collection<class_6880<T>> get(class_2960 tag) {
        return Collections.unmodifiableCollection(this.vanillaTags.getOrDefault(tag, Collections.emptyList()));
    }

    public Set<class_2960> getTags(class_2960 entryId) {
        class_5321 key = class_5321.method_29179((class_5321)this.registry.method_30517(), (class_2960)entryId);
        return this.registry.method_40264(key).map(this::getTags).orElse(Set.of());
    }

    public Set<class_2960> getTags(UnificationEntry<T> entry) {
        return this.getTags((class_6880<T>)entry.asHolderOrThrow());
    }

    public Set<class_2960> getTags(class_6880<T> holder) {
        if (this.holdersToTags == null) {
            this.holdersToTags = this.createInvertMap();
        }
        return this.holdersToTags.getOrDefault(holder, Set.of());
    }

    private Map<class_6880<T>, Set<class_2960>> createInvertMap() {
        HashMap<class_6880<T>, Set<class_2960>> map = new HashMap<class_6880<T>, Set<class_2960>>();
        for (Map.Entry<class_2960, Collection<class_6880<T>>> entry : this.vanillaTags.entrySet()) {
            for (class_6880<T> holder : entry.getValue()) {
                map.putIfAbsent(holder, new HashSet());
                ((Set)map.get(holder)).add(entry.getKey());
            }
        }
        return map;
    }

    public void seal() {
        for (class_2960 modifiedTag : this.modifiedTags) {
            Collection<class_6880<T>> holders = this.vanillaTags.get(modifiedTag);
            if (holders == null) continue;
            this.vanillaTags.put(modifiedTag, List.copyOf(holders));
        }
        this.modifiedTags.clear();
        this.holdersToTags = null;
    }
}

