/*
 * Decompiled with CFR 0.152.
 */
package techreborn.blockentity.machine.tier0.block.blockbreaker;

import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1802;
import net.minecraft.class_181;
import net.minecraft.class_1937;
import net.minecraft.class_2246;
import net.minecraft.class_2338;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_3218;
import net.minecraft.class_3481;
import net.minecraft.class_8567;
import reborncore.common.blockentity.RedstoneConfiguration;
import techreborn.blockentity.machine.tier0.block.BlockProcessable;
import techreborn.blockentity.machine.tier0.block.BlockProcessor;
import techreborn.blockentity.machine.tier0.block.BlockProcessorUtils;
import techreborn.blockentity.machine.tier0.block.ProcessingStatus;
import techreborn.blockentity.machine.tier0.block.blockbreaker.BlockBreakerNbt;
import techreborn.blockentity.machine.tier0.block.blockbreaker.BlockBreakerStatus;
import techreborn.init.TRContent;

public class BlockBreakerProcessor
extends BlockBreakerNbt
implements BlockProcessor {
    private final UUID processorId = UUID.randomUUID();
    private final BlockProcessable processable;
    private final int outputSlot;
    private final int fakeInputSlot;
    private final int baseBreakTime;
    private final int baseCostToBreak;

    public BlockBreakerProcessor(BlockProcessable processable, int outputSlot, int fakeInputSlot, int baseBreakTime, int baseCostToBreak) {
        this.processable = processable;
        this.outputSlot = outputSlot;
        this.fakeInputSlot = fakeInputSlot;
        this.baseBreakTime = baseBreakTime;
        this.baseCostToBreak = baseCostToBreak;
    }

    @Override
    public ProcessingStatus getStatusEnum() {
        return this.status;
    }

    @Override
    public ProcessingStatus onTick(class_1937 world, class_2338 positionInFront) {
        class_1799 fakeItem;
        class_1799 blockDrop;
        List blockDrops;
        this.handleBlockBreakingProgressReset(world, positionInFront);
        if (!this.ensureRedstoneEnabled()) {
            return this.status;
        }
        if (!this.handleInterrupted()) {
            return this.status;
        }
        class_1799 outputItemStack = this.processable.getInventory().method_5438(this.outputSlot);
        class_2680 blockInFront = world.method_8320(positionInFront);
        if (!this.handleBlockInFrontRemoved(blockInFront)) {
            return this.status;
        }
        class_1792 currentBreakingItem = this.processable.getInventory().method_5438(this.fakeInputSlot).method_7909();
        class_1799 item = blockInFront.method_26204().method_8389().method_7854();
        if (world instanceof class_3218) {
            class_3218 serverWorld = (class_3218)world;
            class_8567.class_8568 builder = new class_8567.class_8568(serverWorld).method_51874(class_181.field_24424, (Object)class_243.method_24953((class_2382)positionInFront)).method_51874(class_181.field_1229, (Object)TRContent.Machine.BLOCK_BREAKER.getStack());
            blockDrops = blockInFront.method_26189(builder);
        } else {
            blockDrops = Collections.singletonList(item);
        }
        class_1799 class_17992 = blockDrop = blockDrops.isEmpty() ? null : blockDrops.get(0);
        if (blockDrop != null) {
            blockDrop.method_7939(1);
        }
        if ((fakeItem = item.method_7972()).method_31574(class_1802.field_8162)) {
            currentBreakingItem = null;
        }
        this.processable.getInventory().method_5447(this.fakeInputSlot, fakeItem);
        float hardness = BlockProcessorUtils.getHardness(world, blockInFront, positionInFront);
        if (!this.ensureBlockCanBeBroken(blockInFront, fakeItem, hardness)) {
            return this.status;
        }
        this.breakTime = BlockProcessorUtils.getProcessTimeWithHardness(this.processable, this.baseBreakTime, hardness);
        if (!this.ensureBlockNotReplaced(currentBreakingItem, item)) {
            return this.status;
        }
        if (!this.ensureBlockFitInOutput(outputItemStack, blockDrop)) {
            return this.status;
        }
        if (!this.increaseBreakTime(world, positionInFront)) {
            return this.status;
        }
        BlockProcessorUtils.playSound(this.processable, this.currentBreakTime);
        this.breakBlock(world, positionInFront, outputItemStack, blockDrop);
        this.status = BlockBreakerStatus.PROCESSING;
        return this.status;
    }

    private boolean ensureRedstoneEnabled() {
        if (!this.processable.isActive(RedstoneConfiguration.Element.RECIPE_PROCESSING)) {
            return this.breakControlFlow(BlockBreakerStatus.IDLE_PAUSED);
        }
        return true;
    }

    private void handleBlockBreakingProgressReset(class_1937 world, class_2338 pos) {
        if (this.currentBreakTime == 0) {
            this.setBlockBreakingProgress(world, pos, -1);
        }
    }

    private boolean handleInterrupted() {
        if (this.currentBreakTime < 0) {
            ++this.currentBreakTime;
            return false;
        }
        return true;
    }

    private boolean handleBlockInFrontRemoved(class_2680 blockInFront) {
        if (blockInFront.method_27852(class_2246.field_10124)) {
            this.processable.getInventory().method_5447(this.fakeInputSlot, class_1799.field_8037);
            this.resetProcessing(0);
        }
        return true;
    }

    private boolean ensureBlockCanBeBroken(class_2680 blockInFront, class_1799 fakeItem, float hardness) {
        if (blockInFront.method_26215() || fakeItem.method_7960() || hardness < 0.0f || blockInFront.method_26164(class_3481.field_21490)) {
            return this.breakControlFlow(BlockBreakerStatus.IDLE);
        }
        return true;
    }

    private boolean ensureBlockNotReplaced(class_1792 currentBreakingItem, class_1799 item) {
        if (currentBreakingItem != null && !class_1799.field_8037.method_31574(currentBreakingItem) && !item.method_31574(currentBreakingItem)) {
            return this.breakControlFlow(BlockBreakerStatus.INTERRUPTED);
        }
        return true;
    }

    private boolean ensureBlockFitInOutput(class_1799 currentStack, class_1799 blockDrop) {
        if (blockDrop == null || blockDrop.method_7947() == 0) {
            return true;
        }
        if (!currentStack.method_31574(class_1799.field_8037.method_7909()) && !currentStack.method_31574(blockDrop.method_7909())) {
            return this.breakControlFlow(BlockBreakerStatus.OUTPUT_BLOCKED);
        }
        if (currentStack.method_7914() < currentStack.method_7947() + blockDrop.method_7947()) {
            return this.breakControlFlow(BlockBreakerStatus.OUTPUT_FULL);
        }
        return true;
    }

    private boolean increaseBreakTime(class_1937 world, class_2338 blockPos) {
        if (!this.processable.consumeEnergy(this.baseCostToBreak)) {
            return this.breakControlFlow(BlockBreakerStatus.NO_ENERGY);
        }
        this.setBlockBreakingProgress(world, blockPos);
        ++this.currentBreakTime;
        return true;
    }

    private void breakBlock(class_1937 world, class_2338 positionInFront, class_1799 currentStack, class_1799 blockDrop) {
        if (this.currentBreakTime >= this.breakTime) {
            world.method_22352(positionInFront, false);
            this.resetProcessing(0);
            if (blockDrop == null || blockDrop.method_7947() == 0) {
                return;
            }
            if (currentStack.method_31574(class_1799.field_8037.method_7909())) {
                this.processable.getInventory().method_5447(this.outputSlot, blockDrop);
            } else {
                int currentCount = currentStack.method_7947();
                currentStack.method_7939(currentCount + blockDrop.method_7947());
            }
        }
    }

    private void resetProcessing(int tick) {
        this.currentBreakTime = tick;
        this.breakTime = this.baseBreakTime;
    }

    private void setBlockBreakingProgress(class_1937 world, class_2338 blockPos) {
        this.setBlockBreakingProgress(world, blockPos, this.getProgress() / 10);
    }

    private void setBlockBreakingProgress(class_1937 world, class_2338 blockPos, int breakingProgress) {
        world.method_8517(this.processorId.hashCode(), blockPos, breakingProgress);
    }

    @Override
    public int getCurrentTickTime() {
        return this.getCurrentBreakTime();
    }

    @Override
    public int getTickTime() {
        return this.getBreakTime();
    }

    private boolean breakControlFlow(ProcessingStatus status) {
        this.resetProcessing(-20);
        this.status = status;
        return false;
    }
}

