/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.data;

import io.wispforest.owo.network.ClientAccess;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.fabricmc.fabric.api.networking.v1.ServerPlayConnectionEvents;
import net.fabricmc.fabric.api.resource.IdentifiableResourceReloadListener;
import net.minecraft.class_1657;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3300;
import net.minecraft.class_3503;
import net.minecraft.class_3695;
import net.minecraft.class_4080;
import net.minecraft.class_6860;
import net.minecraft.class_8786;
import net.minecraft.server.MinecraftServer;
import wraith.alloyforgery.AlloyForgery;
import wraith.alloyforgery.data.DelayedTagGroupLoader;

public class RecipeTagLoader
extends class_4080<Map<class_2960, List<class_3503.class_5145>>>
implements IdentifiableResourceReloadListener,
ServerLifecycleEvents.ServerStarted,
ServerLifecycleEvents.EndDataPackReload {
    private static final Map<class_2960, Set<class_2960>> RESOLVED_ENTRIES = new HashMap<class_2960, Set<class_2960>>();
    private static final Map<class_2960, List<class_3503.class_5145>> RAW_TAG_DATA = new HashMap<class_2960, List<class_3503.class_5145>>();
    private final DelayedTagGroupLoader<class_8786<class_1860<?>>> tagGroupLoader = new DelayedTagGroupLoader("tags/recipe");

    protected Map<class_2960, List<class_3503.class_5145>> prepare(class_3300 manager, class_3695 profiler) {
        return this.tagGroupLoader.method_33174(manager);
    }

    protected void apply(Map<class_2960, List<class_3503.class_5145>> prepared, class_3300 manager, class_3695 profiler) {
        RAW_TAG_DATA.clear();
        RAW_TAG_DATA.putAll(prepared);
    }

    public class_2960 getFabricId() {
        return AlloyForgery.id("recipe_tag");
    }

    public static boolean isWithinTag(class_2960 tag, class_8786<?> entry) {
        return RecipeTagLoader.isWithinTag(tag, entry.comp_1932());
    }

    public static boolean isWithinTag(class_2960 tag, class_2960 recipeID) {
        if (!RESOLVED_ENTRIES.containsKey(tag)) {
            return false;
        }
        return RESOLVED_ENTRIES.get(tag).contains(recipeID);
    }

    public void initEvents() {
        ServerLifecycleEvents.END_DATA_PACK_RELOAD.register((Object)this);
        ServerLifecycleEvents.SERVER_STARTED.register((Object)this);
        ServerPlayConnectionEvents.JOIN.register((handler, sender, server) -> AlloyForgery.CHANNEL.serverHandle((class_1657)handler.field_14140).send((Record)TagPacket.of(RESOLVED_ENTRIES)));
    }

    public void endDataPackReload(MinecraftServer server, class_6860 resourceManager, boolean success) {
        if (!success) {
            return;
        }
        this.resolveEntries(server);
        AlloyForgery.CHANNEL.serverHandle(server).send((Record)TagPacket.of(RESOLVED_ENTRIES));
    }

    public void onServerStarted(MinecraftServer server) {
        this.resolveEntries(server);
    }

    public void resolveEntries(MinecraftServer server) {
        class_1863 recipeManager = server.method_3772();
        Map map = this.tagGroupLoader.setGetter(identifier -> Optional.ofNullable(recipeManager.method_8130(identifier).orElse(null))).method_18242(RAW_TAG_DATA);
        RESOLVED_ENTRIES.clear();
        map.forEach((id, recipes) -> RESOLVED_ENTRIES.put((class_2960)id, recipes.stream().map(class_8786::comp_1932).collect(Collectors.toSet())));
    }

    public record TagPacket(List<TagEntry> entries) {
        public static TagPacket of(Map<class_2960, Set<class_2960>> tagEntries) {
            return new TagPacket(tagEntries.entrySet().stream().map(entry -> new TagEntry((class_2960)entry.getKey(), List.copyOf((Collection)entry.getValue()))).toList());
        }

        public static void handlePacket(TagPacket packet, ClientAccess access) {
            RESOLVED_ENTRIES.clear();
            RESOLVED_ENTRIES.putAll(packet.entries.stream().collect(Collectors.toMap(TagEntry::id, e -> new HashSet<class_2960>(e.entries()))));
        }
    }

    public record TagEntry(class_2960 id, List<class_2960> entries) {
    }
}

