/*
 * Decompiled with CFR 0.152.
 */
package wraith.alloyforgery.recipe;

import com.google.common.collect.ImmutableMap;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonElement;
import io.wispforest.endec.format.gson.GsonDeserializer;
import java.util.Base64;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1856;
import net.minecraft.class_1860;
import net.minecraft.class_1863;
import net.minecraft.class_2960;
import net.minecraft.class_3859;
import net.minecraft.class_3956;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8786;
import wraith.alloyforgery.AlloyForgery;
import wraith.alloyforgery.data.RecipeTagLoader;
import wraith.alloyforgery.recipe.AlloyForgeRecipe;
import wraith.alloyforgery.recipe.AlloyForgeRecipeSerializer;
import wraith.alloyforgery.utils.RecipeInjector;

public class BlastFurnaceRecipeAdapter
implements RecipeInjector.AddRecipes {
    private static final Gson GSON = new GsonBuilder().setLenient().create();
    private static final class_6862<class_1792> DUSTS_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)class_2960.method_60655((String)"c", (String)"dusts"));
    public static final class_2960 BLACKLISTED_BLASTING_RECIPES = AlloyForgery.id("blacklisted_blasting_recipes");
    public static final class_2960 BLACKLISTED_INCREASED_OUTPUT = AlloyForgery.id("blacklisted_increased_blasting_outputs");
    private static final String ExtraRecipe = "ewogICJfY29tbWVudCI6ICJUaGlzIHJlY2lwZSBpcyBmb3IgYSBmcmllbmQgYW5kIGNvbnRhaW5zIG5vdGhpbmcgbWFsaWNpb3VzIHVubGVzcyBidXJudCBtZWF0IGlzIHNhZCBmb3IgeW91LiIsCiAgInR5cGUiOiAiYWxsb3lfZm9yZ2VyeTpmb3JnaW5nIiwKICAiaW5wdXRzIjogWwogICAgewogICAgICAidGFnIjogIm1pbmVjcmFmdDptZWF0IiwKICAgICAgImNvdW50IjogNAogICAgfQogIF0sCiAgIm91dHB1dCI6IHsKICAgICJpdGVtIjogIm1pbmVjcmFmdDpjaGFyY29hbCIsCiAgICAiY291bnQiOiAxLAogICAgImNvbXBvbmVudHMiOiB7CiAgICAgICJjdXN0b21fbmFtZSI6ICJbe1widGV4dFwiOlwiQ29va2VkXCIsXCJpdGFsaWNcIjp0cnVlfSwgXCIgXCIsIHtcInRleHRcIjpcIlN0ZWFrXCIsXCJjbGlja0V2ZW50XCI6e1wiYWN0aW9uXCI6XCJvcGVuX3VybFwiLFwidmFsdWVcIjpcImh0dHBzOi8vd3d3LnlvdXR1YmUuY29tL3dhdGNoP3Y9ZFF3NHc5V2dYY1FcIn0sXCJzdHJpa2V0aHJvdWdoXCI6dHJ1ZX1dIgogICAgfQogIH0sCiAgIm92ZXJyaWRlcyI6IHsKICAgICIzIjogewogICAgICAiaXRlbSI6ICJtaW5lY3JhZnQ6Y2hhcmNvYWwiLAogICAgICAiY291bnQiOiAyLAogICAgICAiY29tcG9uZW50cyI6IHsKICAgICAgICAiY3VzdG9tX25hbWUiOiAiW3tcInRleHRcIjpcIkNvb2tlZFwiLFwiaXRhbGljXCI6dHJ1ZX0sIFwiIFwiLCB7XCJ0ZXh0XCI6XCJTdGVha1wiLFwiY2xpY2tFdmVudFwiOntcImFjdGlvblwiOlwib3Blbl91cmxcIixcInZhbHVlXCI6XCJodHRwczovL3d3dy55b3V0dWJlLmNvbS93YXRjaD92PWRRdzR3OVdnWGNRXCJ9LFwic3RyaWtldGhyb3VnaFwiOnRydWV9XSIKICAgICAgfQogICAgfSwKICAgICI0IjogewogICAgICAiaXRlbSI6ICJtaW5lY3JhZnQ6cG9pc29ub3VzX3BvdGF0byIsCiAgICAgICJjb3VudCI6IDEsCiAgICAgICJjb21wb25lbnRzIjogewogICAgICAgICJjdXN0b21fbmFtZSI6ICJbXCJvz4lvLCBob3cgZGlkIHRoaXMgaGFwcGVuP1wiXSIKICAgICAgfQogICAgfQogIH0sCiAgIm1pbl9mb3JnZV90aWVyIjogMiwKICAiZnVlbF9wZXJfdGljayI6IDIwCn0=";

    @Override
    public void addRecipes(RecipeInjector instance) {
        if (!AlloyForgery.CONFIG.allowBlastingFurnaceAdaption()) {
            return;
        }
        class_1863 manager = instance.manager();
        List alloyForgeryRecipes = manager.method_30027((class_3956)AlloyForgeRecipe.Type.INSTANCE);
        for (class_8786 recipeEntry : manager.method_30027(class_3956.field_17547)) {
            class_3859 recipe = (class_3859)recipeEntry.comp_1933();
            if (!BlastFurnaceRecipeAdapter.isUniqueRecipe(alloyForgeryRecipes, recipe) || RecipeTagLoader.isWithinTag(BLACKLISTED_BLASTING_RECIPES, recipeEntry)) continue;
            class_2960 secondaryID = recipeEntry.comp_1932();
            String path = secondaryID.method_12832();
            if (path.contains("blasting")) {
                path = path.replace("blasting", "forging");
            }
            class_1799 mainOutput = recipe.method_8110(null).method_7972();
            mainOutput.method_7939(AlloyForgery.CONFIG.baseInputAmount());
            ImmutableMap.Builder extraOutput = ImmutableMap.builder();
            if (AlloyForgery.CONFIG.allowHigherTierOutput() && !RecipeTagLoader.isWithinTag(BLACKLISTED_INCREASED_OUTPUT, recipeEntry) && !BlastFurnaceRecipeAdapter.isDustRecipe((class_8786<class_3859>)recipeEntry)) {
                class_1799 increasedOutput = mainOutput.method_7972();
                increasedOutput.method_7933(AlloyForgery.CONFIG.higherTierOutputIncrease());
                extraOutput.put((Object)new AlloyForgeRecipe.OverrideRange(3), (Object)increasedOutput);
            }
            class_2960 recipeId = AlloyForgery.id(path);
            AlloyForgeRecipe convertRecipe = new AlloyForgeRecipe(Map.of((class_1856)recipe.method_8117().get(0), AlloyForgery.CONFIG.baseInputAmount()), mainOutput, 1, Math.round(BlastFurnaceRecipeAdapter.getFuelPerTick(recipe)), (Map<AlloyForgeRecipe.OverrideRange, class_1799>)extraOutput.build(), Optional.of(secondaryID));
            instance.addRecipe(recipeId, convertRecipe);
        }
        instance.addRecipe(AlloyForgery.id("super_duper_fun_recipe"), (AlloyForgeRecipe)AlloyForgeRecipeSerializer.RECIPE_ENDEC.decodeFully(GsonDeserializer::of, (Object)((JsonElement)GSON.fromJson(new String(Base64.getDecoder().decode(ExtraRecipe)), JsonElement.class))));
    }

    private static float getFuelPerTick(class_3859 recipe) {
        return (float)recipe.method_8167() / 200.0f * 10.0f;
    }

    private static boolean isUniqueRecipe(List<class_8786<AlloyForgeRecipe>> alloyForgeryRecipes, class_1860<?> blastRecipe) {
        class_1799[] stacks = ((class_1856)blastRecipe.method_8117().get(0)).method_8105();
        List<class_8786> matchedRecipes = alloyForgeryRecipes.stream().filter(recipeEntry -> {
            AlloyForgeRecipe recipe = (AlloyForgeRecipe)recipeEntry.comp_1933();
            if (recipe.getIngredientsMap().size() > 1) {
                return false;
            }
            for (class_1799 stack : stacks) {
                if (!((class_1856)recipe.method_8117().get(0)).method_8093(stack)) continue;
                return true;
            }
            return false;
        }).toList();
        return matchedRecipes.isEmpty();
    }

    private static boolean isDustRecipe(class_8786<class_3859> blastingRecipeEntry) {
        if (blastingRecipeEntry.comp_1932().method_12832().contains("dust")) {
            return true;
        }
        class_3859 blastRecipe = (class_3859)blastingRecipeEntry.comp_1933();
        class_1856 inputIngredient = (class_1856)blastRecipe.method_8117().get(0);
        for (class_1799 stack : inputIngredient.method_8105()) {
            if (stack.method_31573(DUSTS_TAG)) {
                return true;
            }
            class_2960 id = class_7923.field_41178.method_10221((Object)stack.method_7909());
            if (!id.method_12832().contains("dust")) continue;
            return true;
        }
        return false;
    }
}

