/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_2960;
import net.minecraft.class_7923;
import net.xalcon.torchmaster.Torchmaster;

public class EntityFilterList {
    private final class_2960 filterListId;
    private final Set<class_2960> list = new HashSet<class_2960>();
    private static final Pattern FILTER_PATTERN = Pattern.compile("[+-][a-z0-9_-]+:[a-z0-9_-]+");

    public EntityFilterList(class_2960 identifier) {
        this.filterListId = identifier;
    }

    public boolean containsEntity(class_2960 entityName) {
        return this.list.contains(entityName);
    }

    public void registerEntity(class_2960 entityName) {
        this.list.add(entityName);
    }

    public static boolean IsValidFilterString(Object object) {
        String filterString;
        return object instanceof String && FILTER_PATTERN.matcher(filterString = (String)object).matches();
    }

    public void applyListOverrides(List<String> overrides) {
        block4: for (String override : overrides) {
            if (override.length() < 4) {
                Torchmaster.LOG.warn("[{}] Invalid filter definition '{}'", (Object)this.filterListId, (Object)override);
                continue;
            }
            char prefix = override.charAt(0);
            class_2960 rl = class_2960.method_60654((String)override.substring(1));
            switch (prefix) {
                case '+': {
                    if (this.containsEntity(rl)) continue block4;
                    if (!class_7923.field_41177.method_10250(rl)) {
                        Torchmaster.LOG.warn("[{}] The entity '{}' does not exist, skipping", (Object)this.filterListId, (Object)rl);
                        continue block4;
                    }
                    this.registerEntity(rl);
                    Torchmaster.LOG.info("[{}] Added '{}' to the block list", (Object)this.filterListId, (Object)rl);
                    continue block4;
                }
                case '-': {
                    if (!this.list.removeIf(rrl -> rrl.equals((Object)rl))) continue block4;
                    Torchmaster.LOG.info("[{}] Removed '{}' from the block list", (Object)this.filterListId, (Object)rl);
                    continue block4;
                }
            }
            Torchmaster.LOG.warn("[{}] Invalid block list prefix: '{}', only + and - are valid prefixes", (Object)this.filterListId, (Object)Character.valueOf(prefix));
        }
    }

    public class_2960[] getEntities() {
        return this.list.toArray(new class_2960[0]);
    }

    public void clear() {
        this.list.clear();
    }
}

