/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.blocks;

import java.util.ArrayList;
import java.util.List;
import net.minecraft.class_1937;
import net.minecraft.class_1944;
import net.minecraft.class_2338;
import net.minecraft.class_239;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2495;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_3726;
import net.minecraft.class_3959;
import net.minecraft.class_3965;
import net.minecraft.class_7225;
import net.xalcon.torchmaster.ModRegistry;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.config.ITorchmasterConfig;
import net.xalcon.torchmaster.platform.Services;

public class FeralFlareLanternBlockEntity
extends class_2586 {
    private int ticks;
    private boolean useLineOfSight;
    private List<class_2338> childLights = new ArrayList<class_2338>();

    public FeralFlareLanternBlockEntity(class_2338 pos, class_2680 state) {
        super(ModRegistry.tileFeralFlareLantern.get(), pos, state);
    }

    public void tick() {
        ITorchmasterConfig config = Services.PLATFORM.getConfig();
        if (this.field_11863.field_9236 || ++this.ticks % config.getFeralFlareTickRate() != 0) {
            return;
        }
        if (this.childLights.size() > config.getFeralFlareLanternLightCountHardcap()) {
            return;
        }
        this.ticks = 0;
        int radius = config.getFeralFlareRadius();
        int diameter = radius * 2;
        int x = radius - this.field_11863.field_9229.method_43048(diameter) + this.field_11867.method_10263();
        int y = radius - this.field_11863.field_9229.method_43048(diameter) + this.field_11867.method_10264();
        int z = radius - this.field_11863.field_9229.method_43048(diameter) + this.field_11867.method_10260();
        class_2338 targetPos = new class_2338(x, y, z);
        int surfaceHeight = this.field_11863.method_8624(class_2902.class_2903.field_13202, targetPos.method_10263(), targetPos.method_10260());
        if (targetPos.method_10264() > surfaceHeight + 4) {
            targetPos = targetPos.method_33096(surfaceHeight).method_10086(4);
        }
        int worldHeightCap = this.field_11863.method_31605();
        if (targetPos.method_10264() > worldHeightCap) {
            targetPos = new class_2338(targetPos.method_10263(), worldHeightCap - 1, targetPos.method_10260());
        }
        if (!this.field_11863.method_8477(targetPos)) {
            return;
        }
        if (this.field_11863.method_22347(targetPos) && this.field_11863.method_8314(class_1944.field_9282, targetPos) < config.getFeralFlareMinLightLevel()) {
            class_2338 hitPos;
            class_243 end;
            class_243 start;
            class_3959 rtxCtx;
            class_3965 rtResult;
            if (this.useLineOfSight && (rtResult = this.field_11863.method_17742(rtxCtx = new class_3959(start = new class_243((double)targetPos.method_10263(), (double)targetPos.method_10264(), (double)targetPos.method_10260()).method_1031(0.5, 0.5, 0.5), end = new class_243((double)this.field_11867.method_10263(), (double)this.field_11867.method_10264(), (double)this.field_11867.method_10260()).method_1031(0.5, 0.5, 0.5), class_3959.class_3960.field_17558, class_3959.class_242.field_1347, class_3726.method_16194()))).method_17783() == class_239.class_240.field_1332 && ((hitPos = rtResult.method_17777()).method_10263() != this.field_11867.method_10263() || hitPos.method_10264() != this.field_11867.method_10264() || hitPos.method_10260() != this.field_11867.method_10260())) {
                return;
            }
            if (this.field_11863.method_8652(targetPos, ModRegistry.blockInvisibleLight.get().method_9564(), 3)) {
                this.childLights.add(targetPos);
                this.method_5431();
            }
        }
    }

    public static <T extends class_2586> void dispatchTickBlockEntity(class_1937 level, class_2338 pos, class_2680 state, T blockEntity) {
        if (blockEntity instanceof FeralFlareLanternBlockEntity) {
            ((FeralFlareLanternBlockEntity)blockEntity).tick();
        }
    }

    protected void method_11007(class_2487 nbt, class_7225.class_7874 pRegistries) {
        super.method_11007(nbt, pRegistries);
        ArrayList<Integer> childLightsEncoded = new ArrayList<Integer>(this.childLights.size());
        for (class_2338 child : this.childLights) {
            childLightsEncoded.add(FeralFlareLanternBlockEntity.encodePosition(this.field_11867, child));
        }
        nbt.method_10566("lights", (class_2520)new class_2495(childLightsEncoded));
        nbt.method_10569("ticks", this.ticks);
        nbt.method_10556("useLoS", this.useLineOfSight);
    }

    public void method_11014(class_2487 nbt, class_7225.class_7874 pRegistries) {
        this.childLights.clear();
        if (nbt.method_10540("lights") == 11) {
            int[] lightsEncoded;
            class_2338 origin = new class_2338(nbt.method_10550("x"), nbt.method_10550("y"), nbt.method_10550("z"));
            for (int encodedLight : lightsEncoded = ((class_2495)nbt.method_10580("lights")).method_10588()) {
                this.childLights.add(FeralFlareLanternBlockEntity.decodePosition(origin, encodedLight));
            }
        }
        this.ticks = nbt.method_10550("ticks");
        this.useLineOfSight = nbt.method_10577("useLoS");
        super.method_11014(nbt, pRegistries);
    }

    public void setUseLineOfSight(boolean state) {
        Torchmaster.LOG.info("Current: {}, New: {}", (Object)this.useLineOfSight, (Object)state);
        this.useLineOfSight = state;
        this.method_5431();
        class_2680 blockState = this.field_11863.method_8320(this.field_11867);
        this.field_11863.method_8413(this.field_11867, blockState, blockState, 3);
    }

    public boolean shouldUseLineOfSight() {
        return this.useLineOfSight;
    }

    public void removeChildLights() {
        if (this.field_11863.field_9236) {
            return;
        }
        for (class_2338 pos : this.childLights) {
            if (this.field_11863.method_8320(pos).method_26204() != ModRegistry.blockInvisibleLight.get()) continue;
            this.field_11863.method_8650(pos, false);
        }
        this.childLights.clear();
    }

    private static int encodePosition(class_2338 origin, class_2338 target) {
        int x = target.method_10263() - origin.method_10263();
        int y = target.method_10264() - origin.method_10264();
        int z = target.method_10260() - origin.method_10260();
        return ((x & 0xFF) << 16) + ((y & 0xFF) << 8) + (z & 0xFF);
    }

    private static class_2338 decodePosition(class_2338 origin, int pos) {
        byte x = (byte)(pos >> 16 & 0xFF);
        byte y = (byte)(pos >> 8 & 0xFF);
        byte z = (byte)(pos & 0xFF);
        return origin.method_10069((int)x, (int)y, (int)z);
    }
}

