/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.commands;

import com.mojang.brigadier.CommandDispatcher;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import java.lang.reflect.Field;
import java.util.List;
import net.minecraft.class_1419;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_5304;
import net.minecraft.class_7922;
import net.minecraft.class_7923;
import net.minecraft.server.MinecraftServer;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.logic.entityblocking.TorchInfo;

public class CommandTorchmaster {
    public static void register(CommandDispatcher<class_2168> dispatcher) {
        LiteralArgumentBuilder command = class_2170.method_9247((String)"torchmaster");
        for (SubCommands subCommand : SubCommands.values()) {
            command.then(class_2170.method_9247((String)subCommand.getTranslationKey()).executes(subCommand::execute));
        }
        dispatcher.register((LiteralArgumentBuilder)((LiteralArgumentBuilder)command.requires(cmdSrc -> cmdSrc.method_9259(2))).executes(ctx -> 0));
    }

    public static enum SubCommands {
        DUMP_TORCHES("torchdump"){

            @Override
            public int execute(CommandContext<class_2168> ctx) {
                class_2168 source = (class_2168)ctx.getSource();
                MinecraftServer server = source.method_9211();
                Torchmaster.LOG.info("#################################");
                Torchmaster.LOG.info("# Torchmaster Torch Dump Start  #");
                Torchmaster.LOG.info("#################################");
                for (class_3218 level : server.method_3738()) {
                    Torchmaster.getRegistryForLevel((class_1937)level).ifPresent(container -> {
                        Torchmaster.LOG.info("Torches in dimension {}:", (Object)level.method_27983().method_41185());
                        for (TorchInfo torch : container.getEntries()) {
                            Torchmaster.LOG.info("  {} @ {}", (Object)torch.getName(), (Object)torch.getPos());
                        }
                    });
                }
                Torchmaster.LOG.info("#################################");
                Torchmaster.LOG.info("# Torchmaster Torch Dump End    #");
                Torchmaster.LOG.info("#################################");
                source.method_9226(() -> class_2561.method_43471((String)"torchmaster.command.torch_dump.completed"), false);
                return 0;
            }
        }
        ,
        DUMP_ENTITIES("entitydump"){

            @Override
            public int execute(CommandContext<class_2168> ctx) {
                class_2168 source = (class_2168)ctx.getSource();
                Torchmaster.LOG.info("#################################");
                Torchmaster.LOG.info("# Torchmaster Entity Dump Start #");
                Torchmaster.LOG.info("#################################");
                Torchmaster.LOG.info("List of registered entities:");
                class_7923.field_41177.method_10220().map(arg_0 -> ((class_7922)class_7923.field_41177).method_10221(arg_0)).forEach(loc -> Torchmaster.LOG.info("  {}", loc));
                Torchmaster.LOG.info("Dread Lamp Registry Content:");
                for (class_2960 loc2 : Torchmaster.DreadLampFilterRegistry.getEntities()) {
                    Torchmaster.LOG.info("  {}", (Object)loc2);
                }
                Torchmaster.LOG.info("Mega Torch Registry Content:");
                for (class_2960 loc2 : Torchmaster.MegaTorchFilterRegistry.getEntities()) {
                    Torchmaster.LOG.info("  {}", (Object)loc2);
                }
                Torchmaster.LOG.info("#################################");
                Torchmaster.LOG.info("# Torchmaster Entity Dump End   #");
                Torchmaster.LOG.info("#################################");
                source.method_9226(() -> class_2561.method_43471((String)"torchmaster.command.entity_dump.completed"), false);
                return 0;
            }
        }
        ,
        TRY_SETUP_SIEGE("try_setup_siege"){

            @Override
            public int execute(CommandContext<class_2168> ctx) {
                class_3218 level = ((class_2168)ctx.getSource()).method_9225();
                try {
                    Field field = class_3218.class.getDeclaredField("customSpawners");
                    field.setAccessible(true);
                    List customSpawnersList = (List)field.get(level);
                    for (class_5304 customSpawner : customSpawnersList) {
                        if (!(customSpawner instanceof class_1419)) continue;
                        class_1419 siege = (class_1419)customSpawner;
                        Field siegeStateField = class_1419.class.getDeclaredField("siegeState");
                        siegeStateField.setAccessible(true);
                        siegeStateField.set(siege, siegeStateField.getType().getEnumConstants()[1]);
                        Field hasSetupSiegeField = class_1419.class.getDeclaredField("hasSetupSiege");
                        hasSetupSiegeField.setAccessible(true);
                        hasSetupSiegeField.setBoolean(siege, false);
                        ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Attempting village siege"));
                    }
                }
                catch (Exception ex) {
                    ((class_2168)ctx.getSource()).method_45068((class_2561)class_2561.method_43470((String)"Exception during siege setup"));
                    Torchmaster.LOG.error("Error while setting up siege", (Throwable)ex);
                }
                return 0;
            }
        };

        private final String translationKey;

        private SubCommands(String translationKey) {
            this.translationKey = translationKey;
        }

        public abstract int execute(CommandContext<class_2168> var1);

        public String getTranslationKey() {
            return this.translationKey;
        }
    }
}

