/*
 * Decompiled with CFR 0.152.
 */
package net.xalcon.torchmaster.logic;

import java.util.HashMap;
import java.util.Map;
import net.minecraft.class_1297;
import net.minecraft.class_18;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2520;
import net.minecraft.class_3730;
import net.minecraft.class_7225;
import net.xalcon.torchmaster.Torchmaster;
import net.xalcon.torchmaster.logic.EntityBlocker;
import net.xalcon.torchmaster.logic.EntityBlockerSerializerRegistry;

public class EntityBlockingManager
extends class_18 {
    private final Map<String, EntityBlocker> entityBlockers = new HashMap<String, EntityBlocker>();
    public static final class_18.class_8645<EntityBlockingManager> Factory = new class_18.class_8645(EntityBlockingManager::new, EntityBlockingManager::load, null);

    public void registerBlocker(EntityBlocker blocker) {
        this.entityBlockers.putIfAbsent(blocker.getIdentifier(), blocker);
        this.method_80();
    }

    public void unregisterBlocker(EntityBlocker blocker) {
        this.entityBlockers.remove(blocker.getIdentifier());
        this.method_80();
    }

    public boolean shouldBlockEntitySpawn(class_1297 entity, class_1937 level, class_3730 spawnType) {
        for (EntityBlocker blocker : this.entityBlockers.values()) {
            if (!blocker.shouldBlockEntitySpawn(entity, level, spawnType)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldBlockVillageSiege(class_1937 level, class_2338 pos) {
        for (EntityBlocker blocker : this.entityBlockers.values()) {
            if (!blocker.shouldBlockVillageSiege(level, pos)) continue;
            return true;
        }
        return false;
    }

    public boolean shouldBlockVillageRaid(class_1937 level, class_2338 pos) {
        for (EntityBlocker blocker : this.entityBlockers.values()) {
            if (!blocker.shouldBlockVillageRaid(level, pos)) continue;
            return true;
        }
        return false;
    }

    public class_2487 save() {
        class_2499 list = new class_2499();
        for (EntityBlocker blocker : this.entityBlockers.values()) {
            class_2487 tag = EntityBlockerSerializerRegistry.Serialize(blocker);
            if (tag == null) {
                Torchmaster.LOG.error("Unable to save entity blocker {}, data is lost", (Object)blocker);
                continue;
            }
            list.add((Object)tag);
        }
        class_2487 tag = new class_2487();
        tag.method_10566("blockers", (class_2520)list);
        return tag;
    }

    public void loadFrom(class_2487 tag) {
        this.entityBlockers.clear();
        class_2499 list = tag.method_10554("blockers", 10);
        for (int i = 0; i < list.size(); ++i) {
            EntityBlocker blocker = EntityBlockerSerializerRegistry.Deserialize(list.method_10602(i));
            if (blocker == null) {
                Torchmaster.LOG.error("Unable to load entity blocker from nbt, data is lost");
                continue;
            }
            this.entityBlockers.put(blocker.getIdentifier(), blocker);
        }
        this.method_80();
    }

    public class_2487 method_75(class_2487 compoundTag, class_7225.class_7874 provider) {
        compoundTag.method_10566("registry", (class_2520)this.save());
        return compoundTag;
    }

    public static EntityBlockingManager load(class_2487 tag, class_7225.class_7874 provider) {
        class_2487 registryTag = tag.method_10562("registry");
        EntityBlockingManager mgr = new EntityBlockingManager();
        mgr.loadFrom(registryTag);
        return mgr;
    }
}

