/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity;

import immersive_aircraft.config.Config;
import immersive_aircraft.entity.EngineVehicle;
import immersive_aircraft.entity.misc.Trail;
import immersive_aircraft.entity.misc.TrailDescriptor;
import immersive_aircraft.item.upgrade.VehicleStat;
import immersive_aircraft.util.Utils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_1299;
import net.minecraft.class_1937;
import net.minecraft.class_243;
import net.minecraft.class_7833;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Quaternionfc;
import org.joml.Vector3f;
import org.joml.Vector4f;

public abstract class AircraftEntity
extends EngineVehicle {
    protected double lastY;
    public float inWaterLevel;
    private List<Trail> trails = Collections.emptyList();

    public AircraftEntity(class_1299<? extends AircraftEntity> entityType, class_1937 world, boolean canExplodeOnCrash) {
        super((class_1299<? extends EngineVehicle>)entityType, world, canExplodeOnCrash);
    }

    public List<Trail> getTrails() {
        if (this.getVehicleData().getTrails().size() != this.trails.size()) {
            this.trails = new ArrayList<Trail>(this.getVehicleData().getTrails().size());
            for (TrailDescriptor trail : this.getVehicleData().getTrails()) {
                this.trails.add(new Trail(trail.length(), trail.gray()));
            }
        }
        return this.trails;
    }

    protected float getBaseTrailWidth(Matrix4f transform, int index, TrailDescriptor trail) {
        return 1.0f;
    }

    private void recordTrail(Matrix4f transform, int index, TrailDescriptor trail) {
        Matrix4f t = new Matrix4f((Matrix4fc)transform);
        t.translate(trail.x(), trail.y(), trail.z());
        if ((double)trail.rotate() != 0.0) {
            t.rotate((Quaternionfc)class_7833.field_40718.rotationDegrees(this.engineRotation.getSmooth() * trail.rotate()));
        }
        Vector4f p0 = this.mulXVec((Matrix4fc)t, -trail.size());
        Vector4f p1 = this.mulXVec((Matrix4fc)t, trail.size());
        float trailStrength = Math.max(0.0f, Math.min(1.0f, this.getBaseTrailWidth(t, index, trail)));
        this.getTrails().get(index).add(p0, p1, trailStrength);
    }

    private Vector4f mulXVec(Matrix4fc mat, float x) {
        return new Vector4f(Math.fma(mat.m00(), x, mat.m30()), Math.fma(mat.m01(), x, mat.m31()), Math.fma(mat.m02(), x, mat.m32()), Math.fma(mat.m03(), x, mat.m33()));
    }

    @Override
    public void method_5773() {
        List<TrailDescriptor> trailDescriptors;
        this.prevRoll = this.roll;
        if (this.method_24828()) {
            this.setZRot(this.roll * 0.9f);
        } else {
            this.setZRot(-this.pressingInterpolatedX.getSmooth() * this.getProperties().get(VehicleStat.ROLL_FACTOR) * (1.0f - this.inWaterLevel));
        }
        if (Double.isNaN(this.method_18798().field_1352) || Double.isNaN(this.method_18798().field_1351) || Double.isNaN(this.method_18798().field_1350)) {
            this.method_18800(0.0, 0.0, 0.0);
        }
        if (!(trailDescriptors = this.getVehicleData().getTrails()).isEmpty()) {
            Matrix4f vehicleTransform = this.getVehicleTransform();
            for (int i = 0; i < trailDescriptors.size(); ++i) {
                TrailDescriptor trail = trailDescriptors.get(i);
                this.recordTrail(vehicleTransform, i, trail);
            }
        }
        this.inWaterLevel = this.field_5957 ? Math.min(1.0f, this.inWaterLevel + 0.05f) : Math.max(0.0f, this.inWaterLevel - 0.05f);
        super.method_5773();
    }

    protected void convertPower(class_243 direction) {
        class_243 velocity = this.method_18798();
        double drag = Math.abs(direction.method_1026(velocity.method_1029()));
        this.method_18799(velocity.method_1029().method_35590(direction, (double)this.getProperties().get(VehicleStat.LIFT)).method_1021(velocity.method_1033() * (drag * (double)this.getProperties().get(VehicleStat.FRICTION) + (1.0 - (double)this.getProperties().get(VehicleStat.FRICTION)))));
    }

    @Override
    protected float getGroundDecay() {
        float gravity = Math.min(1.0f, Math.max(0.0f, (float)this.method_56989() / -0.04f));
        float upgrade = Math.min(1.0f, this.getProperties().get(VehicleStat.ACCELERATION) * 0.5f);
        return (super.getGroundDecay() * gravity + (1.0f - gravity)) * (1.0f - upgrade) + upgrade;
    }

    @Override
    protected void updateController() {
        this.method_36456(this.method_36454() - this.getProperties().get(VehicleStat.YAW_SPEED) * this.pressingInterpolatedX.getSmooth());
        if (!this.method_24828()) {
            this.method_36457(this.method_36455() + this.getProperties().get(VehicleStat.PITCH_SPEED) * this.pressingInterpolatedZ.getSmooth());
        }
        this.method_36457(this.method_36455() * (1.0f - this.getProperties().getAdditive(VehicleStat.STABILIZER)));
    }

    @Override
    protected void updateVelocity() {
        Vector3f direction = this.getForwardDirection();
        float diff = (float)(this.lastY - this.method_23318());
        if (this.lastY != 0.0 && this.getProperties().get(VehicleStat.GLIDE_FACTOR) > 0.0f && (double)diff != 0.0) {
            this.method_18799(this.method_18798().method_1019(this.toVec3d(direction).method_1021((double)(diff * this.getProperties().get(VehicleStat.GLIDE_FACTOR) * (1.0f - Math.abs(direction.y))))));
        }
        this.lastY = (float)this.method_23318();
        this.convertPower(this.toVec3d(direction));
        this.applyFriction();
        if (this.method_24828()) {
            this.method_36457((this.method_36455() + this.getProperties().get(VehicleStat.GROUND_PITCH)) * 0.9f - this.getProperties().get(VehicleStat.GROUND_PITCH));
        } else if (!this.field_5957) {
            Vector3f effect = this.getWindEffect();
            this.method_36457(this.method_36455() + effect.x);
            this.method_36456(this.method_36454() + effect.z);
            float offsetStrength = 0.005f;
            this.method_18799(this.method_18798().method_1031((double)(effect.x * offsetStrength), 0.0, (double)(effect.z * offsetStrength)));
        }
    }

    @Override
    public void chill() {
        this.lastY = 0.0;
    }

    public float getWindStrength() {
        float sensitivity = this.getProperties().get(VehicleStat.WIND);
        float thundering = this.method_37908().method_8430(0.0f);
        float raining = this.method_37908().method_8478(0.0f);
        float weather = (float)((double)Config.getInstance().windClearWeather + this.method_18798().method_1033() + (double)(thundering * Config.getInstance().windThunderWeather) + (double)(raining * Config.getInstance().windRainWeather));
        return weather * sensitivity;
    }

    public Vector3f getWindEffect() {
        float wind = this.getWindStrength();
        float nx = (float)(Utils.cosNoise((double)this.field_6012 / 20.0 / (double)this.getProperties().get(VehicleStat.MASS)) * (double)wind);
        float nz = (float)(Utils.cosNoise((double)this.field_6012 / 21.0 / (double)this.getProperties().get(VehicleStat.MASS)) * (double)wind);
        return new Vector3f(nx, 0.0f, nz);
    }
}

