/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.entity.weapon;

import immersive_aircraft.Entities;
import immersive_aircraft.Sounds;
import immersive_aircraft.cobalt.network.NetworkHandler;
import immersive_aircraft.config.Config;
import immersive_aircraft.entity.VehicleEntity;
import immersive_aircraft.entity.bullet.BulletEntity;
import immersive_aircraft.entity.misc.WeaponMount;
import immersive_aircraft.entity.weapon.BulletWeapon;
import immersive_aircraft.entity.weapon.RotationalManager;
import immersive_aircraft.network.c2s.FireMessage;
import immersive_aircraft.resources.bbmodel.BBAnimationVariables;
import net.minecraft.class_1297;
import net.minecraft.class_1799;
import net.minecraft.class_3414;
import org.joml.Vector3f;
import org.joml.Vector4f;

public class RotaryCannon
extends BulletWeapon {
    private final RotationalManager rotationalManager = new RotationalManager(this);

    public RotaryCannon(VehicleEntity entity, class_1799 stack, WeaponMount mount, int slot) {
        super(entity, stack, mount, slot);
    }

    @Override
    protected Vector4f getBarrelOffset() {
        return new Vector4f(0.0f, 0.825f, -0.375f, 1.0f);
    }

    public float getVelocity() {
        return 4.0f;
    }

    public float getInaccuracy() {
        return 1.0f;
    }

    @Override
    protected class_1297 getBullet(Vector4f position, Vector3f direction) {
        BulletEntity bullet = (BulletEntity)Entities.BULLET.get().method_5883(this.getEntity().method_37908());
        assert (bullet != null);
        bullet.setDamage(Config.getInstance().rotaryCannonDamage);
        bullet.method_5814(position.x(), position.y(), position.z());
        bullet.method_7432((class_1297)this.getEntity().method_5642());
        bullet.method_7485(direction.x(), direction.y(), direction.z(), this.getVelocity(), this.getInaccuracy());
        return bullet;
    }

    @Override
    public void tick() {
        this.rotationalManager.tick();
        this.rotationalManager.pointTo(this.getEntity());
    }

    @Override
    public void fire(Vector3f direction) {
        if (this.spentAmmo(Config.getInstance().gunpowderAmmunition, 10)) {
            super.fire(direction);
        }
    }

    @Override
    public class_3414 getSound() {
        return Sounds.CANNON.get();
    }

    private Vector3f getDirection() {
        return this.rotationalManager.screenToGlobal(this.getEntity());
    }

    @Override
    public void clientFire(int index) {
        float old = this.rotationalManager.roll;
        this.rotationalManager.roll += 0.25f;
        if (Math.floor(old) != Math.floor(this.rotationalManager.roll)) {
            NetworkHandler.sendToServer(new FireMessage(this.getSlot(), index, this.getDirection()));
        }
    }

    @Override
    public <T extends VehicleEntity> void setAnimationVariables(T entity, float time) {
        super.setAnimationVariables(entity, time);
        float tickDelta = time % 1.0f;
        BBAnimationVariables.set("pitch", (float)((double)this.rotationalManager.getPitch(tickDelta) / Math.PI * 180.0));
        BBAnimationVariables.set("yaw", (float)((double)this.rotationalManager.getYaw(tickDelta) / Math.PI * 180.0));
        BBAnimationVariables.set("roll", (float)((double)this.rotationalManager.getRoll(tickDelta) / Math.PI * 180.0));
    }
}

