/*
 * Decompiled with CFR 0.152.
 */
package immersive_aircraft.fabric.cobalt.network;

import immersive_aircraft.cobalt.network.Message;
import immersive_aircraft.cobalt.network.NetworkHandler;
import io.netty.buffer.Unpooled;
import net.fabricmc.api.EnvType;
import net.fabricmc.fabric.api.client.networking.v1.ClientPlayNetworking;
import net.fabricmc.fabric.api.networking.v1.PayloadTypeRegistry;
import net.fabricmc.fabric.api.networking.v1.PlayerLookup;
import net.fabricmc.fabric.api.networking.v1.ServerPlayNetworking;
import net.fabricmc.loader.api.FabricLoader;
import net.minecraft.class_1297;
import net.minecraft.class_310;
import net.minecraft.class_3222;
import net.minecraft.class_746;
import net.minecraft.class_8710;
import net.minecraft.class_9129;
import net.minecraft.class_9139;

public class NetworkHandlerImpl
extends NetworkHandler.Impl {
    @Override
    public <T extends Message> void registerMessage(String namespace, class_8710.class_9154<T> type, class_9139<class_9129, T> codec, NetworkHandler.ClientHandler<T> clientHandler, NetworkHandler.ServerHandler<T> serverHandler) {
        if (clientHandler != null) {
            PayloadTypeRegistry.playS2C().register(type, codec);
        }
        if (serverHandler != null) {
            PayloadTypeRegistry.playC2S().register(type, codec);
        }
        if (clientHandler != null && FabricLoader.getInstance().getEnvironmentType() == EnvType.CLIENT) {
            ClientProxy.register(type, clientHandler);
        }
        if (serverHandler != null) {
            ServerPlayNetworking.registerGlobalReceiver(type, (payload, context) -> serverHandler.handle(payload, context.player()));
        }
    }

    @Override
    public void sendToServer(Message msg) {
        ClientProxy.sendToServer(msg);
    }

    @Override
    public void sendToPlayer(Message msg, class_3222 e) {
        class_9129 buf = new class_9129(Unpooled.buffer(), e.method_56673());
        msg.encode(buf);
        ServerPlayNetworking.send((class_3222)e, (class_8710)msg);
    }

    @Override
    public void sendToTrackingPlayers(Message msg, class_1297 e) {
        class_9129 buf = new class_9129(Unpooled.buffer(), e.method_56673());
        msg.encode(buf);
        for (class_3222 player : PlayerLookup.tracking((class_1297)e)) {
            ServerPlayNetworking.send((class_3222)player, (class_8710)msg);
        }
    }

    private static final class ClientProxy {
        private ClientProxy() {
        }

        public static <T extends Message> void register(class_8710.class_9154<T> type, NetworkHandler.ClientHandler<T> handler) {
            ClientPlayNetworking.registerGlobalReceiver(type, (payload, context) -> handler.handle(payload));
        }

        public static void sendToServer(Message msg) {
            class_746 player = class_310.method_1551().field_1724;
            if (player != null) {
                class_9129 buf = new class_9129(Unpooled.buffer(), player.method_56673());
                msg.encode(buf);
                ClientPlayNetworking.send((class_8710)msg);
            }
        }
    }
}

