/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.groups;

import com.mojang.authlib.GameProfile;
import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.IntegerArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.builder.RequiredArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.exceptions.CommandSyntaxException;
import com.mojang.brigadier.exceptions.SimpleCommandExceptionType;
import dev.architectury.event.EventResult;
import dev.ftb.mods.ftbessentials.FTBEssentials;
import dev.ftb.mods.ftbessentials.FTBEssentialsEvents;
import dev.ftb.mods.ftbessentials.commands.CommandUtils;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.commands.SimpleConfigurableCommand;
import dev.ftb.mods.ftbessentials.commands.impl.kit.KitCommand;
import dev.ftb.mods.ftbessentials.commands.impl.teleporting.HomeCommand;
import dev.ftb.mods.ftbessentials.commands.impl.teleporting.OfflineTeleportCommand;
import dev.ftb.mods.ftbessentials.commands.impl.teleporting.TPACommand;
import dev.ftb.mods.ftbessentials.commands.impl.teleporting.WarpCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.BlockUtil;
import dev.ftb.mods.ftbessentials.util.DimensionFilter;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.List;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_1959;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2181;
import net.minecraft.class_2191;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_243;
import net.minecraft.class_2561;
import net.minecraft.class_2680;
import net.minecraft.class_2902;
import net.minecraft.class_2960;
import net.minecraft.class_3218;
import net.minecraft.class_3222;
import net.minecraft.class_3532;
import net.minecraft.class_3965;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;

public class TeleportingCommands {
    public static final class_6862<class_2248> IGNORE_RTP_BLOCKS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)FTBEssentials.essentialsId("ignore_rtp"));
    public static final class_6862<class_1959> IGNORE_RTP_BIOMES = class_6862.method_40092((class_5321)class_7924.field_41236, (class_2960)FTBEssentials.essentialsId("ignore_rtp"));
    public static final List<FTBCommand> COMMANDS = List.of(new OfflineTeleportCommand(), new HomeCommand(), new WarpCommand(), new TPACommand(), new SimpleConfigurableCommand(FTBEConfig.BACK, (LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)class_2170.method_9247((String)"back").executes(context -> TeleportingCommands.back(((class_2168)context.getSource()).method_9207())))), new SimpleConfigurableCommand(FTBEConfig.SPAWN, (LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)class_2170.method_9247((String)"spawn").executes(context -> TeleportingCommands.spawn(((class_2168)context.getSource()).method_9207())))), new SimpleConfigurableCommand(FTBEConfig.RTP, (LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"rtp").then(((RequiredArgumentBuilder)class_2170.method_9244((String)"maxDistance", (ArgumentType)IntegerArgumentType.integer((int)((Integer)FTBEConfig.RTP_MIN_DISTANCE.get()), (int)((Integer)FTBEConfig.RTP_MAX_DISTANCE.get()))).requires(context -> FTBEConfig.RTP_MAX_DISTANCE_CUSTOM.get(context.method_44023()))).executes(context -> TeleportingCommands.rtp(((class_2168)context.getSource()).method_9207(), (Integer)FTBEConfig.RTP_MIN_DISTANCE.get(), IntegerArgumentType.getInteger((CommandContext)context, (String)"maxDistance"))))).then(((RequiredArgumentBuilder)class_2170.method_9244((String)"minDistance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)((Integer)FTBEConfig.RTP_MAX_DISTANCE.get()))).requires(context -> FTBEConfig.RTP_MIN_DISTANCE_CUSTOM.get(context.method_44023()))).then(class_2170.method_9244((String)"maxDistance", (ArgumentType)IntegerArgumentType.integer((int)0, (int)((Integer)FTBEConfig.RTP_MAX_DISTANCE.get()))).executes(context -> TeleportingCommands.rtp(((class_2168)context.getSource()).method_9207(), IntegerArgumentType.getInteger((CommandContext)context, (String)"minDistance"), IntegerArgumentType.getInteger((CommandContext)context, (String)"maxDistance")))))).executes(context -> TeleportingCommands.rtp(((class_2168)context.getSource()).method_9207(), (Integer)FTBEConfig.RTP_MIN_DISTANCE.get(), (Integer)FTBEConfig.RTP_MAX_DISTANCE.get())))), new SimpleConfigurableCommand(FTBEConfig.TPL, (LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"teleport_last").requires(CommandUtils.isGamemaster())).then(class_2170.method_9244((String)"player", (ArgumentType)class_2191.method_9329()).executes(context -> TeleportingCommands.tpLast(((class_2168)context.getSource()).method_9207(), (GameProfile)class_2191.method_9330((CommandContext)context, (String)"player").iterator().next()))))), new SimpleConfigurableCommand(FTBEConfig.TPX, (LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpx").requires(CommandUtils.isGamemaster())).then(class_2170.method_9244((String)"dimension", (ArgumentType)class_2181.method_9288()).executes(context -> TeleportingCommands.tpx(((class_2168)context.getSource()).method_9207(), class_2181.method_9289((CommandContext)context, (String)"dimension")))))), new SimpleConfigurableCommand(FTBEConfig.JUMP, (LiteralArgumentBuilder<class_2168>)((LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"jump").requires(CommandUtils.isGamemaster())).executes(ctx -> TeleportingCommands.jump((class_2168)ctx.getSource())))));

    public static void register() {
    }

    private static int back(class_3222 player) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            if (data.teleportHistory.isEmpty()) {
                player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.teleport.history_empty").method_27692(class_124.field_1061), false);
                return 0;
            }
            if (data.backTeleporter.teleport(player, serverPlayerEntity -> data.teleportHistory.getLast()).runCommand(player) != 0) {
                data.markDirty();
                return 1;
            }
            return 0;
        }).orElse(0);
    }

    private static int spawn(class_3222 player) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> {
            class_3218 level = player.field_13995.method_3847(class_1937.field_25179);
            return level == null ? 0 : data.spawnTeleporter.teleport(player, p -> new TeleportPos((class_1937)level, level.method_43126(), Float.valueOf(level.method_43127()), Float.valueOf(0.0f))).runCommand(player);
        }).orElse(0);
    }

    private static int rtp(class_3222 player, int minDistance, int maxDistance) {
        if (maxDistance < minDistance) {
            player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.teleport.max_less_than_min"), false);
            return 0;
        }
        if (!(player.method_5687(2) && ((Boolean)FTBEConfig.ADMINS_EXEMPT_DIMENSION_BLACKLISTS.get()).booleanValue() || DimensionFilter.isRtpDimensionOK((class_5321<class_1937>)player.method_37908().method_27983()))) {
            player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.rtp.not_here").method_27692(class_124.field_1061), false);
            return 0;
        }
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> data.rtpTeleporter.teleport(player, p -> {
            p.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.rtp.looking"), false);
            return TeleportingCommands.findBlockPos((class_3218)player.method_37908(), p, minDistance, maxDistance);
        }).runCommand(player)).orElse(0);
    }

    private static TeleportPos findBlockPos(class_3218 world, class_3222 player, int minDistance, int maxDistance) {
        for (int attempt = 0; attempt < (Integer)FTBEConfig.RTP_MAX_TRIES.get(); ++attempt) {
            EventResult res;
            double dist = (double)minDistance + world.field_9229.method_43058() * (double)(maxDistance - minDistance);
            double angle = world.field_9229.method_43058() * Math.PI * 2.0;
            int x = class_3532.method_15357((double)(Math.cos(angle) * dist));
            int y = 256;
            int z = class_3532.method_15357((double)(Math.sin(angle) * dist));
            class_2338 currentPos = new class_2338(x, y, z);
            if (!world.method_8621().method_11952(currentPos) || world.method_23753(currentPos).method_40220(IGNORE_RTP_BIOMES) || (res = ((FTBEssentialsEvents.RTP)FTBEssentialsEvents.RTP_EVENT.invoker()).teleport(world, player, currentPos, attempt)).isFalse()) continue;
            world.method_8500(currentPos);
            class_2338 hmPos = world.method_8598(class_2902.class_2903.field_13203, currentPos);
            if (hmPos.method_10264() <= 0) continue;
            class_2338 goodPos = null;
            if (hmPos.method_10264() < world.method_32819()) {
                goodPos = hmPos;
            } else {
                for (class_2338 newPos : class_2338.method_30512((class_2338)new class_2338(hmPos.method_10263(), world.method_8615(), hmPos.method_10260()), (int)16, (class_2350)class_2350.field_11034, (class_2350)class_2350.field_11035)) {
                    class_2680 bs = world.method_8320(newPos);
                    if (!bs.method_51366() || bs.method_26164(IGNORE_RTP_BLOCKS) || !world.method_22347(newPos.method_10086(1)) || !world.method_22347(newPos.method_10086(2)) || !world.method_22347(newPos.method_10086(3))) continue;
                    goodPos = newPos.method_10062();
                    break;
                }
            }
            if (goodPos == null) continue;
            String pos = String.format(" @ [x %d, y %d, z %d]", goodPos.method_10263(), goodPos.method_10264(), goodPos.method_10260());
            player.method_7353((class_2561)class_2561.method_43469((String)"ftbessentials.rtp.found", (Object[])new Object[]{attempt + 1, pos}), false);
            return new TeleportPos((class_5321<class_1937>)world.method_27983(), goodPos.method_10084());
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.rtp.failed").method_27692(class_124.field_1061), false);
        return new TeleportPos((class_1297)player);
    }

    private static int tpLast(class_3222 player, GameProfile to) {
        class_3222 toPlayer = player.field_13995.method_3760().method_14602(to.getId());
        if (toPlayer != null) {
            FTBEPlayerData.addTeleportHistory(player);
            new TeleportPos((class_1297)toPlayer).teleport(player);
            return 1;
        }
        return FTBEPlayerData.getOrCreate(player.method_5682(), to.getId()).map(data -> {
            FTBEPlayerData.addTeleportHistory(player);
            data.getLastSeenPos().teleport(player);
            return 1;
        }).orElse(0);
    }

    private static int tpx(class_3222 player, class_3218 to) {
        player.method_14251(to, player.method_23317(), player.method_23318(), player.method_23321(), player.method_36454(), player.method_36455());
        return 1;
    }

    private static int jump(class_2168 source) throws CommandSyntaxException {
        class_1937 level;
        class_3222 player = source.method_9207();
        class_3965 res = BlockUtil.getFocusedBlock(player, player.method_5682().method_3760().method_14568() * 16).orElseThrow(() -> ((SimpleCommandExceptionType)KitCommand.NOT_LOOKING_AT_BLOCK).create());
        class_2338.class_2339 mPos = res.method_17777().method_10084().method_25503();
        while (!(TeleportingCommands.isEmptyShape(level = player.method_37908(), mPos.method_10084()) && TeleportingCommands.isEmptyShape(level, mPos.method_10086(2)) || mPos.method_10264() >= level.method_31600())) {
            mPos.method_10104(class_2350.field_11036, 2);
        }
        class_243 vec = class_243.method_24955((class_2382)mPos);
        player.method_5859(vec.method_10216(), vec.method_10214(), vec.method_10215());
        return 0;
    }

    private static boolean isEmptyShape(class_1937 level, class_2338 pos) {
        return level.method_8320(pos).method_26220((class_1922)level, pos).method_1110();
    }
}

