/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.misc;

import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.mixin.PlayerListAccess;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.Leaderboard;
import java.io.File;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_2168;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_3442;
import net.minecraft.class_5218;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.server.MinecraftServer;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LeaderboardCommand
implements FTBCommand {
    private static final Logger LOGGER = LoggerFactory.getLogger(LeaderboardCommand.class);

    @Override
    public boolean enabled() {
        return FTBEConfig.LEADERBOARD.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<class_2168>> register() {
        return Collections.singletonList(Leaderboard.buildCommand());
    }

    public static <T extends Number> int leaderboard(class_2168 source, Leaderboard<T> leaderboard, boolean reverse) {
        int i;
        List<UUID> knownPlayers = FTBEPlayerData.getAllKnownPlayers();
        List<FTBEPlayerData> playerData = knownPlayers.stream().map(uuid -> FTBEPlayerData.getOrCreate(source.method_9211(), uuid)).filter(Optional::isPresent).map(Optional::get).toList();
        ArrayList<Pair> list = new ArrayList<Pair>();
        int self = -1;
        Path worldPath = source.method_9211().method_27050(class_5218.field_24181);
        if (!Files.exists(worldPath, new LinkOption[0])) {
            return 1;
        }
        playerData.forEach(pd -> {
            class_3442 stats = LeaderboardCommand.getPlayerStats(source.method_9211(), pd.getUuid());
            Object num = leaderboard.getValue(stats);
            if (leaderboard.test(num)) {
                list.add(Pair.of((Object)pd, num));
            }
        });
        if (reverse) {
            list.sort(Comparator.comparingDouble(pair -> ((Number)pair.getRight()).doubleValue()));
        } else {
            list.sort((pair1, pair2) -> Double.compare(((Number)pair2.getRight()).doubleValue(), ((Number)pair1.getRight()).doubleValue()));
        }
        if (source.method_9228() instanceof class_3222) {
            for (i = 0; i < list.size(); ++i) {
                if (!((FTBEPlayerData)((Pair)list.get(i)).getLeft()).getUuid().equals(source.method_9228().method_5667())) continue;
                self = list.size();
                break;
            }
        }
        source.method_9226(() -> class_2561.method_43470((String)"== ").method_10852((class_2561)class_2561.method_43469((String)"ftbessentials.leaderboard", (Object[])new Object[]{leaderboard.formattedName()})).method_10852((class_2561)class_2561.method_43470((String)" ==").method_27692(class_124.field_1077)), false);
        if (list.isEmpty()) {
            source.method_9226(() -> class_2561.method_43471((String)"ftbessentials.leaderboard.no_data").method_27692(class_124.field_1080), false);
            return 1;
        }
        for (i = 0; i < Math.min(20, list.size()); ++i) {
            Pair pair3 = (Pair)list.get(i);
            String num = String.format("%02d", i + 1);
            class_5250 component = class_2561.method_43470((String)"");
            component.method_27692(class_124.field_1080);
            if (i == 0) {
                component.method_10852((class_2561)class_2561.method_43470((String)("#" + num + " ")).method_27696(class_2583.field_24360.method_10977(class_124.field_1065)));
            } else if (i == 1) {
                component.method_10852((class_2561)class_2561.method_43470((String)("#" + num + " ")).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)11590143))));
            } else if (i == 2) {
                component.method_10852((class_2561)class_2561.method_43470((String)("#" + num + " ")).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)13467442))));
            } else {
                component.method_10852((class_2561)class_2561.method_43470((String)("#" + num + " ")).method_27696(class_2583.field_24360.method_27703(class_5251.method_27717((int)0xB4B4B4))));
            }
            class_5251 color = class_5251.method_27717((int)13467442);
            component.method_10852((class_2561)class_2561.method_43470((String)((FTBEPlayerData)pair3.getLeft()).getName()).method_27692(i == self ? class_124.field_1060 : class_124.field_1054));
            component.method_10852((class_2561)class_2561.method_43470((String)": "));
            component.method_10852((class_2561)class_2561.method_43470((String)leaderboard.asString((Number)pair3.getRight())).method_27692(class_124.field_1068));
            source.method_9226(() -> component, false);
        }
        return 1;
    }

    private static class_3442 getPlayerStats(MinecraftServer server, UUID playerId) {
        Map<UUID, class_3442> stats = ((PlayerListAccess)server.method_3760()).getStats();
        return stats.computeIfAbsent(playerId, k -> {
            File file1 = server.method_27050(class_5218.field_24181).toFile();
            File file2 = new File(file1, String.valueOf(playerId) + ".json");
            return new class_3442(server, file2);
        });
    }
}

