/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.teleporting;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.tree.CommandNode;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import java.io.File;
import java.io.IOException;
import java.nio.file.Path;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_124;
import net.minecraft.class_156;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2267;
import net.minecraft.class_2277;
import net.minecraft.class_243;
import net.minecraft.class_2487;
import net.minecraft.class_2489;
import net.minecraft.class_2499;
import net.minecraft.class_2505;
import net.minecraft.class_2507;
import net.minecraft.class_2520;
import net.minecraft.class_2561;
import net.minecraft.class_3218;
import net.minecraft.class_5218;
import net.minecraft.class_5242;
import net.minecraft.server.MinecraftServer;

public class OfflineTeleportCommand
implements FTBCommand {
    @Override
    public boolean enabled() {
        return FTBEConfig.TP_OFFLINE.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<class_2168>> register() {
        LiteralArgumentBuilder tpOffline = class_2170.method_9247((String)"tp_offline");
        ((LiteralArgumentBuilder)((LiteralArgumentBuilder)tpOffline.requires(FTBEConfig.TP_OFFLINE.enabledAndOp())).then(class_2170.method_9247((String)"name").then(class_2170.method_9244((String)"player", (ArgumentType)StringArgumentType.word()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(ctx -> this.tpOffline((class_2168)ctx.getSource(), StringArgumentType.getString((CommandContext)ctx, (String)"player"), ((class_2168)ctx.getSource()).method_9225(), class_2277.method_9734((CommandContext)ctx, (String)"pos"))))))).then(class_2170.method_9247((String)"id").then(class_2170.method_9244((String)"player_id", (ArgumentType)class_5242.method_27643()).then(class_2170.method_9244((String)"pos", (ArgumentType)class_2277.method_9737()).executes(ctx -> this.tpOffline((class_2168)ctx.getSource(), class_5242.method_27645((CommandContext)ctx, (String)"player_id"), ((class_2168)ctx.getSource()).method_9225(), class_2277.method_9734((CommandContext)ctx, (String)"pos"))))));
        LiteralArgumentBuilder alias = (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"tpo").requires(FTBEConfig.TP_OFFLINE.enabledAndOp())).redirect((CommandNode)tpOffline.build());
        return List.of(tpOffline, alias);
    }

    private int tpOffline(class_2168 source, String playerName, class_3218 level, class_2267 dest) {
        source.method_9211().method_3793().method_37156(playerName).whenComplete((profileOpt, throwable) -> source.method_9211().method_40000(() -> profileOpt.ifPresentOrElse(profile -> this.tpOffline(source, profile.getId(), level, dest), () -> source.method_9213((class_2561)class_2561.method_43469((String)"ftbessentials.unknown_player", (Object[])new Object[]{playerName})))));
        return 1;
    }

    private int tpOffline(class_2168 source, UUID playerId, class_3218 level, class_2267 dest) {
        MinecraftServer server = source.method_9211();
        Path playerDir = server.method_27050(class_5218.field_24182);
        Path datFile = playerDir.resolve(String.valueOf(playerId) + ".dat");
        if (server.method_3760().method_14602(playerId) != null) {
            source.method_9213((class_2561)class_2561.method_43471((String)"ftbessentials.tp_offline.player_is_online"));
            return 0;
        }
        try {
            class_2487 tag = class_2507.method_30613((Path)datFile, (class_2505)class_2505.method_53898());
            class_243 vec = dest.method_9708(source);
            class_2499 newPos = new class_2499();
            newPos.add((Object)class_2489.method_23241((double)vec.field_1352));
            newPos.add((Object)class_2489.method_23241((double)vec.field_1351));
            newPos.add((Object)class_2489.method_23241((double)vec.field_1350));
            tag.method_10566("Pos", (class_2520)newPos);
            tag.method_10582("Dimension", level.method_27983().method_29177().toString());
            Path tempFile = File.createTempFile(String.valueOf(playerId) + "-", ".dat", playerDir.toFile()).toPath();
            class_2507.method_30614((class_2487)tag, (Path)tempFile);
            Path backupFile = playerDir.resolve(String.valueOf(playerId) + ".dat_old");
            class_156.method_30626((Path)datFile, (Path)tempFile, (Path)backupFile);
            String pos = String.format("[%.2f,%.2f,%.2f]", vec.field_1352, vec.field_1351, vec.field_1350);
            source.method_9226(() -> class_2561.method_43469((String)"ftbessentials.tp_offline.moved", (Object[])new Object[]{playerId, pos, source.method_9225().method_27983().method_29177()}), false);
            return 1;
        }
        catch (IOException e) {
            source.method_9213((class_2561)class_2561.method_43469((String)"ftbessentials.tp_offline.cant_update", (Object[])new Object[]{e.getMessage()}).method_27692(class_124.field_1061));
            return 0;
        }
    }
}

