/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbessentials.commands.impl.teleporting;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import dev.ftb.mods.ftbessentials.commands.CommandUtils;
import dev.ftb.mods.ftbessentials.commands.FTBCommand;
import dev.ftb.mods.ftbessentials.config.FTBEConfig;
import dev.ftb.mods.ftbessentials.util.FTBEPlayerData;
import dev.ftb.mods.ftbessentials.util.FTBEWorldData;
import dev.ftb.mods.ftbessentials.util.TeleportPos;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import net.minecraft.class_124;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2168;
import net.minecraft.class_2170;
import net.minecraft.class_2172;
import net.minecraft.class_2338;
import net.minecraft.class_2374;
import net.minecraft.class_2558;
import net.minecraft.class_2561;
import net.minecraft.class_2568;
import net.minecraft.class_2583;
import net.minecraft.class_3222;
import net.minecraft.class_5250;
import net.minecraft.class_5321;

public class WarpCommand
implements FTBCommand {
    @Override
    public boolean enabled() {
        return FTBEConfig.WARP.isEnabled();
    }

    @Override
    public List<LiteralArgumentBuilder<class_2168>> register() {
        return List.of((LiteralArgumentBuilder)class_2170.method_9247((String)"warp").then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(this.getWarpSuggestions(), (SuggestionsBuilder)builder)).executes(context -> this.warp(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"name")))), (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"setwarp").requires(CommandUtils.isGamemaster())).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).executes(context -> this.setWarp(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"name")))), (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"delwarp").requires(CommandUtils.isGamemaster())).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.greedyString()).suggests((context, builder) -> class_2172.method_9265(this.getWarpSuggestions(), (SuggestionsBuilder)builder)).executes(context -> this.deleteWarp(((class_2168)context.getSource()).method_9207(), StringArgumentType.getString((CommandContext)context, (String)"name")))), (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"listwarps").requires((Predicate)FTBEConfig.WARP)).executes(context -> this.listWarps((class_2168)context.getSource())));
    }

    private Set<String> getWarpSuggestions() {
        return FTBEWorldData.instance.warpManager().getNames();
    }

    private int warp(class_3222 player, String name) {
        return FTBEPlayerData.getOrCreate((class_1657)player).map(data -> FTBEWorldData.instance.warpManager().teleportTo(name, player, data.warpTeleporter).runCommand(player)).orElse(0);
    }

    private int setWarp(class_3222 player, String name) {
        FTBEWorldData.instance.warpManager().addDestination(name, new TeleportPos((class_1297)player), player);
        player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.warp.set"), false);
        return 1;
    }

    private int deleteWarp(class_3222 player, String name) {
        if (FTBEWorldData.instance.warpManager().deleteDestination(name.toLowerCase())) {
            player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.warp.deleted"), false);
            return 1;
        }
        player.method_7353((class_2561)class_2561.method_43471((String)"ftbessentials.warp.not_found"), false);
        return 0;
    }

    private int listWarps(class_2168 source) {
        if (FTBEWorldData.instance.warpManager().getNames().isEmpty()) {
            source.method_9226(() -> class_2561.method_43471((String)"ftbessentials.none"), false);
        } else {
            TeleportPos origin = new TeleportPos((class_5321<class_1937>)source.method_9225().method_27983(), class_2338.method_49638((class_2374)source.method_9222()));
            FTBEWorldData.instance.warpManager().destinations().forEach(entry -> {
                class_5250 line = class_2561.method_43469((String)"ftbessentials.home.show_home", (Object[])new Object[]{class_2561.method_43470((String)entry.name()).method_27692(class_124.field_1075), entry.destination().distanceString(origin)});
                if (source.method_9259(2)) {
                    line.method_27696(class_2583.field_24360.method_10958(new class_2558(class_2558.class_2559.field_11750, "/tp @s " + entry.destination().posAsString())).method_10949(new class_2568(class_2568.class_5247.field_24342, (Object)class_2561.method_43471((String)"ftbessentials.click_to_teleport"))));
                }
                source.method_9226(() -> line, false);
            });
        }
        return 1;
    }
}

