/*
 * Decompiled with CFR 0.152.
 */
package dev.worldgen.lithostitched.worldgen.modifier;

import com.mojang.datafixers.kinds.App;
import com.mojang.datafixers.kinds.Applicative;
import com.mojang.serialization.MapCodec;
import com.mojang.serialization.codecs.RecordCodecBuilder;
import dev.worldgen.lithostitched.mixin.common.BiomeAccessor;
import dev.worldgen.lithostitched.mixin.common.MappedRegistryAccessor;
import dev.worldgen.lithostitched.worldgen.modifier.Modifier;
import dev.worldgen.lithostitched.worldgen.modifier.util.BiomeEffects;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;
import net.minecraft.class_1959;
import net.minecraft.class_2378;
import net.minecraft.class_4763;
import net.minecraft.class_5321;
import net.minecraft.class_5455;
import net.minecraft.class_6880;
import net.minecraft.class_6885;
import net.minecraft.class_7924;
import net.minecraft.class_9248;

public record ReplaceEffectsModifier(class_6885<class_1959> biomes, BiomeEffects specialEffects) implements Modifier
{
    public static final MapCodec<ReplaceEffectsModifier> CODEC = RecordCodecBuilder.mapCodec(instance -> instance.group((App)class_1959.field_26750.fieldOf("biomes").forGetter(ReplaceEffectsModifier::biomes), (App)BiomeEffects.CODEC.fieldOf("effects").forGetter(ReplaceEffectsModifier::specialEffects)).apply((Applicative)instance, ReplaceEffectsModifier::new));

    @Override
    public void applyModifier(class_5455 registryAccess) {
        List biomes = this.biomes().method_40239().toList();
        class_2378 registry = registryAccess.method_30530(class_7924.field_41236);
        for (class_6880 entry : biomes.stream().toList()) {
            this.applyModifier((class_1959)entry.comp_349());
            if (!entry.method_40230().isPresent()) continue;
            class_5321 key = (class_5321)entry.method_40230().get();
            Optional knownPackInfo = registry.method_57058(key);
            knownPackInfo.ifPresent(registrationInfo -> ((MappedRegistryAccessor)registry).lithostitched$getRegistrationInfos().put(key, new class_9248(Optional.empty(), registrationInfo.comp_2355())));
        }
    }

    @Override
    public void applyModifier() {
    }

    public void applyModifier(class_1959 biome) {
        BiomeAccessor accessor = (BiomeAccessor)biome;
        class_4763 effects = accessor.getSpecialEffects();
        class_4763.class_4764 builder = new class_4763.class_4764();
        this.tryApplyRequired(BiomeEffects::fogColor, () -> ((class_4763)effects).method_24387(), arg_0 -> ((class_4763.class_4764)builder).method_24392(arg_0));
        this.tryApplyRequired(BiomeEffects::waterColor, () -> ((class_4763)effects).method_24388(), arg_0 -> ((class_4763.class_4764)builder).method_24395(arg_0));
        this.tryApplyRequired(BiomeEffects::waterFogColor, () -> ((class_4763)effects).method_24389(), arg_0 -> ((class_4763.class_4764)builder).method_24397(arg_0));
        this.tryApplyRequired(BiomeEffects::skyColor, () -> ((class_4763)effects).method_30810(), arg_0 -> ((class_4763.class_4764)builder).method_30820(arg_0));
        this.tryApplyOptional(BiomeEffects::foliageColor, () -> ((class_4763)effects).method_30811(), arg_0 -> ((class_4763.class_4764)builder).method_30821(arg_0));
        this.tryApplyOptional(BiomeEffects::grassColor, () -> ((class_4763)effects).method_30812(), arg_0 -> ((class_4763.class_4764)builder).method_30822(arg_0));
        this.tryApplyRequired(BiomeEffects::grassColorModifier, () -> ((class_4763)effects).method_30814(), arg_0 -> ((class_4763.class_4764)builder).method_30818(arg_0));
        this.tryApplyOptional(BiomeEffects::ambientParticle, () -> ((class_4763)effects).method_24390(), arg_0 -> ((class_4763.class_4764)builder).method_24393(arg_0));
        this.tryApplyOptional(BiomeEffects::ambientSound, () -> ((class_4763)effects).method_24939(), arg_0 -> ((class_4763.class_4764)builder).method_24942(arg_0));
        this.tryApplyOptional(BiomeEffects::moodSound, () -> ((class_4763)effects).method_24940(), arg_0 -> ((class_4763.class_4764)builder).method_24943(arg_0));
        this.tryApplyOptional(BiomeEffects::additionsSound, () -> ((class_4763)effects).method_24941(), arg_0 -> ((class_4763.class_4764)builder).method_24944(arg_0));
        this.tryApplyOptional(BiomeEffects::music, () -> ((class_4763)effects).method_27345(), arg_0 -> ((class_4763.class_4764)builder).method_27346(arg_0));
        accessor.setSpecialEffects(builder.method_24391());
    }

    private <T> void tryApplyRequired(Function<BiomeEffects, Optional<T>> getter, Supplier<T> fallback, Consumer<T> applier) {
        applier.accept(getter.apply(this.specialEffects).orElse(fallback.get()));
    }

    private <T> void tryApplyOptional(Function<BiomeEffects, Optional<T>> getter, Supplier<Optional<T>> fallback, Consumer<T> applier) {
        Object value = getter.apply(this.specialEffects).orElse(fallback.get().orElse(null));
        if (value != null) {
            applier.accept(value);
        }
    }

    @Override
    public Modifier.ModifierPhase getPhase() {
        return Modifier.ModifierPhase.MODIFY;
    }

    @Override
    public MapCodec<? extends Modifier> codec() {
        return CODEC;
    }
}

