/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import dev.architectury.event.EventResult;
import dev.architectury.event.events.common.BlockEvent;
import dev.architectury.event.events.common.CommandRegistrationEvent;
import dev.architectury.event.events.common.EntityEvent;
import dev.architectury.event.events.common.InteractionEvent;
import dev.architectury.event.events.common.LifecycleEvent;
import dev.architectury.event.events.common.PlayerEvent;
import dev.architectury.event.events.common.TickEvent;
import dev.architectury.hooks.level.entity.PlayerHooks;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.ReloadListenerRegistry;
import dev.architectury.utils.EnvExecutor;
import dev.architectury.utils.value.IntValue;
import dev.ftb.mods.ftblibrary.config.manager.ConfigManager;
import dev.ftb.mods.ftbultimine.BlockBreakingRegistry;
import dev.ftb.mods.ftbultimine.BlockSelectionRegistry;
import dev.ftb.mods.ftbultimine.CooldownTracker;
import dev.ftb.mods.ftbultimine.FTBUltimineAPIImpl;
import dev.ftb.mods.ftbultimine.FTBUltimineCommands;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.FTBUltiminePlayerData;
import dev.ftb.mods.ftbultimine.RestrictionHandlerRegistry;
import dev.ftb.mods.ftbultimine.api.FTBUltimineAPI;
import dev.ftb.mods.ftbultimine.api.blockbreaking.BlockBreakHandler;
import dev.ftb.mods.ftbultimine.api.blockbreaking.RegisterBlockBreakHandlerEvent;
import dev.ftb.mods.ftbultimine.api.blockselection.RegisterBlockSelectionHandlerEvent;
import dev.ftb.mods.ftbultimine.api.crop.RegisterCropLikeEvent;
import dev.ftb.mods.ftbultimine.api.restriction.RegisterRestrictionHandlerEvent;
import dev.ftb.mods.ftbultimine.api.rightclick.RegisterRightClickHandlerEvent;
import dev.ftb.mods.ftbultimine.api.shape.RegisterShapeEvent;
import dev.ftb.mods.ftbultimine.api.shape.Shape;
import dev.ftb.mods.ftbultimine.api.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.api.util.ItemCollector;
import dev.ftb.mods.ftbultimine.client.FTBUltimineClient;
import dev.ftb.mods.ftbultimine.config.FTBUltimineClientConfig;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.crops.CropLikeRegistry;
import dev.ftb.mods.ftbultimine.crops.VanillaCropLikeHandler;
import dev.ftb.mods.ftbultimine.integration.IntegrationHandler;
import dev.ftb.mods.ftbultimine.integration.acceldecay.AcceleratedDecay;
import dev.ftb.mods.ftbultimine.integration.acceldecay.LogBreakTracker;
import dev.ftb.mods.ftbultimine.net.FTBUltimineNet;
import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.net.SyncUltimineTimePacket;
import dev.ftb.mods.ftbultimine.rightclick.AxeStripping;
import dev.ftb.mods.ftbultimine.rightclick.CropHarvesting;
import dev.ftb.mods.ftbultimine.rightclick.FarmlandConversion;
import dev.ftb.mods.ftbultimine.rightclick.RightClickDispatcher;
import dev.ftb.mods.ftbultimine.rightclick.ShovelFlattening;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import dev.ftb.mods.ftbultimine.shape.EscapeTunnelShape;
import dev.ftb.mods.ftbultimine.shape.LargeTunnelShape;
import dev.ftb.mods.ftbultimine.shape.MiningTunnelShape;
import dev.ftb.mods.ftbultimine.shape.ShapeRegistry;
import dev.ftb.mods.ftbultimine.shape.ShapelessShape;
import dev.ftb.mods.ftbultimine.shape.SmallSquareShape;
import dev.ftb.mods.ftbultimine.shape.SmallTunnelShape;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.function.Predicate;
import net.minecraft.class_1268;
import net.minecraft.class_1297;
import net.minecraft.class_1303;
import net.minecraft.class_1542;
import net.minecraft.class_1657;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_1831;
import net.minecraft.class_1922;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_3264;
import net.minecraft.class_3300;
import net.minecraft.class_3302;
import net.minecraft.class_3481;
import net.minecraft.class_3965;
import net.minecraft.class_4013;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7924;
import net.minecraft.class_8710;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class FTBUltimine {
    public static FTBUltimine instance;
    public static final Logger LOGGER;
    public final FTBUltimineCommon proxy;
    private Map<UUID, FTBUltiminePlayerData> cachedDataMap;
    private boolean isBreakingBlock;
    private int tempBlockDroppedXp;
    private ItemCollector tempBlockDropsList;
    public static final class_6862<class_1792> DENY_TAG;
    public static final class_6862<class_1792> STRICT_DENY_TAG;
    public static final class_6862<class_1792> ALLOW_TAG;
    public static final class_6862<class_2248> EXCLUDED_BLOCKS;
    public static final class_6862<class_2248> BLOCK_WHITELIST;
    public static final class_6862<class_2248> TILLABLE_TAG;
    public static final class_6862<class_2248> FLATTENABLE_TAG;
    private static Predicate<class_1657> permissionOverride;

    public static void setPermissionOverride(Predicate<class_1657> p) {
        permissionOverride = p;
    }

    public FTBUltimine() {
        instance = this;
        FTBUltimineAPI._init(FTBUltimineAPIImpl.INSTANCE);
        ConfigManager.getInstance().registerClientConfig(FTBUltimineClientConfig.CONFIG, "ftbultimine.client_settings");
        ConfigManager.getInstance().registerServerConfig(FTBUltimineServerConfig.CONFIG, "ftbultimine.server_settings", true, FTBUltimineServerConfig::onConfigChanged);
        FTBUltimineNet.init();
        IntegrationHandler.init();
        this.proxy = (FTBUltimineCommon)EnvExecutor.getEnvSpecific(() -> FTBUltimineClient::new, () -> FTBUltimineCommon::new);
        ReloadListenerRegistry.register((class_3264)class_3264.field_14190, (class_3302)new DataReloadListener());
        LifecycleEvent.SETUP.register(this::commonSetup);
        PlayerEvent.PLAYER_JOIN.register(this::playerJoined);
        LifecycleEvent.SERVER_BEFORE_START.register(this::serverStarting);
        LifecycleEvent.SERVER_STOPPING.register(this::serverStopping);
        BlockEvent.BREAK.register(this::blockBroken);
        InteractionEvent.RIGHT_CLICK_BLOCK.register(this::blockRightClick);
        TickEvent.PLAYER_PRE.register(this::playerTick);
        EntityEvent.ADD.register(this::entityJoinedWorld);
        CommandRegistrationEvent.EVENT.register(FTBUltimineCommands::registerCommands);
        RegisterRightClickHandlerEvent.REGISTER.register(this::registerBuiltinHandlers);
        RegisterShapeEvent.REGISTER.register(this::registerBuiltinShapes);
        RegisterCropLikeEvent.REGISTER.register(this::registerCropHandlers);
    }

    private void commonSetup() {
        ((RegisterRestrictionHandlerEvent)RegisterRestrictionHandlerEvent.REGISTER.invoker()).register(RestrictionHandlerRegistry.INSTANCE);
        ((RegisterShapeEvent)RegisterShapeEvent.REGISTER.invoker()).register(ShapeRegistry.INSTANCE);
    }

    private void registerBuiltinShapes(RegisterShapeEvent.Registry shapeRegistry) {
        shapeRegistry.register(new ShapelessShape());
        shapeRegistry.register(new SmallTunnelShape());
        shapeRegistry.register(new SmallSquareShape());
        shapeRegistry.register(new LargeTunnelShape());
        shapeRegistry.register(new MiningTunnelShape());
        shapeRegistry.register(new EscapeTunnelShape());
    }

    private void registerCropHandlers(RegisterCropLikeEvent.Dispatcher dispatcher) {
        dispatcher.registerHandler(VanillaCropLikeHandler.INSTANCE);
    }

    private void registerBuiltinHandlers(RegisterRightClickHandlerEvent.Dispatcher dispatcher) {
        dispatcher.registerHandler(AxeStripping.INSTANCE);
        dispatcher.registerHandler(ShovelFlattening.INSTANCE);
        dispatcher.registerHandler(FarmlandConversion.INSTANCE);
        dispatcher.registerHandler(CropHarvesting.INSTANCE);
    }

    @NotNull
    public FTBUltiminePlayerData getOrCreatePlayerData(class_1657 player) {
        return this.cachedDataMap.computeIfAbsent(player.method_5667(), FTBUltiminePlayerData::new);
    }

    private void playerJoined(class_3222 serverPlayer) {
        NetworkManager.sendToPlayer((class_3222)serverPlayer, (class_8710)new SyncUltimineTimePacket(FTBUltimineServerConfig.getUltimineCooldown(serverPlayer), SyncUltimineTimePacket.TimeType.COOLDOWN));
    }

    private void serverStarting(MinecraftServer server) {
        this.cachedDataMap = new HashMap<UUID, FTBUltiminePlayerData>();
        ((RegisterRightClickHandlerEvent)RegisterRightClickHandlerEvent.REGISTER.invoker()).register(RightClickDispatcher.getInstance());
        ((RegisterCropLikeEvent)RegisterCropLikeEvent.REGISTER.invoker()).register(CropLikeRegistry.getInstance());
        ((RegisterBlockBreakHandlerEvent)RegisterBlockBreakHandlerEvent.REGISTER.invoker()).register(BlockBreakingRegistry.getInstance());
        ((RegisterBlockSelectionHandlerEvent)RegisterBlockSelectionHandlerEvent.REGISTER.invoker()).register(BlockSelectionRegistry.getInstance());
    }

    private void serverStopping(MinecraftServer server) {
        RightClickDispatcher.getInstance().clear();
        CropLikeRegistry.getInstance().clear();
        BlockBreakingRegistry.getInstance().clear();
        BlockSelectionRegistry.getInstance().clear();
    }

    public void setKeyPressed(class_3222 player, boolean pressed) {
        FTBUltiminePlayerData data = this.getOrCreatePlayerData((class_1657)player);
        data.setPressed(pressed);
        data.clearCache();
        if (!data.isPressed()) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)SendShapePacket.adjustShapeOnly(data.getCurrentShapeIndex()));
        }
    }

    public void modeChanged(class_3222 player, boolean next) {
        FTBUltiminePlayerData data = this.getOrCreatePlayerData((class_1657)player);
        data.cycleShape(next);
        data.clearCache();
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)SendShapePacket.adjustShapeOnly(data.getCurrentShapeIndex()));
    }

    public static boolean isValidTool(class_1799 mainHand, class_1799 offHand) {
        if (mainHand.method_31573(STRICT_DENY_TAG) || offHand.method_31573(STRICT_DENY_TAG) || mainHand.method_31573(DENY_TAG)) {
            return false;
        }
        if (((Boolean)FTBUltimineServerConfig.REQUIRE_TOOL.get()).booleanValue()) {
            if (mainHand.method_7960()) {
                return false;
            }
            return mainHand.method_7909() instanceof class_1831 || mainHand.method_7936() > 0 || mainHand.method_31573(ALLOW_TAG);
        }
        return true;
    }

    public boolean canUltimine(class_1657 player) {
        class_1799 offHand;
        if (PlayerHooks.isFake((class_1657)player) || player.method_5667() == null || CooldownTracker.isOnCooldown(player)) {
            return false;
        }
        if (player.method_7344().method_7586() <= 0 && !player.method_7337()) {
            return false;
        }
        if (!permissionOverride.test(player)) {
            return false;
        }
        class_1799 mainHand = player.method_6047();
        return FTBUltimine.isValidTool(mainHand, offHand = player.method_6079()) && RestrictionHandlerRegistry.INSTANCE.canUltimine(player);
    }

    public EventResult blockBroken(class_1937 world, class_2338 origPos, class_2680 state, class_3222 player, @Nullable IntValue xp) {
        class_3965 bhr;
        FTBUltiminePlayerData data;
        block13: {
            block12: {
                if (this.isBreakingBlock || !this.canUltimine((class_1657)player)) {
                    return EventResult.pass();
                }
                data = this.getOrCreatePlayerData((class_1657)player);
                if (!data.isPressed()) {
                    return EventResult.pass();
                }
                class_239 hitResult = FTBUltiminePlayerData.rayTrace(player);
                if (!(hitResult instanceof class_3965)) break block12;
                bhr = (class_3965)hitResult;
                if (hitResult.method_17783() == class_239.class_240.field_1332) break block13;
            }
            return EventResult.pass();
        }
        data.clearCache();
        data.updateBlocks(player, origPos, bhr.method_17780(), false, FTBUltimineServerConfig.getMaxBlocks(player));
        if (!data.hasCachedPositions()) {
            return EventResult.pass();
        }
        if ((double)player.field_7495 < (double)data.cachedPositions().size() * FTBUltimineServerConfig.getExperiencePerBlock(player)) {
            return EventResult.pass();
        }
        this.isBreakingBlock = true;
        this.tempBlockDropsList = new ItemCollector();
        this.tempBlockDroppedXp = 0;
        boolean hadItem = !player.method_6047().method_7960();
        Shape shape = data.getCurrentShape();
        float baseSpeed = state.method_26214((class_1922)world, origPos);
        int blocksMined = 0;
        for (class_2338 pos : data.cachedPositions()) {
            class_2680 state1 = world.method_8320(pos);
            if (AcceleratedDecay.available && state1.method_26164(class_3481.field_15503) && LogBreakTracker.INSTANCE.playerRecentlyBrokeLog((class_1657)player, 1500L)) {
                world.method_8651(pos, true, (class_1297)player);
                continue;
            }
            float destroySpeed = state1.method_26214((class_1922)world, pos);
            if (!player.method_7337() && (destroySpeed < 0.0f || destroySpeed > baseSpeed || !player.method_7305(state1))) continue;
            if (!FTBUltimine.tryBreakBlock(player, pos, state, shape, bhr) && ((Boolean)FTBUltimineServerConfig.CANCEL_ON_BLOCK_BREAK_FAIL.get()).booleanValue()) break;
            if (!player.method_7337()) {
                player.method_7322((float)(FTBUltimineServerConfig.getExhaustionPerBlock(player) * 0.005));
                if (FTBUltimineAPI.isTooExhausted(player)) break;
            }
            class_1799 stack = player.method_6047();
            if (hadItem && stack.method_7960() || hadItem && (Integer)FTBUltimineServerConfig.PREVENT_TOOL_BREAK.get() > 0 && stack.method_7963() && stack.method_7919() >= stack.method_7936() - (Integer)FTBUltimineServerConfig.PREVENT_TOOL_BREAK.get()) break;
            ++blocksMined;
        }
        BlockBreakingRegistry.INSTANCE.getHandlers().forEach(h -> h.postBreak((class_1657)player));
        if (!player.method_7337()) {
            CooldownTracker.setLastUltimineTime((class_1657)player, System.currentTimeMillis());
            data.addPendingXPCost(player, Math.max(0, blocksMined - 1));
        }
        this.isBreakingBlock = false;
        this.tempBlockDropsList.drop(player.method_37908(), origPos);
        if (this.tempBlockDroppedXp > 0) {
            player.method_37908().method_8649((class_1297)new class_1303(player.method_37908(), (double)origPos.method_10263() + 0.5, (double)origPos.method_10264() + 0.5, (double)origPos.method_10260() + 0.5, this.tempBlockDroppedXp));
        }
        data.clearCache();
        NetworkManager.sendToPlayer((class_3222)player, (class_8710)SendShapePacket.adjustShapeAndBlockPos(data.getCurrentShapeIndex(), List.of()));
        return EventResult.interruptFalse();
    }

    private static boolean tryBreakBlock(class_3222 player, class_2338 pos, class_2680 state, Shape shape, class_3965 bhr) {
        for (BlockBreakHandler handler : BlockBreakingRegistry.INSTANCE.getHandlers()) {
            switch (handler.breakBlock((class_1657)player, pos, state, shape, bhr)) {
                case SUCCESS: {
                    return true;
                }
                case FAIL: {
                    return false;
                }
            }
        }
        return player.field_13974.method_14266(pos);
    }

    public EventResult blockRightClick(class_1657 player, class_1268 hand, class_2338 clickPos, class_2350 face) {
        class_3965 blockHitResult;
        FTBUltiminePlayerData data;
        class_3222 serverPlayer;
        block16: {
            block15: {
                block14: {
                    block13: {
                        if (PlayerHooks.isFake((class_1657)player) && CropLikeRegistry.checkForSingleCropHarvesting(player, clickPos)) {
                            return EventResult.interruptTrue();
                        }
                        if (!(player instanceof class_3222)) break block13;
                        serverPlayer = (class_3222)player;
                        if (!PlayerHooks.isFake((class_1657)player) && player.method_5667() != null) break block14;
                    }
                    return EventResult.pass();
                }
                data = this.getOrCreatePlayerData(player);
                if (!data.isPressed()) {
                    if (CropLikeRegistry.checkForSingleCropHarvesting(player, clickPos)) {
                        return EventResult.interruptTrue();
                    }
                    return EventResult.pass();
                }
                if (player.method_7344().method_7586() <= 0 && !player.method_7337()) {
                    return EventResult.pass();
                }
                class_239 result = FTBUltiminePlayerData.rayTrace(serverPlayer);
                if (!(result instanceof class_3965)) break block15;
                blockHitResult = (class_3965)result;
                if (result.method_17783() == class_239.class_240.field_1332) break block16;
            }
            return EventResult.pass();
        }
        data.clearCache();
        ShapeContext shapeContext = data.updateBlocks(serverPlayer, clickPos, blockHitResult.method_17780(), false, FTBUltimineServerConfig.getMaxBlocks(serverPlayer));
        if (shapeContext == null || !data.hasCachedPositions()) {
            return EventResult.pass();
        }
        int didWork = RightClickDispatcher.INSTANCE.dispatchRightClick(shapeContext, hand, data);
        if (didWork > 0) {
            player.method_6104(hand);
            if (!player.method_7337()) {
                CooldownTracker.setLastUltimineTime(player, System.currentTimeMillis());
                data.addPendingXPCost(serverPlayer, Math.max(0, didWork - 1));
            }
            return EventResult.interruptTrue();
        }
        return EventResult.pass();
    }

    public void playerTick(class_1657 player) {
        if (player instanceof class_3222) {
            class_3222 serverPlayer = (class_3222)player;
            FTBUltiminePlayerData data = this.getOrCreatePlayerData(player);
            data.checkBlocks(serverPlayer, true, FTBUltimineServerConfig.getMaxBlocks(serverPlayer));
            data.takePendingXP(serverPlayer);
        }
    }

    public EventResult entityJoinedWorld(class_1297 entity, class_1937 level) {
        if (entity.method_5805()) {
            if (this.isBreakingBlock && entity instanceof class_1542) {
                class_1542 item = (class_1542)entity;
                if (!item.method_6983().method_7960()) {
                    this.tempBlockDropsList.add(item.method_6983());
                    item.method_6979(class_1799.field_8037);
                }
                return EventResult.interruptFalse();
            }
            if (this.isBreakingBlock && entity instanceof class_1303) {
                class_1303 orb = (class_1303)entity;
                this.tempBlockDroppedXp += orb.method_5919();
                entity.method_5768();
                return EventResult.interruptFalse();
            }
        }
        return EventResult.pass();
    }

    static {
        LOGGER = LogManager.getLogger();
        DENY_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)FTBUltimineAPI.id("excluded_tools"));
        STRICT_DENY_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)FTBUltimineAPI.id("excluded_tools/strict"));
        ALLOW_TAG = class_6862.method_40092((class_5321)class_7924.field_41197, (class_2960)FTBUltimineAPI.id("included_tools"));
        EXCLUDED_BLOCKS = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)FTBUltimineAPI.id("excluded_blocks"));
        BLOCK_WHITELIST = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)FTBUltimineAPI.id("block_whitelist"));
        TILLABLE_TAG = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)FTBUltimineAPI.id("farmland_tillable"));
        FLATTENABLE_TAG = class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)FTBUltimineAPI.id("shovel_flattenable"));
        permissionOverride = player -> true;
    }

    private static class DataReloadListener
    implements class_4013 {
        private DataReloadListener() {
        }

        public void method_14491(class_3300 resourceManager) {
            BlockMatcher.TagCache.onReload();
        }
    }
}

