/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine;

import dev.architectury.networking.NetworkManager;
import dev.ftb.mods.ftbultimine.api.shape.Shape;
import dev.ftb.mods.ftbultimine.api.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.net.SendShapePacket;
import dev.ftb.mods.ftbultimine.shape.BlockMatchers;
import dev.ftb.mods.ftbultimine.shape.ShapeRegistry;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.UUID;
import net.minecraft.class_2168;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_239;
import net.minecraft.class_2680;
import net.minecraft.class_3222;
import net.minecraft.class_3965;
import net.minecraft.class_5134;
import net.minecraft.class_8710;
import org.jetbrains.annotations.Nullable;

public class FTBUltiminePlayerData {
    private final UUID playerId;
    private boolean pressed = false;
    private int shapeIndex = 0;
    private double pendingXPCost;
    private class_2338 cachedPos;
    private class_2350 cachedDirection;
    private List<class_2338> cachedBlocks;

    public FTBUltiminePlayerData(UUID playerId) {
        this.playerId = playerId;
    }

    public void clearCache() {
        this.cachedPos = null;
        this.cachedDirection = null;
        this.cachedBlocks = null;
    }

    public UUID getPlayerId() {
        return this.playerId;
    }

    public boolean isPressed() {
        return this.pressed;
    }

    public void setPressed(boolean pressed) {
        this.pressed = pressed;
    }

    public boolean hasCachedPositions() {
        return this.cachedBlocks != null && !this.cachedBlocks.isEmpty();
    }

    public Collection<class_2338> cachedPositions() {
        return this.cachedBlocks;
    }

    public static class_239 rayTrace(class_3222 player) {
        double distance = player.method_45325(class_5134.field_47758);
        return player.method_5745(player.method_7337() ? distance + 0.5 : distance, 1.0f, false);
    }

    public Shape getCurrentShape() {
        return ShapeRegistry.INSTANCE.getShape(this.shapeIndex);
    }

    public int getCurrentShapeIndex() {
        return this.shapeIndex;
    }

    public void cycleShape(boolean next) {
        int nShapes = ShapeRegistry.INSTANCE.shapeCount();
        if (next) {
            if (++this.shapeIndex >= nShapes) {
                this.shapeIndex = 0;
            }
        } else if (--this.shapeIndex < 0) {
            this.shapeIndex = nShapes - 1;
        }
    }

    public void addPendingXPCost(class_3222 player, int blockCount) {
        this.pendingXPCost += (double)blockCount * FTBUltimineServerConfig.getExperiencePerBlock(player);
    }

    public void takePendingXP(class_3222 player) {
        if (this.pendingXPCost > 1.0) {
            int toTake = (int)this.pendingXPCost;
            String cmd = String.format("experience add @s -%d points", toTake);
            class_2168 source = player.method_5671().method_9217();
            player.method_5682().method_3734().method_44252(source, cmd);
            this.pendingXPCost -= (double)toTake;
        }
    }

    public void checkBlocks(class_3222 player, boolean sendUpdate, int maxBlocks) {
        class_3965 hitResult;
        block8: {
            block7: {
                if (!this.pressed) {
                    return;
                }
                class_239 result = FTBUltiminePlayerData.rayTrace(player);
                if (!(result instanceof class_3965)) break block7;
                hitResult = (class_3965)result;
                if (result.method_17783() == class_239.class_240.field_1332) break block8;
            }
            if (this.cachedBlocks != null && !this.cachedBlocks.isEmpty()) {
                this.clearCache();
                if (sendUpdate) {
                    NetworkManager.sendToPlayer((class_3222)player, (class_8710)SendShapePacket.adjustShapeAndBlockPos(this.getCurrentShapeIndex(), Collections.emptyList()));
                }
            }
            return;
        }
        if (this.cachedDirection != hitResult.method_17780() || this.cachedPos == null || !this.cachedPos.equals((Object)hitResult.method_17777())) {
            this.updateBlocks(player, hitResult.method_17777(), hitResult.method_17780(), sendUpdate, maxBlocks);
        }
    }

    @Nullable
    public ShapeContext updateBlocks(class_3222 player, class_2338 pos, class_2350 dir, boolean sendUpdate, int maxBlocks) {
        ShapeContext context = null;
        this.cachedPos = pos.method_10062();
        this.cachedDirection = dir;
        Shape shape = this.getCurrentShape();
        if (maxBlocks <= 0) {
            this.cachedBlocks = Collections.emptyList();
        } else {
            int max;
            class_2680 origState = player.method_37908().method_8320(this.cachedPos);
            ShapeContext.Matcher matcher = BlockMatchers.determineBestMatcher(player.method_37908(), this.cachedPos, origState, shape);
            context = new ShapeContext(player, this.cachedPos, this.cachedDirection, origState, matcher, maxBlocks);
            this.cachedBlocks = shape.getBlocks(context);
            if (FTBUltimineServerConfig.getExperiencePerBlock(player) > 0.0 && (max = (int)((double)player.field_7495 / FTBUltimineServerConfig.getExperiencePerBlock(player))) < this.cachedBlocks.size()) {
                this.cachedBlocks = this.cachedBlocks.subList(0, max);
            }
        }
        if (sendUpdate) {
            NetworkManager.sendToPlayer((class_3222)player, (class_8710)SendShapePacket.adjustShapeAndBlockPos(this.getCurrentShapeIndex(), this.cachedBlocks));
        }
        return context;
    }
}

