/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.client;

import com.google.common.collect.ImmutableList;
import com.mojang.blaze3d.platform.GlStateManager;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.architectury.event.EventResult;
import dev.architectury.event.events.client.ClientGuiEvent;
import dev.architectury.event.events.client.ClientRawInputEvent;
import dev.architectury.event.events.client.ClientTickEvent;
import dev.architectury.networking.NetworkManager;
import dev.architectury.registry.client.keymappings.KeyMappingRegistry;
import dev.ftb.mods.ftblibrary.icon.Color4I;
import dev.ftb.mods.ftblibrary.ui.GuiHelper;
import dev.ftb.mods.ftblibrary.util.PanelPositioning;
import dev.ftb.mods.ftbultimine.CooldownTracker;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.FTBUltimineCommon;
import dev.ftb.mods.ftbultimine.client.CachedEdge;
import dev.ftb.mods.ftbultimine.client.PlatformUtil;
import dev.ftb.mods.ftbultimine.client.UltimineRenderTypes;
import dev.ftb.mods.ftbultimine.config.FTBUltimineClientConfig;
import dev.ftb.mods.ftbultimine.event.LevelRenderLastEvent;
import dev.ftb.mods.ftbultimine.net.KeyPressedPacket;
import dev.ftb.mods.ftbultimine.net.ModeChangedPacket;
import dev.ftb.mods.ftbultimine.shape.ShapeRegistry;
import dev.ftb.mods.ftbultimine.utils.ShapeMerger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Objects;
import net.minecraft.class_124;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_238;
import net.minecraft.class_243;
import net.minecraft.class_247;
import net.minecraft.class_2561;
import net.minecraft.class_259;
import net.minecraft.class_265;
import net.minecraft.class_304;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3675;
import net.minecraft.class_4184;
import net.minecraft.class_437;
import net.minecraft.class_4587;
import net.minecraft.class_4588;
import net.minecraft.class_5250;
import net.minecraft.class_5251;
import net.minecraft.class_5348;
import net.minecraft.class_5481;
import net.minecraft.class_8710;
import net.minecraft.class_9779;
import org.joml.Matrix4f;

public class FTBUltimineClient
extends FTBUltimineCommon {
    public static class_304 keyBindUltimine;
    public static class_304 keyBindNextMode;
    public static class_304 keyBindPrevMode;
    private boolean pressed;
    private boolean canUltimine;
    private List<class_2338> shapeBlocks = Collections.emptyList();
    private int actualBlocks = 0;
    private List<CachedEdge> cachedEdges = null;
    private class_2338 cachedPos = null;
    public boolean hasScrolledYet = false;
    private long lastToggle = 0L;
    public final int INPUT_DELAY = 125;
    private int shapeIdx = 0;
    private int maxPanelWidth = 100;
    private List<IndentedLine> infoPanelList = List.of();

    public FTBUltimineClient() {
        keyBindUltimine = new class_304("key.ftbultimine", class_3675.class_307.field_1668, 96, "key.categories.ftbultimine");
        KeyMappingRegistry.register((class_304)keyBindUltimine);
        keyBindNextMode = new class_304("ftbultimine.change_shape.next", class_3675.class_307.field_1668, 265, "key.categories.ftbultimine");
        KeyMappingRegistry.register((class_304)keyBindNextMode);
        keyBindPrevMode = new class_304("ftbultimine.change_shape.prev", class_3675.class_307.field_1668, 264, "key.categories.ftbultimine");
        KeyMappingRegistry.register((class_304)keyBindPrevMode);
        ClientTickEvent.CLIENT_PRE.register(this::clientTick);
        ClientGuiEvent.RENDER_HUD.register(this::renderGameOverlay);
        LevelRenderLastEvent.EVENT.register(this::renderInGame);
        ClientRawInputEvent.MOUSE_SCROLLED.register(this::onMouseScrolled);
        ClientRawInputEvent.KEY_PRESSED.register(this::onKeyPress);
    }

    public static class_1657 getClientPlayer() {
        return class_310.method_1551().field_1724;
    }

    @Override
    public void setShape(int shapeIdx, List<class_2338> blocks) {
        this.shapeIdx = shapeIdx;
        if (blocks != null) {
            this.actualBlocks = blocks.size();
            int maxRendered = Math.min(this.actualBlocks, (Integer)FTBUltimineClientConfig.RENDER_OUTLINE.get());
            this.shapeBlocks = blocks.subList(0, maxRendered);
            this.cachedEdges = null;
            this.updateEdges();
        }
        if (!this.pressed) {
            class_310.method_1551().field_1724.method_7353((class_2561)class_2561.method_43471((String)"key.ftbultimine").method_27693(" : ").method_10852((class_2561)ShapeRegistry.INSTANCE.getShape(shapeIdx).getDisplayName()), true);
        }
    }

    public void renderInGame(class_4587 stack) {
        if (!this.pressed || this.cachedPos == null || this.cachedEdges == null || this.cachedEdges.isEmpty()) {
            return;
        }
        class_310 mc = class_310.method_1551();
        if (!this.canUltimine) {
            return;
        }
        class_4184 activeRenderInfo = mc.method_1561().field_4686;
        class_243 projectedView = activeRenderInfo.method_19326();
        stack.method_22903();
        stack.method_22904((double)this.cachedPos.method_10263() - projectedView.field_1352, (double)this.cachedPos.method_10264() - projectedView.field_1351, (double)this.cachedPos.method_10260() - projectedView.field_1350);
        Matrix4f matrix = stack.method_23760().method_23761();
        class_4588 buffer = mc.method_22940().method_23000().getBuffer(UltimineRenderTypes.LINES_NORMAL);
        for (CachedEdge edge : this.cachedEdges) {
            buffer.method_22918(matrix, edge.x1, edge.y1, edge.z1).method_1336(255, 255, 255, 255);
            buffer.method_22918(matrix, edge.x2, edge.y2, edge.z2).method_1336(255, 255, 255, 255);
        }
        mc.method_22940().method_23000().method_22994(UltimineRenderTypes.LINES_NORMAL);
        class_4588 buffer2 = mc.method_22940().method_23000().getBuffer(UltimineRenderTypes.LINES_TRANSPARENT);
        int alpha = (Integer)FTBUltimineClientConfig.PREVIEW_LINE_ALPHA.get();
        for (CachedEdge edge : this.cachedEdges) {
            buffer2.method_22918(matrix, edge.x1, edge.y1, edge.z1).method_1336(255, 255, 255, alpha);
            buffer2.method_22918(matrix, edge.x2, edge.y2, edge.z2).method_1336(255, 255, 255, alpha);
        }
        mc.method_22940().method_23000().method_22994(UltimineRenderTypes.LINES_TRANSPARENT);
        stack.method_22909();
    }

    public EventResult onMouseScrolled(class_310 client, double amountX, double amountY) {
        if (this.pressed && (amountY != 0.0 || amountX != 0.0) && this.isMenuSneaking()) {
            NetworkManager.sendToServer((class_8710)new ModeChangedPacket(amountX < 0.0 || amountY < 0.0));
            this.hasScrolledYet = true;
            return EventResult.interruptFalse();
        }
        return EventResult.pass();
    }

    public EventResult onKeyPress(class_310 client, int keyCode, int scanCode, int action, int modifiers) {
        boolean nextMode;
        if (System.currentTimeMillis() - this.lastToggle < 125L) {
            return EventResult.pass();
        }
        if (PlatformUtil.doesKeybindMatch(keyBindPrevMode, keyCode, scanCode, modifiers)) {
            nextMode = false;
        } else if (PlatformUtil.doesKeybindMatch(keyBindNextMode, keyCode, scanCode, modifiers)) {
            nextMode = true;
        } else {
            return EventResult.pass();
        }
        if ((this.pressed || !((Boolean)FTBUltimineClientConfig.REQUIRE_ULTIMINE_KEY_FOR_CYCLING.get()).booleanValue()) && this.isMenuSneaking()) {
            NetworkManager.sendToServer((class_8710)new ModeChangedPacket(nextMode));
            this.lastToggle = System.currentTimeMillis();
            this.hasScrolledYet = true;
        }
        return EventResult.pass();
    }

    private boolean isMenuSneaking() {
        if (!((Boolean)FTBUltimineClientConfig.REQUIRE_SNEAK_FOR_MENU.get()).booleanValue()) {
            return true;
        }
        return keyBindUltimine.method_1417(340, 0) || keyBindUltimine.method_1417(344, 0) ? class_437.method_25441() : class_437.method_25442();
    }

    private List<IndentedLine> addPressedInfo() {
        int i;
        ImmutableList.Builder builder = ImmutableList.builder();
        class_5250 msg = CooldownTracker.isOnCooldown(FTBUltimineClient.getClientPlayer()) ? class_2561.method_43471((String)"ftbultimine.info.cooldown").method_27694(style -> style.method_27703(class_5251.method_27717((int)12566412))) : (this.canUltimine && this.actualBlocks > 0 ? class_2561.method_43471((String)"ftbultimine.info.active").method_27694(style -> style.method_27703(class_5251.method_27717((int)10731148))) : class_2561.method_43471((String)"ftbultimine.info.not_active").method_27694(style -> style.method_27703(class_5251.method_27717((int)12542314))));
        builder.add((Object)new IndentedLine(0, (class_2561)class_2561.method_43469((String)"ftbultimine.info.base", (Object[])new Object[]{msg})));
        ShapeRegistry shapeRegistry = ShapeRegistry.INSTANCE;
        int context = Math.min((shapeRegistry.shapeCount() - 1) / 2, (Integer)FTBUltimineClientConfig.SHAPE_MENU_CONTEXT_LINES.get());
        boolean showingMenu = this.isMenuSneaking();
        if (showingMenu) {
            builder.add((Object)new IndentedLine(0, (class_2561)class_2561.method_43473()));
            for (i = -context; i < 0; ++i) {
                builder.add((Object)new IndentedLine(16, (class_2561)shapeRegistry.getShape(this.shapeIdx + i).getDisplayName().method_27692(class_124.field_1080)));
            }
        } else {
            builder.add((Object)new IndentedLine(0, (class_2561)class_2561.method_43471((String)"ftbultimine.change_shape.short").method_27695(new class_124[]{class_124.field_1080, class_124.field_1056})));
            builder.add((Object)new IndentedLine(0, (class_2561)class_2561.method_43473()));
        }
        builder.add((Object)new IndentedLine(showingMenu ? 16 : 0, (class_2561)shapeRegistry.getShape(this.shapeIdx).getDisplayName().method_27692(class_124.field_1054)));
        if (showingMenu) {
            for (i = 1; i <= context; ++i) {
                builder.add((Object)new IndentedLine(16, (class_2561)shapeRegistry.getShape(this.shapeIdx + i).getDisplayName().method_27692(class_124.field_1080)));
            }
        }
        if (this.canUltimine && this.actualBlocks != 0) {
            class_5250 mining = class_2561.method_43473();
            mining.method_10852((class_2561)class_2561.method_43469((String)"ftbultimine.info.blocks", (Object[])new Object[]{this.actualBlocks}));
            if (this.actualBlocks > this.shapeBlocks.size()) {
                mining.method_27693(", ").method_10852((class_2561)class_2561.method_43469((String)"ftbultimine.info.partial_render", (Object[])new Object[]{this.shapeBlocks.size()}));
            }
            builder.add((Object)new IndentedLine(0, (class_2561)class_2561.method_43473()));
            builder.add((Object)new IndentedLine(0, (class_2561)mining.method_54663(10731148)));
        }
        return builder.build();
    }

    public void renderGameOverlay(class_332 graphics, class_9779 tickDelta) {
        if (this.pressed) {
            int width;
            class_310 mc = class_310.method_1551();
            RenderSystem.enableBlend();
            RenderSystem.blendFuncSeparate((GlStateManager.class_4535)GlStateManager.class_4535.SRC_ALPHA, (GlStateManager.class_4534)GlStateManager.class_4534.ONE_MINUS_SRC_ALPHA, (GlStateManager.class_4535)GlStateManager.class_4535.ONE, (GlStateManager.class_4534)GlStateManager.class_4534.ZERO);
            class_327 font = mc.field_1772;
            this.maxPanelWidth = width = Math.max(this.maxPanelWidth, 10 + this.infoPanelList.stream().map(l -> font.method_27525((class_5348)l.text)).max(Integer::compareTo).orElse(100));
            Objects.requireNonNull(font);
            int height = 9 * this.infoPanelList.size();
            float scale = 1.0f;
            int insetX = (Integer)FTBUltimineClientConfig.OVERLAY_INSET_X.get();
            int insetY = (Integer)FTBUltimineClientConfig.OVERLAY_INSET_Y.get();
            PanelPositioning.PanelPos pos = ((PanelPositioning)FTBUltimineClientConfig.OVERLAY_POS.get()).getPanelPos(mc.method_22683().method_4486(), mc.method_22683().method_4502(), (int)((float)width * scale), (int)((float)height * scale), insetX, insetY);
            graphics.method_51448().method_22903();
            graphics.method_51448().method_46416((float)pos.x(), (float)pos.y(), 100.0f);
            graphics.method_51448().method_22905(scale, scale, 1.0f);
            Color4I.DARK_GRAY.withAlpha(128).draw(graphics, -2, -2, width + 4, height + 4);
            GuiHelper.drawHollowRect((class_332)graphics, (int)-2, (int)-2, (int)(width + 4), (int)(height + 4), (Color4I)Color4I.GRAY.withAlpha(128), (boolean)false);
            float f = CooldownTracker.getCooldownRemaining(FTBUltimineClient.getClientPlayer());
            if (f < 1.0f) {
                Color4I color4I = Color4I.rgba((int)-1438605248);
                int n = (int)((float)width * f) + 1;
                Objects.requireNonNull(font);
                color4I.draw(graphics, 0, 0, n, 9 + 1);
            }
            if (this.isMenuSneaking()) {
                Objects.requireNonNull(font);
                int barUpper = 9 * 2;
                Objects.requireNonNull(font);
                int barHeight = 9 * (ShapeRegistry.INSTANCE.shapeCount() - 1) - 2;
                Color4I col = Color4I.WHITE.withAlpha(192);
                col.draw(graphics, 3, barUpper, 2, barHeight);
                col.draw(graphics, 2, barUpper + 1, 4, 1);
                col.draw(graphics, 1, barUpper + 2, 6, 1);
                col.draw(graphics, 2, barUpper + barHeight - 2, 4, 1);
                col.draw(graphics, 1, barUpper + barHeight - 3, 6, 1);
            }
            int top = 0;
            for (IndentedLine line : this.infoPanelList) {
                class_5481 formatted = line.text.method_30937();
                graphics.method_51430(font, formatted, line.indent, top, 15527924, true);
                Objects.requireNonNull(font);
                top += 9;
            }
            graphics.method_51448().method_22909();
        }
    }

    public void clientTick(class_310 mc) {
        if (class_310.method_1551().field_1724 == null) {
            return;
        }
        boolean p = this.pressed;
        this.pressed = keyBindUltimine.method_1434();
        if (this.pressed != p) {
            NetworkManager.sendToServer((class_8710)new KeyPressedPacket(this.pressed));
            if (this.pressed && !this.hasScrolledYet && mc.field_1724 != null) {
                class_5250 msg1 = class_2561.method_43471((String)((Boolean)FTBUltimineClientConfig.REQUIRE_SNEAK_FOR_MENU.get() != false ? "ftbultimine.change_shape" : "ftbultimine.change_shape.no_shift"));
                mc.field_1724.method_7353((class_2561)msg1, true);
            }
        }
        boolean bl = this.canUltimine = this.pressed && FTBUltimine.instance.canUltimine((class_1657)mc.field_1724);
        if (this.pressed) {
            this.infoPanelList = this.addPressedInfo();
        }
    }

    private void updateEdges() {
        if (this.cachedEdges != null) {
            return;
        }
        if (this.shapeBlocks.isEmpty()) {
            this.cachedEdges = Collections.emptyList();
            return;
        }
        this.cachedPos = this.shapeBlocks.getFirst();
        double d = 0.005;
        this.cachedEdges = new ArrayList<CachedEdge>();
        HashSet<class_265> shapes = new HashSet<class_265>();
        for (class_238 aabb : ShapeMerger.merge(this.shapeBlocks, this.cachedPos)) {
            shapes.add(class_259.method_1078((class_238)aabb.method_1014(d)));
        }
        FTBUltimineClient.orShapes(shapes).method_1104((x1, y1, z1, x2, y2, z2) -> {
            CachedEdge edge = new CachedEdge();
            edge.x1 = (float)x1;
            edge.y1 = (float)y1;
            edge.z1 = (float)z1;
            edge.x2 = (float)x2;
            edge.y2 = (float)y2;
            edge.z2 = (float)z2;
            this.cachedEdges.add(edge);
        });
    }

    static class_265 orShapes(Collection<class_265> shapes) {
        class_265 combinedShape = class_259.method_1073();
        for (class_265 shape : shapes) {
            combinedShape = class_259.method_1082((class_265)combinedShape, (class_265)shape, (class_247)class_247.field_1366);
        }
        return combinedShape;
    }

    private record IndentedLine(int indent, class_2561 text) {
    }
}

