/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.config;

import dev.architectury.utils.GameInstance;
import dev.ftb.mods.ftblibrary.snbt.config.BooleanValue;
import dev.ftb.mods.ftblibrary.snbt.config.DoubleValue;
import dev.ftb.mods.ftblibrary.snbt.config.IntValue;
import dev.ftb.mods.ftblibrary.snbt.config.LongValue;
import dev.ftb.mods.ftblibrary.snbt.config.SNBTConfig;
import dev.ftb.mods.ftblibrary.snbt.config.StringListValue;
import dev.ftb.mods.ftblibrary.util.NetworkHelper;
import dev.ftb.mods.ftbultimine.FTBUltimine;
import dev.ftb.mods.ftbultimine.integration.IntegrationHandler;
import dev.ftb.mods.ftbultimine.integration.ranks.FTBRanksIntegration;
import dev.ftb.mods.ftbultimine.net.SyncUltimineTimePacket;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.regex.Pattern;
import net.minecraft.class_2248;
import net.minecraft.class_2343;
import net.minecraft.class_2404;
import net.minecraft.class_2680;
import net.minecraft.class_2960;
import net.minecraft.class_3222;
import net.minecraft.class_5321;
import net.minecraft.class_6862;
import net.minecraft.class_7923;
import net.minecraft.class_7924;
import net.minecraft.class_8710;

public interface FTBUltimineServerConfig {
    public static final String KEY = "ftbultimine-server";
    public static final SNBTConfig CONFIG = (SNBTConfig)SNBTConfig.create((String)"ftbultimine-server").comment(new String[]{"Server-specific configuration for FTB Ultimine", "Modpack defaults should be defined in <instance>/config/ftbultimine-server.snbt", "  (may be overwritten on modpack update)", "Server admins may locally override this by copying into <instance>/world/serverconfig/ftbultimine-server.snbt", "  (will NOT be overwritten on modpack update)"});
    public static final SNBTConfig FEATURES = CONFIG.addGroup("features");
    public static final BooleanValue RIGHT_CLICK_AXE = (BooleanValue)FEATURES.addBoolean("right_click_axe", true).comment(new String[]{"Right-click with an axe with the Ultimine key held to strip multiple logs and scrape/unwax copper blocks"});
    public static final BooleanValue RIGHT_CLICK_SHOVEL = (BooleanValue)FEATURES.addBoolean("right_click_shovel", true).comment(new String[]{"Right-click with a shovel with the Ultimine key held to flatten multiple grass/dirt blocks into dirt paths"});
    public static final BooleanValue RIGHT_CLICK_HOE = (BooleanValue)FEATURES.addBoolean("right_click_hoe", true).comment(new String[]{"Right-click with a hoe with the Ultimine key held to till multiple grass/dirt blocks into farmland"});
    public static final BooleanValue RIGHT_CLICK_HARVESTING = (BooleanValue)FEATURES.addBoolean("right_click_harvesting", true).comment(new String[]{"Right-click crops with the Ultimine key held to harvest multiple crop blocks"});
    public static final BooleanValue RIGHT_CLICK_CRYSTALS = (BooleanValue)FEATURES.addBoolean("right_click_crystals", true).comment(new String[]{"Right-click budding crystals (e.g. amethyst, AE2 certus) with the Ultimine key held to harvest multiple crystals", "FTB EZ Crystals must also be installed"});
    public static final BooleanValue SINGLE_CROP_HARVESTING = (BooleanValue)FEATURES.addBoolean("single_crop_harvesting", true).comment(new String[]{"When true, right-clicking a crop block without the Ultimine key held harvests it"});
    public static final SNBTConfig COSTS_LIMITS = CONFIG.addGroup("costs_limits");
    public static final IntValue MAX_BLOCKS = (IntValue)COSTS_LIMITS.addInt("max_blocks", 64).range(32768).comment(new String[]{"Max amount of blocks that can be ultimined at once"});
    public static final DoubleValue EXHAUSTION_PER_BLOCK = (DoubleValue)COSTS_LIMITS.addDouble("exhaustion_per_block", 20.0).range(10000.0).comment(new String[]{"Hunger multiplier for each block ultimined (fractional values allowed)"});
    public static final DoubleValue EXPERIENCE_PER_BLOCK = (DoubleValue)COSTS_LIMITS.addDouble("experience_per_block", 0.0).range(20000.0).comment(new String[]{"Amount of experience taken per block ultimined (fractional values allowed)"});
    public static final BooleanValue REQUIRE_TOOL = (BooleanValue)COSTS_LIMITS.addBoolean("require_tool", false).comment(new String[]{"Require a damageable tool, or an item in the 'ftbultimine:tools' tag, to ultimine."});
    public static final LongValue ULTIMINE_COOLDOWN = (LongValue)COSTS_LIMITS.addLong("ultimine_cooldown", 0L, 0L, Long.MAX_VALUE).comment(new String[]{"Cooldown in ticks between successive uses of the Ultimine feature"});
    public static final SNBTConfig MISC = CONFIG.addGroup("misc");
    public static final BlockTagsConfig MERGE_TAGS_SHAPELESS = new BlockTagsConfig(MISC, "merge_tags", new ArrayList<String>(List.of("minecraft:base_stone_overworld", "c:ores/*", "forge:ores/*")), "These tags will be considered the same block when checking for blocks to Ultimine in shapeless mining mode");
    public static final BlockTagsConfig MERGE_TAGS_SHAPED = new BlockTagsConfig(MISC, "merge_tags_shaped", new ArrayList<String>(List.of("*")), "These tags will be considered the same block when checking for blocks to Ultimine in shaped mining modes");
    public static final IntValue PREVENT_TOOL_BREAK = (IntValue)MISC.addInt("prevent_tool_break", 0, 0, 100).comment(new String[]{"This will stop mining if tool reaches X durability. It's possible this won't work with some modded tools if they use non-standard durability handling."});
    public static final BooleanValue CANCEL_ON_BLOCK_BREAK_FAIL = (BooleanValue)MISC.addBoolean("cancel_on_block_break_fail", false).comment(new String[]{"If a block couldn't be broken (even though it should be), stop ultimining immediately instead of skipping to the next block."});

    public static void onConfigChanged(boolean isServerSide) {
        if (isServerSide) {
            FTBUltimineServerConfig.MERGE_TAGS_SHAPELESS.tags = null;
            FTBUltimineServerConfig.MERGE_TAGS_SHAPED.tags = null;
            if ((Integer)MAX_BLOCKS.get() > 8192) {
                FTBUltimine.LOGGER.warn("'max_blocks' server config setting is set to more than 8192 blocks; this may cause performance issues!");
            }
            if (GameInstance.getServer() != null) {
                GameInstance.getServer().method_3760().method_14571().forEach(sp -> NetworkHelper.sendTo((class_3222)sp, (class_8710)new SyncUltimineTimePacket(FTBUltimineServerConfig.getUltimineCooldown(sp), SyncUltimineTimePacket.TimeType.COOLDOWN)));
            }
        }
    }

    public static int getMaxBlocks(class_3222 player) {
        return IntegrationHandler.ranksMod ? FTBRanksIntegration.getMaxBlocks(player) : (Integer)MAX_BLOCKS.get();
    }

    public static long getUltimineCooldown(class_3222 player) {
        return IntegrationHandler.ranksMod ? FTBRanksIntegration.getUltimineCooldown(player) : (Long)ULTIMINE_COOLDOWN.get();
    }

    public static double getExperiencePerBlock(class_3222 player) {
        return IntegrationHandler.ranksMod ? FTBRanksIntegration.getExperiencePerBlock(player) : (Double)EXPERIENCE_PER_BLOCK.get();
    }

    public static double getExhaustionPerBlock(class_3222 player) {
        return IntegrationHandler.ranksMod ? FTBRanksIntegration.getExhaustionPerBlock(player) : (Double)EXHAUSTION_PER_BLOCK.get();
    }

    public static class BlockTagsConfig {
        private final StringListValue value;
        private Set<class_6862<class_2248>> tags = null;
        private boolean matchAny = false;

        public BlockTagsConfig(SNBTConfig parent, String name, List<String> defaults, String ... comment) {
            this.value = (StringListValue)parent.addStringList(name, defaults).comment(comment);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public boolean match(class_2680 original, class_2680 toTest) {
            Collection<class_6862<class_2248>> tags = this.getTags();
            if (this.matchAny && !toTest.method_26215() && !(toTest.method_26204() instanceof class_2404)) {
                if (!(original.method_26204() instanceof class_2343)) return true;
            }
            if (!tags.stream().filter(arg_0 -> ((class_2680)original).method_26164(arg_0)).anyMatch(arg_0 -> ((class_2680)toTest).method_26164(arg_0))) return false;
            return true;
        }

        public Collection<class_6862<class_2248>> getTags() {
            if (this.tags == null) {
                if (((List)this.value.get()).contains("*")) {
                    this.matchAny = true;
                    this.tags = Collections.emptySet();
                } else {
                    this.tags = new HashSet<class_6862<class_2248>>();
                    ((List)this.value.get()).forEach(s -> {
                        class_2960 rl = class_2960.method_12829((String)s);
                        if (rl != null) {
                            this.tags.add((class_6862<class_2248>)class_6862.method_40092((class_5321)class_7924.field_41254, (class_2960)rl));
                        } else {
                            Pattern pattern = BlockTagsConfig.regexFromGlobString(s);
                            class_7923.field_41175.method_40272().forEach(tag -> {
                                if (pattern.asPredicate().test(((class_6862)tag.getFirst()).comp_327().toString())) {
                                    this.tags.add((class_6862<class_2248>)((class_6862)tag.getFirst()));
                                }
                            });
                        }
                    });
                }
            }
            return this.tags;
        }

        private static Pattern regexFromGlobString(String glob) {
            StringBuilder sb = new StringBuilder();
            sb.append("^");
            for (int i = 0; i < glob.length(); ++i) {
                char c = glob.charAt(i);
                if (c == '*') {
                    sb.append(".*");
                    continue;
                }
                if (c == '?') {
                    sb.append(".");
                    continue;
                }
                if (c == '.') {
                    sb.append("\\.");
                    continue;
                }
                if (c == '\\') {
                    sb.append("\\\\");
                    continue;
                }
                sb.append(c);
            }
            sb.append("$");
            return Pattern.compile(sb.toString());
        }
    }
}

