/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.crops;

import dev.ftb.mods.ftbultimine.api.crop.CropLikeHandler;
import dev.ftb.mods.ftbultimine.api.crop.RegisterCropLikeEvent;
import dev.ftb.mods.ftbultimine.api.util.ItemCollector;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public enum CropLikeRegistry implements RegisterCropLikeEvent.Dispatcher
{
    INSTANCE;

    private final Set<CropLikeHandler> handlers = ConcurrentHashMap.newKeySet();

    public static CropLikeRegistry getInstance() {
        return INSTANCE;
    }

    @Override
    public void registerHandler(CropLikeHandler handler) {
        this.handlers.add(handler);
    }

    public Optional<CropLikeHandler> getHandlerFor(class_1937 level, class_2338 pos, class_2680 state) {
        return this.handlers.stream().filter(h -> h.isApplicable(level, pos, state)).findFirst();
    }

    public boolean areStatesEquivalent(class_2680 original, class_2680 state) {
        return this.handlers.stream().anyMatch(h -> h.isEquivalent(original, state));
    }

    public void clear() {
        this.handlers.clear();
    }

    public static boolean checkForSingleCropHarvesting(class_1657 player, class_2338 clickPos) {
        if (((Boolean)FTBUltimineServerConfig.SINGLE_CROP_HARVESTING.get()).booleanValue()) {
            class_2680 state = player.method_37908().method_8320(clickPos);
            Optional<CropLikeHandler> cropHandler = CropLikeRegistry.getInstance().getHandlerFor(player.method_37908(), clickPos, state);
            if (cropHandler.isPresent()) {
                ItemCollector collector = new ItemCollector();
                if (cropHandler.get().doHarvesting(player, clickPos, state, collector)) {
                    collector.drop(player.method_37908(), clickPos);
                    return true;
                }
            }
        }
        return false;
    }
}

