/*
 * Decompiled with CFR 0.152.
 */
package dev.ftb.mods.ftbultimine.shape;

import dev.ftb.mods.ftbultimine.api.shape.Shape;
import dev.ftb.mods.ftbultimine.api.shape.ShapeContext;
import dev.ftb.mods.ftbultimine.config.FTBUltimineServerConfig;
import dev.ftb.mods.ftbultimine.crops.CropLikeRegistry;
import dev.ftb.mods.ftbultimine.crops.VanillaCropLikeHandler;
import dev.ftb.mods.ftbultimine.shape.BlockMatcher;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2680;

public interface BlockMatchers {
    public static final ShapeContext.Matcher MATCH_BY_BLOCK = BlockMatcher.wrap((original, state) -> original.method_26204() == state.method_26204());
    public static final ShapeContext.Matcher MATCH_BY_TAGS_SHAPELESS = BlockMatcher.wrap(FTBUltimineServerConfig.MERGE_TAGS_SHAPELESS::match);
    public static final ShapeContext.Matcher MATCH_BY_TAGS_SHAPED = BlockMatcher.wrap(FTBUltimineServerConfig.MERGE_TAGS_SHAPED::match);
    public static final ShapeContext.Matcher MATCH_BY_CROP_TYPE = BlockMatcher.wrap((original, state) -> VanillaCropLikeHandler.equivalentForSelection(original, state) || CropLikeRegistry.getInstance().areStatesEquivalent(original, state));

    public static ShapeContext.Matcher determineBestMatcher(class_1937 level, class_2338 pos, class_2680 origState, Shape shape) {
        ShapeContext.Matcher tagMatcher;
        ShapeContext.Matcher matcher = tagMatcher = shape.isIndeterminateShape() ? MATCH_BY_TAGS_SHAPELESS : MATCH_BY_TAGS_SHAPED;
        if (tagMatcher.check(origState, origState)) {
            return tagMatcher;
        }
        if (VanillaCropLikeHandler.looksLikeACrop(origState) || CropLikeRegistry.getInstance().getHandlerFor(level, pos, origState).isPresent()) {
            return MATCH_BY_CROP_TYPE;
        }
        return MATCH_BY_BLOCK;
    }
}

