/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.helper;

import com.mojang.blaze3d.systems.RenderSystem;
import java.util.Objects;
import net.minecraft.class_1799;
import net.minecraft.class_241;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_332;
import net.minecraft.class_4587;
import net.minecraft.class_5253;
import net.minecraft.class_5348;
import net.minecraft.class_640;
import nx.pingwheel.common.ClientGlobal;
import nx.pingwheel.common.helper.MathUtils;
import nx.pingwheel.common.resource.ResourceReloadListener;

public class DrawContext {
    private static final int WHITE = class_5253.class_5254.method_27764((int)255, (int)255, (int)255, (int)255);
    private static final int SHADOW_BLACK = class_5253.class_5254.method_27764((int)64, (int)0, (int)0, (int)0);
    private class_332 guiGraphics;
    private class_4587 matrices;

    public DrawContext(class_332 guiGraphics) {
        this.guiGraphics = guiGraphics;
        this.matrices = guiGraphics.method_51448();
    }

    public void renderLabel(class_2561 text, float yOffset, class_640 player) {
        int extraWidth = player != null ? 10 : 0;
        float f = ClientGlobal.Game.field_1772.method_27525((class_5348)text) + extraWidth;
        Objects.requireNonNull(ClientGlobal.Game.field_1772);
        class_241 textMetrics = new class_241(f, 9.0f);
        class_241 textOffset = textMetrics.method_35582(-0.5f).method_35586(new class_241(0.0f, textMetrics.field_1342 * yOffset));
        this.matrices.method_22903();
        this.matrices.method_46416(textOffset.field_1343, textOffset.field_1342, 0.0f);
        this.guiGraphics.method_25294(-2, -2, (int)textMetrics.field_1343 + 1, (int)textMetrics.field_1342, SHADOW_BLACK);
        this.guiGraphics.method_51439(ClientGlobal.Game.field_1772, text, extraWidth, 0, WHITE, false);
        if (player != null) {
            this.matrices.method_22904(-0.5, -0.5, 0.0);
            this.renderPlayerHead(player);
        }
        this.matrices.method_22909();
    }

    public void renderPlayerHead(class_640 player) {
        class_2960 texture = player.method_52810().comp_1626();
        RenderSystem.enableBlend();
        this.guiGraphics.method_25291(texture, 0, 0, 0, 8.0f, 8.0f, 8, 8, 64, 64);
        this.guiGraphics.method_25291(texture, 0, 0, 0, 40.0f, 8.0f, 8, 8, 64, 64);
        RenderSystem.disableBlend();
    }

    public void renderPing(class_1799 itemStack, boolean drawItemIcon) {
        if (itemStack != null && drawItemIcon) {
            this.renderGuiItemModel(itemStack);
        } else if (ResourceReloadListener.hasCustomTexture()) {
            this.renderTexture(ClientGlobal.PING_TEXTURE_ID, 12);
        } else {
            this.renderDefaultPingIcon();
        }
    }

    public void renderGuiItemModel(class_1799 itemStack) {
        this.guiGraphics.method_51429(itemStack, -8, -8, 0, -150);
    }

    public void renderDefaultPingIcon() {
        this.matrices.method_22903();
        MathUtils.rotateZ(this.matrices, 0.7853982f);
        this.matrices.method_22904(-2.5, -2.5, 0.0);
        this.guiGraphics.method_25294(0, 0, 5, 5, WHITE);
        this.matrices.method_22909();
    }

    public void renderTexture(class_2960 texture, int size) {
        int offset = size / -2;
        RenderSystem.enableBlend();
        this.guiGraphics.method_25291(texture, offset, offset, 0, 0.0f, 0.0f, size, size, size, size);
        RenderSystem.disableBlend();
    }

    public void renderArrowIcon() {
        this.renderTexture(ClientGlobal.ARROW_TEXTURE_ID, 10);
    }
}

