/*
 * Decompiled with CFR 0.152.
 */
package nx.pingwheel.common.helper;

import java.time.Duration;
import java.time.Instant;

public class RateLimiter {
    private static Duration timeToRegenerate;
    private static Duration timeWindow;
    private Instant startTime = Instant.now().minus(timeWindow).plus(timeToRegenerate);

    public static void setRates(long msToRegenerate, long limit) {
        timeToRegenerate = Duration.ofMillis(msToRegenerate);
        timeWindow = Duration.ofMillis(msToRegenerate * limit);
    }

    public boolean checkAndBlock() {
        Duration leftOver;
        Instant now = Instant.now();
        Duration elapsed = Duration.between(this.startTime, now);
        if (elapsed.compareTo(timeWindow) > 0) {
            elapsed = timeWindow;
        }
        if ((leftOver = elapsed.minus(timeToRegenerate)).isNegative()) {
            return true;
        }
        this.startTime = now.minus(leftOver);
        return false;
    }
}

