/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.config;

import dev.isxander.yacl3.api.ConfigCategory;
import dev.isxander.yacl3.api.Option;
import dev.isxander.yacl3.api.OptionDescription;
import dev.isxander.yacl3.api.YetAnotherConfigLib;
import dev.isxander.yacl3.api.controller.ColorControllerBuilder;
import dev.isxander.yacl3.api.controller.ControllerBuilder;
import dev.isxander.yacl3.api.controller.EnumControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.FloatSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerFieldControllerBuilder;
import dev.isxander.yacl3.api.controller.IntegerSliderControllerBuilder;
import dev.isxander.yacl3.api.controller.TickBoxControllerBuilder;
import dev.isxander.yacl3.api.controller.ValueFormatter;
import java.awt.Color;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.text.DecimalFormat;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Function;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.config.BridgingConfig;
import me.cg360.mod.bridging.config.helper.Category;
import me.cg360.mod.bridging.config.helper.ContinuousRange;
import me.cg360.mod.bridging.config.helper.DiscreteRange;
import me.cg360.mod.bridging.config.helper.HideInConfigUI;
import me.cg360.mod.bridging.config.helper.IncludeAnimatedImage;
import me.cg360.mod.bridging.config.helper.IncludeExtraDescription;
import me.cg360.mod.bridging.config.helper.IncludeImage;
import me.cg360.mod.bridging.config.helper.Translatable;
import me.cg360.mod.bridging.util.ReflectSupport;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_5250;

public class BridgingConfigUI {
    public static DecimalFormat FLOAT_FORMAT = new DecimalFormat("#.##");
    public static String DEFAULT_CATEGORY_NAME = "other".trim().toLowerCase();

    public static YetAnotherConfigLib buildConfig() {
        YetAnotherConfigLib.Builder builder = YetAnotherConfigLib.createBuilder();
        Map<String, List<Field>> sortedCategories = BridgingConfigUI.sortConfigIntoCategories(BridgingConfig.class);
        for (String categoryName : sortedCategories.keySet()) {
            List<Field> categoryOptions = sortedCategories.get(categoryName);
            ConfigCategory category = BridgingConfigUI.createCategory(categoryName, categoryOptions);
            builder.category(category);
        }
        return builder.title((class_2561)class_2561.method_43471((String)"config.bridgingmod.title")).save(() -> BridgingConfig.HANDLER.save()).screenInit(screen -> ((BridgingConfig)BridgingConfig.HANDLER.instance()).upgrade()).build();
    }

    private static <T> Optional<Option<T>> createOption(Field field, Function<Option<T>, ControllerBuilder<T>> controllerBuilder) {
        String id = field.getName();
        String nameTranslation = "config.bridgingmod.option.%s".formatted(id);
        BridgingConfig instance = (BridgingConfig)BridgingConfig.HANDLER.instance();
        Object defaultValue = instance.getDefaultForField(field).orElse(null);
        if (defaultValue == null) {
            BridgingMod.getLogger().error("Config field '%s' has no default value. Skipping.");
            return Optional.empty();
        }
        Object castedDefault = defaultValue;
        Option.Builder option = Option.createBuilder().name((class_2561)class_2561.method_43471((String)nameTranslation)).binding(castedDefault, () -> {
            try {
                field.setAccessible(true);
                Object val = field.get(instance);
                return val == null ? castedDefault : val;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }, val -> {
            try {
                field.setAccessible(true);
                field.set(instance, val);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }).controller(controllerBuilder);
        IncludeExtraDescription[] descriptionNotation = (IncludeExtraDescription[])field.getDeclaredAnnotationsByType(IncludeExtraDescription.class);
        IncludeImage[] imageNotation = (IncludeImage[])field.getDeclaredAnnotationsByType(IncludeImage.class);
        IncludeAnimatedImage[] animatedImageNotation = (IncludeAnimatedImage[])field.getDeclaredAnnotationsByType(IncludeAnimatedImage.class);
        OptionDescription.Builder desc = OptionDescription.createBuilder();
        String descTranslationKey = "config.bridgingmod.option.%s.description.%s".formatted(id, 0);
        class_5250 descTranslation = class_2561.method_48321((String)descTranslationKey, (String)"");
        desc.text(new class_2561[]{descTranslation});
        if (descriptionNotation.length > 0) {
            int extraParagraphs = Math.max(descriptionNotation[0].extraParagraphs(), 1);
            for (int i = 1; i < extraParagraphs + 1; ++i) {
                String extraDescriptionTranslationKey = "config.bridgingmod.option.%s.description.%s".formatted(id, i);
                class_5250 extraDescTranslation = class_2561.method_43471((String)extraDescriptionTranslationKey);
                desc.text(new class_2561[]{extraDescTranslation});
            }
        }
        if (imageNotation.length > 0) {
            IncludeImage imageAnnotation = imageNotation[0];
            class_2960 checkedPath = BridgingMod.id(imageAnnotation.value());
            int width = imageAnnotation.width();
            int height = imageAnnotation.height();
            desc.image(checkedPath, width, height);
        }
        if (animatedImageNotation.length > 0) {
            IncludeAnimatedImage imageAnnotation = animatedImageNotation[0];
            class_2960 checkedPath = BridgingMod.id(imageAnnotation.value());
            desc.webpImage(checkedPath);
        }
        return Optional.of(option.description(desc.build()).build());
    }

    private static ConfigCategory createCategory(String categoryName, List<Field> categoryOptions) {
        ConfigCategory.Builder category = ConfigCategory.createBuilder();
        String translatedName = "config.bridgingmod.category.%s".formatted(categoryName);
        String translatedTooltip = "config.bridgingmod.category.%s.tooltip".formatted(categoryName);
        category.name((class_2561)class_2561.method_43471((String)translatedName));
        category.tooltip(new class_2561[]{class_2561.method_48321((String)translatedTooltip, (String)"")});
        for (Field field : categoryOptions) {
            Optional<Option<Option>> optOption;
            Optional<Option<Option>> optOption2;
            ValueFormatter valFormatter;
            Annotation range;
            Annotation[] discreteRangeAnno;
            Optional<Option<Option>> optOption3;
            Class<?> type = ReflectSupport.boxPrimitive(field.getType());
            if (Boolean.class.isAssignableFrom(type)) {
                optOption3 = BridgingConfigUI.createOption(field, TickBoxControllerBuilder::create);
                optOption3.ifPresent(arg_0 -> ((ConfigCategory.Builder)category).option(arg_0));
                continue;
            }
            if (Integer.class.isAssignableFrom(type)) {
                discreteRangeAnno = (DiscreteRange[])field.getDeclaredAnnotationsByType(DiscreteRange.class);
                if (discreteRangeAnno.length > 0) {
                    range = discreteRangeAnno[0];
                    valFormatter = range.formatTranslationKey().isEmpty() ? val -> class_2561.method_43470((String)val.toString()) : arg_0 -> BridgingConfigUI.lambda$createCategory$4((DiscreteRange)range, arg_0);
                    optOption2 = BridgingConfigUI.createOption(field, arg_0 -> BridgingConfigUI.lambda$createCategory$5((DiscreteRange)range, valFormatter, arg_0));
                    optOption2.ifPresent(arg_0 -> ((ConfigCategory.Builder)category).option(arg_0));
                    continue;
                }
                optOption = BridgingConfigUI.createOption(field, IntegerFieldControllerBuilder::create);
                optOption.ifPresent(arg_0 -> ((ConfigCategory.Builder)category).option(arg_0));
                continue;
            }
            if (Float.class.isAssignableFrom(type)) {
                discreteRangeAnno = (ContinuousRange[])field.getDeclaredAnnotationsByType(ContinuousRange.class);
                if (discreteRangeAnno.length > 0) {
                    range = discreteRangeAnno[0];
                    valFormatter = range.formatTranslationKey().isEmpty() ? val -> class_2561.method_43470((String)FLOAT_FORMAT.format(val)) : arg_0 -> BridgingConfigUI.lambda$createCategory$7((ContinuousRange)range, arg_0);
                    optOption2 = BridgingConfigUI.createOption(field, arg_0 -> BridgingConfigUI.lambda$createCategory$8((ContinuousRange)range, valFormatter, arg_0));
                    optOption2.ifPresent(arg_0 -> ((ConfigCategory.Builder)category).option(arg_0));
                    continue;
                }
                optOption = BridgingConfigUI.createOption(field, FloatFieldControllerBuilder::create);
                optOption.ifPresent(arg_0 -> ((ConfigCategory.Builder)category).option(arg_0));
                continue;
            }
            if (Color.class.isAssignableFrom(type)) {
                optOption3 = BridgingConfigUI.createOption(field, opt -> ColorControllerBuilder.create((Option)opt).allowAlpha(true));
                optOption3.ifPresent(arg_0 -> ((ConfigCategory.Builder)category).option(arg_0));
                continue;
            }
            if (Enum.class.isAssignableFrom(type)) {
                optOption3 = BridgingConfigUI.createOption(field, opt -> EnumControllerBuilder.create((Option)opt).enumClass(type).formatValue(val -> {
                    class_5250 class_52502;
                    if (val instanceof Translatable) {
                        Translatable translatable = (Translatable)val;
                        class_52502 = class_2561.method_43471((String)translatable.getTranslationKey());
                    } else {
                        class_52502 = class_2561.method_43470((String)((Enum)val).name());
                    }
                    return class_52502;
                }));
                optOption3.ifPresent(arg_0 -> ((ConfigCategory.Builder)category).option(arg_0));
                continue;
            }
            BridgingMod.getLogger().warn("Skipped displaying config entry '%s' as its type has no display logic".formatted(field.getName()));
        }
        return category.build();
    }

    private static Map<String, List<Field>> sortConfigIntoCategories(Class<?> configClass) {
        Field[] fields = configClass.getDeclaredFields();
        LinkedHashMap<String, List<Field>> sortedCategories = new LinkedHashMap<String, List<Field>>(fields.length);
        for (Field field : fields) {
            String firstCatName;
            int modifiers = field.getModifiers();
            if (Modifier.isFinal(modifiers) || Modifier.isStatic(modifiers) || ((HideInConfigUI[])field.getDeclaredAnnotationsByType(HideInConfigUI.class)).length > 0) continue;
            Category[] foundCategories = (Category[])field.getDeclaredAnnotationsByType(Category.class);
            String categoryName = foundCategories.length > 0 ? ((firstCatName = foundCategories[0].value()) == null ? DEFAULT_CATEGORY_NAME : firstCatName.trim().toLowerCase()) : DEFAULT_CATEGORY_NAME;
            if (!sortedCategories.containsKey(categoryName)) {
                sortedCategories.put(categoryName, new LinkedList());
            }
            ((List)sortedCategories.get(categoryName)).add(field);
        }
        return sortedCategories;
    }

    private static /* synthetic */ ControllerBuilder lambda$createCategory$8(ContinuousRange range, ValueFormatter valFormatter, Option option) {
        return ((FloatSliderControllerBuilder)((FloatSliderControllerBuilder)FloatSliderControllerBuilder.create((Option)option).range((Number)Float.valueOf(range.min()), (Number)Float.valueOf(range.max()))).step((Number)Float.valueOf(range.sliderStep()))).formatValue(valFormatter);
    }

    private static /* synthetic */ class_2561 lambda$createCategory$7(ContinuousRange range, Float val) {
        return class_2561.method_43469((String)range.formatTranslationKey(), (Object[])new Object[]{FLOAT_FORMAT.format(val)});
    }

    private static /* synthetic */ ControllerBuilder lambda$createCategory$5(DiscreteRange range, ValueFormatter valFormatter, Option option) {
        return ((IntegerSliderControllerBuilder)((IntegerSliderControllerBuilder)IntegerSliderControllerBuilder.create((Option)option).range((Number)range.min(), (Number)range.max())).step((Number)1)).formatValue(valFormatter);
    }

    private static /* synthetic */ class_2561 lambda$createCategory$4(DiscreteRange range, Integer val) {
        return class_2561.method_43469((String)range.formatTranslationKey(), (Object[])new Object[]{val.toString()});
    }
}

