/*
 * Decompiled with CFR 0.152.
 */
package me.cg360.mod.bridging.raytrace;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import me.cg360.mod.bridging.BridgingMod;
import me.cg360.mod.bridging.config.selector.PlacementAxisMode;
import me.cg360.mod.bridging.config.selector.SourcePerspective;
import me.cg360.mod.bridging.raytrace.Perspective;
import me.cg360.mod.bridging.util.GameSupport;
import me.cg360.mod.bridging.util.Path;
import net.minecraft.class_1297;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2374;
import net.minecraft.class_2382;
import net.minecraft.class_2404;
import net.minecraft.class_243;
import net.minecraft.class_2680;
import net.minecraft.class_310;
import net.minecraft.class_3545;
import net.minecraft.class_638;
import org.joml.Vector3f;
import org.joml.Vector3fc;

public class PathTraversalHandler {
    private static final double DIRECTION_SIMILARITY_THRESHOLD = 0.1;

    public static class_3545<class_2338, class_2350> getClosestAssistTarget(class_1297 player) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return null;
        }
        SourcePerspective perspectiveLock = BridgingMod.getCompatibleSourcePerspective();
        Perspective perspective = switch (perspectiveLock) {
            default -> throw new MatchException(null, null);
            case SourcePerspective.COPY_TOGGLE_PERSPECTIVE, SourcePerspective.LET_BRIDGING_MOD_DECIDE -> Perspective.fromCamera(class_310.method_1551().field_1773.method_19418());
            case SourcePerspective.ALWAYS_EYELINE -> Perspective.fromEntity(player);
        };
        List<class_2338> path = PathTraversalHandler.getViewBlockPath(player, perspective);
        Vector3f viewDirection = perspective.getLookVector();
        List<class_2350> validSides = PathTraversalHandler.getValidAssistSides(viewDirection);
        class_2350 validDirection = null;
        class_2338 validPos = null;
        for (class_2338 pos : path) {
            Optional<class_2350> firstValidDirection;
            if (!PathTraversalHandler.isBridgingPlacementAllowedAt(pos)) continue;
            class_243 collideMin = class_243.method_24954((class_2382)pos);
            class_243 collideMax = class_243.method_49273((class_2382)pos, (double)1.0, (double)1.0, (double)1.0);
            if (player.method_5829().method_993(collideMin, collideMax) || (firstValidDirection = validSides.stream().filter(dir -> PathTraversalHandler.canSideBeBuiltOffOf(pos, dir)).findFirst()).isEmpty()) continue;
            validDirection = firstValidDirection.get();
            validPos = pos;
            break;
        }
        if (validDirection == null || validPos == null) {
            return null;
        }
        return new class_3545(validPos, validDirection);
    }

    public static List<class_2338> getViewBlockPath(class_1297 player, Perspective view) {
        if (player == null) {
            return new ArrayList<class_2338>();
        }
        double playerReach = GameSupport.getReach();
        class_243 playerViewVec = player.method_5828(1.0f).method_1021(playerReach);
        class_243 worldSpaceViewEnd = playerViewVec.method_1019(player.method_30950(1.0f));
        class_243 worldSpaceCameraOrigin = view.getPosition();
        double distance = worldSpaceViewEnd.method_1022(worldSpaceCameraOrigin);
        float minDistance = BridgingMod.getConfig().getMinimumBridgeDistance() / 100.0f;
        class_243 viewDirection = new class_243(view.getLookVector());
        class_243 farVec = viewDirection.method_1021(distance);
        class_243 nearVec = farVec.method_1021((double)minDistance);
        class_2338 startPos = class_2338.method_49638((class_2374)worldSpaceCameraOrigin.method_1019(nearVec));
        class_2338 endPos = class_2338.method_49638((class_2374)worldSpaceCameraOrigin.method_1019(farVec));
        return Path.calculateBresenhamVoxels(startPos, endPos);
    }

    private static List<class_2350> getValidAssistSides(Vector3f viewDirection) {
        LinkedList<class_2350> validSides = new LinkedList<class_2350>();
        for (class_2350 direction : class_2350.values()) {
            Vector3f directionNormal = class_243.method_24954((class_2382)direction.method_10163()).method_46409();
            double similarity = viewDirection.dot((Vector3fc)directionNormal);
            if (similarity < 0.1) continue;
            validSides.add(direction.method_10153());
        }
        return validSides;
    }

    private static boolean canSideBeBuiltOffOf(class_2338 placementTarget, class_2350 checkSide) {
        PlacementAxisMode mode;
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return false;
        }
        PlacementAxisMode baseMode = BridgingMod.getConfig().getSupportedBridgeAxes();
        if (GameSupport.isControllerCrouching() ? !(mode = BridgingMod.getConfig().getSupportedBridgeAxesWhenCrouched().getPlacementAxisMode(baseMode)).isDirectionEnabled(checkSide) : !baseMode.isDirectionEnabled(checkSide)) {
            return false;
        }
        class_2338 blockPlacingOffOf = placementTarget.method_10081(checkSide.method_10163());
        if (level.method_22347(blockPlacingOffOf)) {
            return false;
        }
        if (level.method_8320(blockPlacingOffOf).method_26204() instanceof class_2404) {
            return false;
        }
        return !level.method_8320(blockPlacingOffOf).method_45474();
    }

    private static boolean isBridgingPlacementAllowedAt(class_2338 placementTarget) {
        class_638 level = class_310.method_1551().field_1687;
        if (level == null) {
            return false;
        }
        class_2680 target = level.method_8320(placementTarget);
        return BridgingMod.getConfig().isNonSolidReplaceEnabled() ? target.method_45474() : target.method_26215();
    }
}

