/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen;

import com.mojang.blaze3d.systems.RenderSystem;
import io.github.mortuusars.exposure.Exposure;
import io.github.mortuusars.exposure.ExposureClient;
import io.github.mortuusars.exposure.client.gui.Widgets;
import io.github.mortuusars.exposure.client.gui.component.SteppedZoom;
import io.github.mortuusars.exposure.client.gui.screen.element.Pager;
import io.github.mortuusars.exposure.client.image.modifier.ImageEffect;
import io.github.mortuusars.exposure.client.image.renderable.RenderableImage;
import io.github.mortuusars.exposure.client.input.Key;
import io.github.mortuusars.exposure.client.input.KeyBinding;
import io.github.mortuusars.exposure.client.input.KeyBindings;
import io.github.mortuusars.exposure.client.render.image.RenderCoordinates;
import io.github.mortuusars.exposure.client.util.GuiUtil;
import io.github.mortuusars.exposure.client.util.Minecrft;
import io.github.mortuusars.exposure.util.PagingDirection;
import io.github.mortuusars.exposure.world.camera.ExposureType;
import io.github.mortuusars.exposure.world.camera.FilmColor;
import io.github.mortuusars.exposure.world.camera.frame.Frame;
import io.github.mortuusars.exposure.world.sound.SoundEffect;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_310;
import net.minecraft.class_332;
import net.minecraft.class_344;
import net.minecraft.class_3532;
import net.minecraft.class_364;
import net.minecraft.class_4264;
import net.minecraft.class_437;
import net.minecraft.class_4597;
import org.jetbrains.annotations.NotNull;

public class FilmFrameInspectScreen
extends class_437 {
    public static final class_2960 TEXTURE = Exposure.resource("textures/gui/film_frame_inspect.png");
    public static final int BG_SIZE = 78;
    public static final int FRAME_SIZE = 54;
    protected final Pager pager = new Pager().setChangeSound(new SoundEffect(Exposure.SoundEvents.CAMERA_LENS_RING_CLICK)).onPageChanged(this::pageChanged);
    protected final SteppedZoom zoom = new SteppedZoom().zoomInSteps(4).zoomOutSteps(4).zoomPerStep(1.4).defaultZoom(1.0);
    protected final KeyBindings keyBindings;
    protected final List<Frame> frames;
    protected float zoomFactor;
    protected float x;
    protected float y;

    public FilmFrameInspectScreen(List<Frame> frames) {
        this(frames, frames.size() - 1);
    }

    public FilmFrameInspectScreen(List<Frame> frames, int startingFrame) {
        super((class_2561)class_2561.method_43473());
        KeyBinding[] keyBindingArray = new KeyBinding[7];
        keyBindingArray[0] = Key.press(Minecrft.options().field_1822).executes(() -> ((FilmFrameInspectScreen)this).method_25419());
        keyBindingArray[1] = Key.press(334).or(Key.press(61)).executes(this.zoom::zoomIn);
        keyBindingArray[2] = Key.press(333).or(Key.press(45)).executes(this.zoom::zoomOut);
        keyBindingArray[3] = Key.press(263).or(Key.press(65)).executes(this.pager::previousPage);
        keyBindingArray[4] = Key.press(262).or(Key.press(68)).executes(this.pager::nextPage);
        keyBindingArray[5] = Key.release(263).or(Key.press(65)).executes(this.pager::resetCooldown);
        keyBindingArray[6] = Key.release(262).or(Key.press(68)).executes(this.pager::resetCooldown);
        this.keyBindings = KeyBindings.of(keyBindingArray);
        this.frames = new ArrayList<Frame>(frames);
        this.initPager(startingFrame);
    }

    protected void initPager(int startingFrame) {
        this.pager.setPagesCount(this.frames.size());
        this.pager.setPage(startingFrame);
        Collections.rotate(this.frames, -startingFrame);
    }

    protected void method_25426() {
        super.method_25426();
        this.zoomFactor = (float)this.field_22790 / 78.0f / (float)this.zoom.getZoomPerStep();
        class_344 previousButton = new class_344(0, (int)((float)this.field_22790 / 2.0f - 8.0f), 16, 16, Widgets.PREVIOUS_BUTTON_SPRITES, button -> this.pager.changePage(PagingDirection.PREVIOUS), (class_2561)class_2561.method_43471((String)"gui.exposure.previous_page"));
        this.method_37063((class_364)previousButton);
        class_344 nextButton = new class_344(this.field_22789 - 16, (int)((float)this.field_22790 / 2.0f - 8.0f), 16, 16, Widgets.NEXT_BUTTON_SPRITES, button -> this.pager.changePage(PagingDirection.NEXT), (class_2561)class_2561.method_43471((String)"gui.exposure.next_page"));
        this.method_37063((class_364)nextButton);
        this.pager.setPagesCount(this.frames.size()).setPreviousPageButton((class_4264)previousButton).setNextPageButton((class_4264)nextButton);
    }

    protected Frame getCurrentFrame() {
        return this.frames.getFirst();
    }

    protected void pageChanged(int oldPage, int newPage) {
        int distance = newPage - oldPage;
        Collections.rotate(this.frames, -distance);
    }

    public void method_25394(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        float scale = (float)(this.zoom.get() * (double)this.zoomFactor);
        RenderSystem.enableBlend();
        RenderSystem.defaultBlendFunc();
        RenderSystem.disableDepthTest();
        this.method_52752(guiGraphics);
        guiGraphics.method_51448().method_22903();
        guiGraphics.method_51448().method_46416(this.x, this.y, 0.0f);
        guiGraphics.method_51448().method_46416((float)this.field_22789 / 2.0f, (float)this.field_22790 / 2.0f, 50.0f);
        guiGraphics.method_51448().method_22905(scale, scale, scale);
        guiGraphics.method_51448().method_46416(-39.0f, -39.0f, 0.0f);
        RenderSystem.setShaderTexture((int)0, (class_2960)TEXTURE);
        GuiUtil.blit(guiGraphics.method_51448(), 0.0f, 0.0f, 78.0f, 78.0f, 0, 0, 256, 256, 0.0f);
        Frame frame = this.getCurrentFrame();
        ExposureType filmType = frame.type();
        FilmColor filmColor = filmType.getFilmColor();
        RenderSystem.setShaderColor((float)filmColor.r(), (float)filmColor.g(), (float)filmColor.b(), (float)filmColor.a());
        GuiUtil.blit(guiGraphics.method_51448(), 0.0f, 0.0f, 78.0f, 78.0f, 0, 78, 256, 256, 0.0f);
        RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        guiGraphics.method_51448().method_46416(12.0f, 12.0f, 0.0f);
        RenderableImage image = ExposureClient.renderedExposures().getOrCreate(frame).modifyWith(ImageEffect.NEGATIVE_FILM);
        class_4597.class_4598 bufferSource = class_310.method_1551().method_22940().method_23000();
        ExposureClient.imageRenderer().render(image, guiGraphics.method_51448(), (class_4597)bufferSource, new RenderCoordinates(0.0f, 0.0f, 54.0f, 54.0f), filmType.getImageColor());
        bufferSource.method_22993();
        guiGraphics.method_51448().method_22909();
        guiGraphics.method_51448().method_22903();
        super.method_25394(guiGraphics, mouseX, mouseY, partialTick);
        guiGraphics.method_51448().method_22909();
    }

    public void method_25420(class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
    }

    public boolean method_25404(int keyCode, int scanCode, int modifiers) {
        return this.keyBindings.keyPressed(keyCode, scanCode, modifiers) || super.method_25404(keyCode, scanCode, modifiers);
    }

    public boolean method_16803(int keyCode, int scanCode, int modifiers) {
        return this.keyBindings.keyReleased(keyCode, scanCode, modifiers) || super.method_16803(keyCode, scanCode, modifiers);
    }

    public boolean method_25401(double mouseX, double mouseY, double scrollX, double scrollY) {
        if (super.method_25401(mouseX, mouseY, scrollX, scrollY)) {
            return true;
        }
        if (scrollY >= 0.0) {
            this.zoom.zoomIn();
        } else {
            this.zoom.zoomOut();
        }
        return true;
    }

    public boolean method_25403(double mouseX, double mouseY, int button, double dragX, double dragY) {
        if (super.method_25403(mouseX, mouseY, button, dragX, dragY)) {
            return true;
        }
        if (button == 0) {
            float centerX = (float)this.field_22789 / 2.0f;
            float centerY = (float)this.field_22790 / 2.0f;
            this.x = (float)class_3532.method_15350((double)((double)this.x + dragX), (double)(-centerX), (double)centerX);
            this.y = (float)class_3532.method_15350((double)((double)this.y + dragY), (double)(-centerY), (double)centerY);
            return true;
        }
        return false;
    }

    public boolean method_25421() {
        return false;
    }
}

