/*
 * Decompiled with CFR 0.152.
 */
package io.github.mortuusars.exposure.client.gui.screen.camera.button;

import io.github.mortuusars.exposure.Config;
import io.github.mortuusars.exposure.client.gui.component.CycleButton;
import io.github.mortuusars.exposure.world.camera.component.ShutterSpeed;
import java.util.List;
import java.util.concurrent.ThreadLocalRandom;
import java.util.function.Function;
import net.minecraft.class_1109;
import net.minecraft.class_1113;
import net.minecraft.class_1144;
import net.minecraft.class_310;
import net.minecraft.class_327;
import net.minecraft.class_332;
import net.minecraft.class_3414;
import net.minecraft.class_8666;
import org.jetbrains.annotations.NotNull;

public class ShutterSpeedButton
extends CycleButton<ShutterSpeed> {
    protected final int secondaryFontColor;
    protected final int mainFontColor = Config.getColor(Config.Client.VIEWFINDER_FONT_MAIN_COLOR);

    public ShutterSpeedButton(int x, int y, int width, int height, List<ShutterSpeed> values, @NotNull ShutterSpeed startingValue, Function<ShutterSpeed, class_8666> spritesFunc, CycleButton.OnCycle<ShutterSpeed> onCycle) {
        super(x, y, width, height, values, startingValue, spritesFunc, onCycle);
        this.secondaryFontColor = Config.getColor(Config.Client.VIEWFINDER_FONT_SECONDARY_COLOR);
    }

    public ShutterSpeedButton(int x, int y, int width, int height, List<ShutterSpeed> values, @NotNull ShutterSpeed startingValue, Function<ShutterSpeed, class_8666> spritesFunc) {
        super(x, y, width, height, values, startingValue, spritesFunc, (CycleButton<T> button, T newValue) -> {});
        this.secondaryFontColor = Config.getColor(Config.Client.VIEWFINDER_FONT_SECONDARY_COLOR);
    }

    @Override
    public void method_25354(class_1144 handler) {
        if (this.clickSound != null) {
            handler.method_4873((class_1113)class_1109.method_4757((class_3414)this.clickSound, (float)(ThreadLocalRandom.current().nextFloat() * 0.05f + 0.9f + (float)this.currentIndex * 0.01f), (float)0.7f));
        }
    }

    @Override
    public void method_48579(@NotNull class_332 guiGraphics, int mouseX, int mouseY, float partialTick) {
        super.method_48579(guiGraphics, mouseX, mouseY, partialTick);
        ShutterSpeed shutterSpeed = (ShutterSpeed)this.getCurrentValue();
        Object text = shutterSpeed.getNotation().replace("1/", "");
        if (shutterSpeed.equals(ShutterSpeed.DEFAULT)) {
            text = (String)text + "\u2022";
        }
        class_327 font = class_310.method_1551().field_1772;
        int textWidth = font.method_1727((String)text);
        int xPos = this.field_22758 / 2 - textWidth / 2 + 1;
        guiGraphics.method_51433(font, (String)text, this.method_46426() + xPos, this.method_46427() + 4, this.secondaryFontColor, false);
        guiGraphics.method_51433(font, (String)text, this.method_46426() + xPos, this.method_46427() + 3, this.mainFontColor, false);
    }
}

